/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.instance;

import java.util.List;
import org.apache.felix.ipojo.CompositeHandler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.instance.InstanceHandler;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class InstanceHandlerDescription
extends HandlerDescription {
    private List m_instances;

    public InstanceHandlerDescription(CompositeHandler h, List insts) {
        super(h);
        this.m_instances = insts;
    }

    public Element getHandlerInfo() {
        Element instances = super.getHandlerInfo();
        for (int i = 0; i < this.m_instances.size(); ++i) {
            InstanceHandler.ManagedConfiguration inst = (InstanceHandler.ManagedConfiguration)this.m_instances.get(i);
            Element instance = new Element("Instance", "");
            if (inst.getInstance() != null) {
                instance.addAttribute(new Attribute("Factory", inst.getFactory()));
                instance.addAttribute(new Attribute("Name", inst.getInstance().getInstanceName()));
                String state = null;
                switch (inst.getInstance().getState()) {
                    case -1: {
                        state = "disposed";
                        break;
                    }
                    case 0: {
                        state = "stopped";
                        break;
                    }
                    case 2: {
                        state = "valid";
                        break;
                    }
                    case 1: {
                        state = "invalid";
                        break;
                    }
                }
                instance.addAttribute(new Attribute("State", state));
                instance.addElement(inst.getInstance().getInstanceDescription().getDescription());
            } else {
                instance.addAttribute(new Attribute("Factory", inst.getConfiguration().get("component").toString()));
                instance.addAttribute(new Attribute("State", "Not Available"));
            }
            instances.addElement(instance);
        }
        return instances;
    }
}

