/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.domain;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.management.tools.ManagementRepr;
import org.ow2.jonas.management.extensions.domain.api.IDomain;

public class DomainManagement
extends BaseManagement
implements IDomain {
    private static final String masterAttribute = "master";
    private static final String serverNamesAttribute = "serverNames";
    private static final String serversAttribute = "serves";
    private static final String clustersAttribute = "clusters";
    private static final String clusterDaemonsAttribute = "clusterDaemons";
    private static final String clusterdaemonNamesAttribute = "clusterdaemonNames";
    private ObjectName domainOn = J2eeObjectName.J2EEDomain((String)this.getDomainName());

    public boolean isMaster(String pServer) {
        return (Boolean)ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)masterAttribute, (String)pServer);
    }

    public boolean isMaster() {
        return (Boolean)ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)masterAttribute, (String)this.getServerName());
    }

    public String getClusterType(String clusterName) {
        String operation = "getClusterType";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String[] getServerNames() {
        return (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)serverNamesAttribute, (String)this.getServerName());
    }

    public String[] getServerNames(String clusterName) {
        String operation = "getServersInCluster";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String[])ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String[] getClusters() {
        return (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)clustersAttribute, (String)this.getServerName());
    }

    public String[] getclusterDaemons() {
        return (String[])ManagementRepr.getAttribute((ObjectName)this.domainOn, (String)clusterDaemonsAttribute, (String)this.getServerName());
    }

    public String getServerState(String serverName) {
        String operation = "getServerState";
        Object[] param = new Object[]{serverName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getServerClusterdaemon(String serverName) {
        String operation = "getServerClusterdaemon";
        Object[] param = new Object[]{serverName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getClusterState(String clusterName) {
        String operation = "getClusterState";
        Object[] param = new Object[]{clusterName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        String operation = "getClusterdaemonState";
        Object[] param = new Object[]{clusterdaemonName};
        String[] signature = new String[]{"java.lang.String"};
        return (String)ManagementRepr.invoke((ObjectName)this.domainOn, (String)operation, (Object[])param, (String[])signature, (String)this.getServerName());
    }

    public String[] getClustersNames() {
        int i;
        String[] clusters = this.getClusters();
        ArrayList<String> clustersNames = new ArrayList<String>();
        String[] names = null;
        for (i = 0; i < clusters.length; ++i) {
            ObjectName on = null;
            try {
                on = ObjectName.getInstance(clusters[i]);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            String clusterName = on.getKeyProperty("name");
            if (!clusterName.equals(this.getDomainName())) {
                clustersNames.add(clusterName);
            }
            on = null;
        }
        names = new String[clustersNames.size()];
        for (i = 0; i < clustersNames.size(); ++i) {
            names[i] = (String)clustersNames.get(i);
        }
        return names;
    }

    public String[] getClusterdaemonNames() {
        String[] cdm = this.getclusterDaemons();
        String[] names = new String[cdm.length];
        for (int i = 0; i < cdm.length; ++i) {
            ObjectName on = null;
            try {
                on = ObjectName.getInstance(cdm[i]);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            names[i] = on.getKeyProperty("name");
            on = null;
        }
        return names;
    }
}

