/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.msg;

import fr.dyade.aaa.jndi2.msg.JndiRequest;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import javax.naming.BinaryRefAddr;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class BindRequest
extends JndiRequest {
    private static final long serialVersionUID = 1L;
    private Object obj;
    private boolean rebind;

    public BindRequest(CompositeName name, Object obj) throws NamingException {
        this(name, obj, false);
    }

    public BindRequest(CompositeName name, Object obj, boolean rebind) throws NamingException {
        super(name);
        this.obj = obj == null || obj instanceof byte[] || obj instanceof Reference ? obj : (obj instanceof Referenceable ? ((Referenceable)obj).getReference() : BindRequest.toReference(obj));
        this.rebind = rebind;
    }

    public final Object getObject() {
        return this.obj;
    }

    public final boolean isRebind() {
        return this.rebind;
    }

    private static Reference toReference(Object obj) throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byte[] bytes = baos.toByteArray();
            Reference ref = new Reference(obj.getClass().getName(), new BinaryRefAddr("", bytes), "fr.dyade.aaa.jndi2.msg.ObjectFactory", null);
            return ref;
        }
        catch (Exception exc) {
            NamingException ne = new NamingException();
            ne.setRootCause(exc);
            throw ne;
        }
    }

    public String toString() {
        return '(' + super.toString() + ",rebind=" + this.rebind + ')';
    }
}

