/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.axis.security.conversation;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.ws.sandbox.axis.security.conversation.ConvHandlerConstants;
import org.apache.ws.sandbox.security.conversation.ConversationEngine;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationManager;
import org.apache.ws.sandbox.security.conversation.ConversationUtil;
import org.apache.ws.sandbox.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.sandbox.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.sandbox.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.sandbox.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.sandbox.security.trust.message.token.RequestSecurityTokenResponse;
import org.apache.ws.sandbox.security.trust.message.token.RequestedProofToken;
import org.apache.ws.sandbox.security.trust.message.token.RequestedSecurityToken;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConversationClientHandler
extends BasicHandler {
    private static Log log = LogFactory.getLog((class$org$apache$ws$sandbox$axis$security$conversation$ConversationClientHandler == null ? (class$org$apache$ws$sandbox$axis$security$conversation$ConversationClientHandler = ConversationClientHandler.class$("org.apache.ws.sandbox.axis.security.conversation.ConversationClientHandler")) : class$org$apache$ws$sandbox$axis$security$conversation$ConversationClientHandler).getName());
    private int keyLen = -1;
    private RequestSecurityTokenResponse stRes;
    private static DerivedKeyCallbackHandler dkcbHandler = new DerivedKeyCallbackHandler();
    private WSSecurityEngine secEng = null;
    private static String uuid = null;
    private Crypto serverCrypto = null;
    private String serverAlias = null;
    private Crypto reqCrypto = null;
    private Crypto stsCrypto = null;
    private int sctEstablishment = -1;
    private static boolean handShakeDone = false;
    private boolean isSCTavailabe = false;
    private static boolean isConfigured = false;
    private boolean readCrypto = false;
    private String appliesTo = null;
    private boolean isSessionInfoConfigured = false;
    private boolean usedFixedKeys = true;
    private HashMap configurator;
    int[] actionsInt;
    static /* synthetic */ Class class$org$apache$ws$sandbox$axis$security$conversation$ConversationClientHandler;

    public ConversationClientHandler() throws AxisFault {
        log.debug("ConversationClientHandler :: created");
    }

    public ConversationClientHandler(DerivedKeyCallbackHandler dk) throws AxisFault {
        dkcbHandler = dk;
        log.debug("ConversationClientHandler :: created");
    }

    public void invoke(MessageContext msg) throws AxisFault {
        log.debug("ConversationClientHandler :: invoked");
        System.out.println("ConversationClientHandler :: invoked");
        if (msg.getPastPivot()) {
            this.doResponse(msg);
        } else {
            this.doRequest(msg);
        }
    }

    private void doRequest(MessageContext msg) throws AxisFault {
        if (!this.isSessionInfoConfigured) {
            this.initSessionInfo();
            this.isSessionInfoConfigured = true;
        }
        Message sm = msg.getCurrentMessage();
        Document doc = null;
        if (!handShakeDone) {
            this.decodeSCTEstabParameter();
            this.loadCrypto();
            switch (this.sctEstablishment) {
                case 1: {
                    this.doHandshake_Direct_Generated(sm);
                    break;
                }
                case 2: {
                    this.doHandshake_STS_Generated(sm);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new AxisFault("Unsupored STS establishment method.");
                }
            }
            handShakeDone = true;
        } else {
            log.debug("Token in memory .");
            SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
            try {
                doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            }
            catch (Exception e) {
                throw new AxisFault("CoversationClientHandler :: Cannot get the document");
            }
            try {
                Element securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
                WSSecurityUtil.appendChildElement(doc, securityHeader, new SecurityContextToken(doc, uuid).getElement());
                ConversationManager manager = new ConversationManager();
                for (int i = 0; i < this.actionsInt.length; ++i) {
                    DerivedKeyInfo dkInfo = manager.createDerivedKeyToken(doc, uuid, dkcbHandler, null, this.keyLen);
                    String genID = dkInfo.getId();
                    SecurityTokenReference stRef = dkInfo.getSecTokRef2DkToken();
                    if (this.actionsInt[i] == 2) {
                        manager.performDK_ENCR(ConversationUtil.generateIdentifier(uuid, genID), "", true, doc, stRef, dkcbHandler, null, (String)this.configurator.get("dkEncryptionAlgorithm"));
                    } else if (this.actionsInt[i] == 1) {
                        manager.performDK_Sign(doc, dkcbHandler, uuid, dkInfo, null);
                    }
                    manager.addDkToken(doc, dkInfo);
                }
            }
            catch (ConversationException e1) {
                e1.printStackTrace();
                throw new AxisFault("ConversationClientHandler ::" + e1.getMessage());
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM(doc, os, true);
            String osStr = os.toString();
            sPart.setCurrentMessage(osStr, 1);
        }
    }

    private void doResponse(MessageContext msgContext) throws AxisFault {
        Document doc = null;
        if (!this.isSessionInfoConfigured) {
            this.initSessionInfo();
            this.isSessionInfoConfigured = true;
        }
        Message message = msgContext.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        Object obj = null;
        obj = msgContext.getProperty("DkcbHandler");
        if (obj != null) {
            dkcbHandler = (DerivedKeyCallbackHandler)obj;
        }
        try {
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: cannot get SOAP envlope from message" + e);
        }
        log.debug("I am in ClientHandler Response");
        try {
            ConversationEngine convEng = new ConversationEngine(this.configurator);
            Vector results = convEng.processSecConvHeader(doc, "", dkcbHandler, (String)this.configurator.get("passwordCallbackClass"));
        }
        catch (ConversationException e1) {
            e1.printStackTrace();
            throw new AxisFault("CovnersationServerHandler :: " + e1.getMessage());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLUtils.outputDOM(doc, os, true);
        sPart.setCurrentMessage(os.toByteArray(), 4);
        ArrayList<QName> processedHeaders = new ArrayList<QName>();
        Iterator iterator = message.getSOAPEnvelope().getHeaders().iterator();
        while (iterator.hasNext()) {
            SOAPHeaderElement tempHeader = (SOAPHeaderElement)iterator.next();
            if (!tempHeader.isProcessed()) continue;
            processedHeaders.add(tempHeader.getQName());
        }
        iterator = processedHeaders.iterator();
        while (iterator.hasNext()) {
            QName qname = (QName)iterator.next();
            Enumeration enumHeaders = message.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
            while (enumHeaders.hasMoreElements()) {
                SOAPHeaderElement tempHeader = (SOAPHeaderElement)enumHeaders.nextElement();
                tempHeader.setProcessed(true);
            }
        }
        SOAPHeader sHeader = null;
        try {
            sHeader = message.getSOAPEnvelope().getHeader();
        }
        catch (Exception ex) {
            throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", ex);
        }
        Iterator headers = sHeader.examineHeaderElements("");
        SOAPHeaderElement headerElement = null;
        while (headers.hasNext()) {
            SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
            if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
            headerElement = hE;
            break;
        }
        headerElement.setProcessed(true);
        System.out.println("I am in ClientHndelr Response");
    }

    private void doHandshake_Direct_Generated(Message sm) throws AxisFault {
        Document doc = null;
        SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
        try {
            log.debug("ConversationClientHandler :: Trust Not required");
            doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            this.initSessionInfo();
            this.stRes = new RequestSecurityTokenResponse(doc, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e.getMessage());
        }
        uuid = this.stRes.getRequestedSecurityToken().getSct().getIdentifier();
        this.stRes.build(doc);
        this.isSCTavailabe = true;
        RequestedProofToken reqProof = this.stRes.getRequestedProofToken();
        try {
            reqProof.doEncryptProof(doc, this.serverCrypto, this.serverAlias);
            SecurityContextInfo info = new SecurityContextInfo(this.stRes.getRequestedSecurityToken().getSct(), reqProof, (int)((Integer)this.configurator.get("keyFrequency")));
            DerivedKeyCallbackHandler.addSecurtiyContext(uuid, info);
            if (this.usedFixedKeys) {
                Long ln = new Long(Integer.toString(this.keyLen));
                DerivedKeyCallbackHandler.setDerivedKeyLength(uuid, ln);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM(doc, os, true);
            String osStr = os.toString();
            sPart.setCurrentMessage(osStr, 1);
        }
        catch (WSSecurityException e2) {
            e2.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e2.getMessage());
        }
        catch (ConversationException e2) {
            e2.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e2.getMessage());
        }
    }

    private void doHandshake_STS_Generated(Message sm) throws AxisFault {
        Document doc = null;
        Object meArrRes = null;
        String tmpStr = null;
        tmpStr = (String)this.getOption("stsAddress");
        if (tmpStr == null) {
            throw new AxisFault("STS address is not set.");
        }
        String stsEndPoint = tmpStr;
        tmpStr = (String)this.getOption("appliesToValue");
        if (tmpStr != null) {
            log.debug("Applies to value is read ::" + tmpStr);
            this.appliesTo = tmpStr;
        }
        if ((tmpStr = (String)this.getOption("pwcallback")) == null) {
            throw new AxisFault("PasswordCallbackHandler is not set.");
        }
        String callbackHandler = tmpStr;
        SecurityContextToken sct = null;
        RequestedProofToken proof = null;
        log.debug("Trust communitcator successfully completed.");
        try {
            NodeImpl tmpEle = null;
            for (int i = 0; i < (meArrRes).length; ++i) {
                tmpEle = meArrRes[i];
                QName el = new QName(tmpEle.getNamespaceURI(), tmpEle.getLocalName());
                Element domEle = ((MessageElement)tmpEle).getAsDOM();
                if (el.equals(RequestedSecurityToken.TOKEN)) {
                    log.debug("Recognized RequestedSecurityToken.");
                    NodeList ndList = domEle.getElementsByTagNameNS(SecurityContextToken.TOKEN.getNamespaceURI(), SecurityContextToken.TOKEN.getLocalPart());
                    if (ndList.getLength() < 0) {
                        throw new AxisFault("Unspported yet ..");
                    }
                    sct = new SecurityContextToken((Element)ndList.item(0));
                    SOAPHeader soapHeader = sm.getSOAPHeader();
                    soapHeader.addChildElement("Security", "wsse", WSConstants.WSSE_NS);
                    Iterator it = soapHeader.getChildElements();
                    while (it.hasNext()) {
                        SOAPHeaderElement shSecElem = (SOAPHeaderElement)it.next();
                        if (!shSecElem.getLocalName().equals("Security")) continue;
                        MessageElement rstr = new MessageElement(RequestSecurityTokenResponse.TOKEN.getLocalPart(), RequestSecurityTokenResponse.TOKEN.getPrefix(), RequestSecurityTokenResponse.TOKEN.getNamespaceURI());
                        rstr.addChild((MessageElement)tmpEle);
                        shSecElem.addChildElement(rstr);
                    }
                    continue;
                }
                if (!el.equals(RequestedProofToken.TOKEN)) continue;
                SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
                doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
                proof = new RequestedProofToken(domEle);
                proof.doDecryption(callbackHandler, this.serverCrypto);
                byte[] bkArr = proof.getSharedSecret();
                RequestedProofToken newProof = new RequestedProofToken(doc);
                newProof.setSharedSecret(bkArr);
                newProof.doEncryptProof(doc, this.serverCrypto, this.serverAlias);
                Element secHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), true);
                Element ele = (Element)WSSecurityUtil.findElement(secHeader, RequestSecurityTokenResponse.TOKEN.getLocalPart(), RequestSecurityTokenResponse.TOKEN.getNamespaceURI());
                ele.appendChild(newProof.getElement());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM(doc, os, true);
                String osStr = os.toString();
                sPart.setCurrentMessage(osStr, 1);
            }
            this.initSessionInfo();
            Integer keyFreq = (Integer)this.configurator.get("keyFrequency");
            SecurityContextInfo sctInfo = new SecurityContextInfo(sct, proof, (int)keyFreq);
            uuid = sct.getIdentifier();
            DerivedKeyCallbackHandler.addSecurtiyContext(uuid, sctInfo);
            Boolean isFixedKey = (Boolean)this.configurator.get("useFixedKeyLegnth");
            if (this.usedFixedKeys) {
                Long keyLen = (Long)this.configurator.get("keyLegnth");
                DerivedKeyCallbackHandler.setDerivedKeyLength(uuid, keyLen);
            }
            handShakeDone = true;
        }
        catch (WSSecurityException e3) {
            e3.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e3.getMessage());
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e.getMessage());
        }
        catch (Exception e3) {
            e3.printStackTrace();
            throw new AxisFault("ConversationClientHandler ::" + e3.getMessage());
        }
    }

    private void initSessionInfo() throws AxisFault {
        this.configurator = new HashMap();
        String tmpStr = (String)this.getOption("keyFrequency");
        if (tmpStr != null) {
            log.debug("Key Frequency is set ::" + tmpStr);
            this.configurator.put("keyFrequency", new Integer(tmpStr));
        }
        if ((tmpStr = (String)this.getOption("derivedKeyAction")) != null) {
            log.debug("Derived Key Action is read ::" + tmpStr);
            String[] action = StringUtil.split(tmpStr, ' ');
            this.actionsInt = new int[action.length];
            for (int i = 0; i < action.length; ++i) {
                if (action[i].equalsIgnoreCase("Signature")) {
                    this.actionsInt[i] = 1;
                    continue;
                }
                if (!action[i].equalsIgnoreCase("Encrypt")) continue;
                this.actionsInt[i] = 2;
            }
        }
        if ((tmpStr = (String)this.getOption("keyLegnth")) != null) {
            log.debug("Key Frequency is set ::" + tmpStr);
            this.keyLen = Integer.parseInt(tmpStr);
            this.configurator.put("keyLegnth", new Long(tmpStr));
        }
        if ((tmpStr = (String)this.getOption("passwordCallbackClass")) != null) {
            this.configurator.put("passwordCallbackClass", tmpStr);
        }
        if ((tmpStr = (String)this.getOption("dkEncryptionAlgorithm")) != null) {
            this.configurator.put("dkEncryptionAlgorithm", tmpStr);
        }
    }

    private void decodeSCTEstabParameter() throws AxisFault {
        String tmpStr = (String)this.getOption("sctEstablishmentMtd");
        log.debug("ConversationClientHandler :: Decording SCT establishing parameter");
        if (tmpStr.equals(null)) {
            throw new AxisFault("SCT establishing method not specified.");
        }
        Integer i = (Integer)ConvHandlerConstants.sctEstablishmentMapper.get(tmpStr);
        this.sctEstablishment = i;
    }

    private int decodeSTSRequesterTypeParamer() throws AxisFault {
        String tmpStr = (String)this.getOption("stsRequestorType");
        log.debug("ConversationClientHandler :: Decording STS requeter type parameter");
        if (tmpStr.equals(null)) {
            throw new AxisFault("STS requeter type not specified.");
        }
        Integer i = (Integer)ConvHandlerConstants.requesterTypeMapper.get(tmpStr);
        return i;
    }

    private void loadCrypto() throws AxisFault {
        String tmpStr = null;
        tmpStr = (String)this.getOption("serverPropFile");
        if (tmpStr == null) {
            throw new AxisFault("Error! No server server properties file in wsdd");
        }
        log.debug("Server prop file is " + tmpStr);
        this.serverCrypto = CryptoFactory.getInstance(tmpStr);
        tmpStr = (String)this.getOption("serverAlias");
        if (tmpStr == null) {
            throw new AxisFault("Error! No server server properties file in wsdd");
        }
        this.serverAlias = tmpStr;
    }

    private void decodeDkAction() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

