/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.xml.xmlbeans.x2004.x02.xbean.config.ConfigDocument;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.XmlErrorWatcher;
import org.apache.xmlbeans.impl.config.SchemaConfig;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemImpl;
import org.apache.xmlbeans.impl.schema.StscChecker;
import org.apache.xmlbeans.impl.schema.StscImporter;
import org.apache.xmlbeans.impl.schema.StscJavaizer;
import org.apache.xmlbeans.impl.schema.StscResolver;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.schema.StscTranslator;
import org.w3.x2001.xmlSchema.SchemaDocument;

public class SchemaTypeSystemCompiler {
    public static SchemaTypeSystem compile(Parameters params) {
        return SchemaTypeSystemCompiler.compileImpl(params.getName(), params.getSchemas(), params.getConfigs(), params.getLinkTo(), params.getOptions(), params.getErrorListener(), params.isJavaize(), params.getBaseURI(), params.getSourcesToCopyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SchemaTypeSystemImpl compileImpl(String name, SchemaDocument.Schema[] schemas, ConfigDocument.Config[] configs, SchemaTypeLoader linkTo, XmlOptions options, Collection outsideErrors, boolean javaize, URI baseURI, Map sourcesToCopyMap) {
        if (linkTo == null) {
            throw new IllegalArgumentException("Must supply linkTo");
        }
        XmlErrorWatcher errorWatcher = new XmlErrorWatcher(outsideErrors);
        StscState state = StscState.start();
        boolean validate = options == null || !options.hasOption("COMPILE_NO_VALIDATION");
        try {
            state.setErrorListener(errorWatcher);
            state.setSchemaConfig(SchemaConfig.forConfigDocuments(configs));
            state.setOptions(options);
            state.setGivenTypeSystemName(name);
            if (baseURI != null) {
                state.setBaseUri(baseURI);
            }
            linkTo = SchemaTypeLoaderImpl.build(new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get(), linkTo}, null, null);
            state.setImportingTypeLoader(linkTo);
            ArrayList<SchemaDocument.Schema> validSchemas = new ArrayList<SchemaDocument.Schema>(schemas.length);
            if (validate) {
                for (int i = 0; i < schemas.length; ++i) {
                    if (!schemas[i].validate(new XmlOptions().setErrorListener(errorWatcher))) continue;
                    validSchemas.add(schemas[i]);
                }
            } else {
                validSchemas.addAll(Arrays.asList(schemas));
            }
            SchemaDocument.Schema[] startWith = validSchemas.toArray(new SchemaDocument.Schema[validSchemas.size()]);
            StscImporter.SchemaToProcess[] schemasAndChameleons = StscImporter.resolveImportsAndIncludes(startWith);
            StscTranslator.addAllDefinitions(schemasAndChameleons);
            StscResolver.resolveAll();
            StscChecker.checkAll();
            StscJavaizer.javaizeAllTypes(javaize);
            state.get().sts().loadFromStscState(state);
            if (sourcesToCopyMap != null) {
                sourcesToCopyMap.putAll(state.sourceCopyMap());
            }
            if (errorWatcher.hasError()) {
                SchemaTypeSystemImpl schemaTypeSystemImpl = null;
                return schemaTypeSystemImpl;
            }
            SchemaTypeSystemImpl schemaTypeSystemImpl = state.get().sts();
            return schemaTypeSystemImpl;
        }
        finally {
            StscState.end();
        }
    }

    public static class Parameters {
        private String name;
        private SchemaDocument.Schema[] schemas;
        private ConfigDocument.Config[] configs;
        private SchemaTypeLoader linkTo;
        private XmlOptions options;
        private Collection errorListener;
        private boolean javaize;
        private URI baseURI;
        private Map sourcesToCopyMap;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SchemaDocument.Schema[] getSchemas() {
            return this.schemas;
        }

        public void setSchemas(SchemaDocument.Schema[] schemas) {
            this.schemas = schemas;
        }

        public ConfigDocument.Config[] getConfigs() {
            return this.configs;
        }

        public void setConfigs(ConfigDocument.Config[] configs) {
            this.configs = configs;
        }

        public SchemaTypeLoader getLinkTo() {
            return this.linkTo;
        }

        public void setLinkTo(SchemaTypeLoader linkTo) {
            this.linkTo = linkTo;
        }

        public XmlOptions getOptions() {
            return this.options;
        }

        public void setOptions(XmlOptions options) {
            this.options = options;
        }

        public Collection getErrorListener() {
            return this.errorListener;
        }

        public void setErrorListener(Collection errorListener) {
            this.errorListener = errorListener;
        }

        public boolean isJavaize() {
            return this.javaize;
        }

        public void setJavaize(boolean javaize) {
            this.javaize = javaize;
        }

        public URI getBaseURI() {
            return this.baseURI;
        }

        public void setBaseURI(URI baseURI) {
            this.baseURI = baseURI;
        }

        public Map getSourcesToCopyMap() {
            return this.sourcesToCopyMap;
        }

        public void setSourcesToCopyMap(Map sourcesToCopyMap) {
            this.sourcesToCopyMap = sourcesToCopyMap;
        }
    }
}

