/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.AbstractCollection;
import org.jboss.util.collection.EmptyCollectionException;
import org.jboss.util.collection.FullCollectionException;
import org.jboss.util.collection.Queue;

public abstract class AbstractQueue
extends AbstractCollection
implements Queue {
    public static int DEFAULT_MAXIMUM_SIZE = -1;
    protected int maximumSize = DEFAULT_MAXIMUM_SIZE;

    protected AbstractQueue() {
    }

    protected AbstractQueue(int maxSize) {
        this.setMaximumSize(maxSize);
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int size) {
        if (size < 0 && size != -1) {
            throw new IllegalArgumentException("illegal size: " + size);
        }
        this.maximumSize = size;
    }

    public boolean isFull() {
        return this.maximumSize != -1 && this.size() >= this.maximumSize;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public boolean add(Object obj) throws FullCollectionException {
        if (this.isFull()) {
            throw new FullCollectionException();
        }
        return this.addLast(obj);
    }

    public Object remove() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.removeFirst();
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.remove();
        }
    }

    protected abstract boolean addLast(Object var1);

    protected abstract Object removeFirst();
}

