/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class RdbAdapterFactory {
    public static final String DATABASE_NAME_JDBC = "jdbc";
    private static Properties product2adapter = new Properties();

    public static Map getProductName2Adapter() {
        return Collections.unmodifiableMap(product2adapter);
    }

    public static RdbAdapter getTypeConverter(String dbn) throws RdbAdapterException {
        if (dbn == null || dbn.length() == 0 || dbn.equals(DATABASE_NAME_JDBC)) {
            return new BasicRdbAdapter();
        }
        String n = null;
        RdbAdapter res = null;
        try {
            n = "org.objectweb.jorm.mapper.rdb.adapter." + Character.toUpperCase(dbn.charAt(0)) + dbn.substring(1, dbn.length()).toLowerCase() + "Adapter";
            res = (RdbAdapter)Class.forName(n).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RdbAdapterException(e, "Cannot find an adapter class for this database: " + dbn);
        }
        catch (ClassCastException e) {
            throw new RdbAdapterException(e, "The specified adpater name is not a RdbAdapter: " + n);
        }
        catch (Exception e) {
            throw new RdbAdapterException(e, "Impossible to instanciate the following rdb adapter class: " + n);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static RdbAdapter getTypeConverter(DataSource ds) throws RdbAdapterException {
        String adapterName;
        block18: {
            Connection conn = null;
            adapterName = null;
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                throw new RdbAdapterException("Impossible to fetch connection with the specified data source: " + ds);
            }
            String productName = conn.getMetaData().getDatabaseProductName();
            adapterName = product2adapter.getProperty(productName);
            Object var5_9 = null;
            try {
                if (conn != null) {
                    conn.close();
                }
                break block18;
            }
            catch (SQLException e2) {}
            break block18;
            {
                catch (SQLException e) {
                    adapterName = null;
                    Object var5_10 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block18;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (adapterName == null) {
            throw new RdbAdapterException("Cannot find automatically a rdb adapter for the data source, please try to define a mapper name like 'rdb.oracle', \ndatasource=" + ds);
        }
        try {
            return (RdbAdapter)Class.forName(adapterName).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RdbAdapterException(e, "The specified adpater name is not a availlable in the classpath: " + adapterName);
        }
        catch (ClassCastException e) {
            throw new RdbAdapterException(e, "The specified adpater name is not a RdbAdapter: " + adapterName);
        }
        catch (Exception e) {
            throw new RdbAdapterException(e, "Impossible to instanciate the following rdb adapter class: " + adapterName);
        }
    }

    static {
        product2adapter.setProperty("PostgreSQL", "org.objectweb.jorm.mapper.rdb.adapter.PostgresAdapter");
        product2adapter.setProperty("DB2", "org.objectweb.jorm.mapper.rdb.adapter.Db2Adapter");
        product2adapter.setProperty("FireBird", "org.objectweb.jorm.mapper.rdb.adapter.FireBirdAdapter");
        product2adapter.setProperty("Hsql", "org.objectweb.jorm.mapper.rdb.adapter.HsqlAdapter");
        product2adapter.setProperty("McKOI", "org.objectweb.jorm.mapper.rdb.adapter.MckoiAdapter");
        product2adapter.setProperty("MySQL", "org.objectweb.jorm.mapper.rdb.adapter.MysqlAdapter");
        product2adapter.setProperty("Oracle", "org.objectweb.jorm.mapper.rdb.adapter.OracleAdapter");
        product2adapter.setProperty("SAPDB", "org.objectweb.jorm.mapper.rdb.adapter.SapdbAdapter");
        product2adapter.setProperty("Microsft SQL Server", "org.objectweb.jorm.mapper.rdb.adapter.SqlAdapter");
        product2adapter.setProperty("Sybase", "org.objectweb.jorm.mapper.rdb.adapter.SybaseAdapter");
        product2adapter.setProperty("PROGRESS", "org.objectweb.jorm.mapper.rdb.adapter.ProgressAdapter");
        String str = System.getProperty("org.objectweb.jorm.mapper.rdb.adapters");
        if (str != null && str.length() > 0) {
            StringTokenizer st = new StringTokenizer(str, ",=:", true);
            String first = null;
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                if (token.equals("=") || token.equals(":")) {
                    if (first != null) continue;
                    System.out.println("Malformed option: " + str);
                    break;
                }
                if (token.equals(",")) {
                    first = null;
                    continue;
                }
                if (first == null) {
                    first = token;
                    continue;
                }
                product2adapter.setProperty(first, token);
                first = null;
            }
        }
    }
}

