/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.objectweb.jorm.naming.api.PExceptionNameCoding;
import org.objectweb.jorm.naming.api.PNCStringCoder;

public class BasicStringCoder
implements PNCStringCoder {
    private String toDecode = null;
    private int nextToDecode = 0;
    private StringBuffer toEncode = null;

    public BasicStringCoder() {
        this.toEncode = new StringBuffer(64);
    }

    public BasicStringCoder(String en) {
        this.toDecode = en;
    }

    private byte hex2int(char c) throws PExceptionNameCoding {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new PExceptionNameCoding("Cannot decode: wrong hexadecimal code.");
    }

    private void long2hexIntoSB(long l, char[] ev) {
        int i;
        for (i = ev.length - 1; i >= 0; --i) {
            byte b = (byte)(l & 0xFL);
            ev[i] = b < 10 ? (char)(b + 48) : (char)(b - 10 + 65);
            l >>= 4;
        }
        for (i = 0; i < ev.length; ++i) {
            this.toEncode.append(ev[i]);
        }
    }

    public byte getByte() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        if (this.nextToDecode + 2 > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        byte res = (byte)(this.hex2int(this.toDecode.charAt(this.nextToDecode++)) << 4);
        res = (byte)(res + this.hex2int(this.toDecode.charAt(this.nextToDecode++)));
        return res;
    }

    public Byte getObyte() throws PExceptionNameCoding {
        return new Byte(this.getByte());
    }

    public char getChar() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        if (this.nextToDecode + 1 > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        char res = this.toDecode.charAt(this.nextToDecode++);
        return res;
    }

    public Character getOchar() throws PExceptionNameCoding {
        return new Character(this.getChar());
    }

    public short getShort() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        if (this.nextToDecode + 4 > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        short res = 0;
        for (int i = 0; i < 4; ++i) {
            res = (short)(res << 4);
            res = (short)(res + this.hex2int(this.toDecode.charAt(this.nextToDecode++)));
        }
        return res;
    }

    public Short getOshort() throws PExceptionNameCoding {
        return new Short(this.getShort());
    }

    public int getInt() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        if (this.nextToDecode + 8 > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res <<= 4;
            res += this.hex2int(this.toDecode.charAt(this.nextToDecode++));
        }
        return res;
    }

    public Integer getOint() throws PExceptionNameCoding {
        return new Integer(this.getInt());
    }

    public long getLong() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        if (this.nextToDecode + 16 > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        long res = 0L;
        for (int i = 0; i < 16; ++i) {
            res <<= 4;
            res += (long)this.hex2int(this.toDecode.charAt(this.nextToDecode++));
        }
        return res;
    }

    public Long getOlong() throws PExceptionNameCoding {
        return new Long(this.getLong());
    }

    public String getString() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        short len = this.getShort();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        String res = this.toDecode.substring(this.nextToDecode, this.nextToDecode + len);
        this.nextToDecode += len;
        return res;
    }

    public Date getDate() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        byte len = this.getByte();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        try {
            Date res = DateFormat.getDateTimeInstance().parse(this.toDecode.substring(this.nextToDecode, this.nextToDecode + len));
            this.nextToDecode += len;
            return res;
        }
        catch (ParseException pe) {
            throw new PExceptionNameCoding(pe, "Cannot decode: wrong Date format.");
        }
    }

    public BigInteger getBigInteger() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        byte len = this.getByte();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        BigInteger res = new BigInteger(this.toDecode.substring(this.nextToDecode, this.nextToDecode + len));
        this.nextToDecode += len;
        return res;
    }

    public BigDecimal getBigDecimal() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        byte len = this.getByte();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        BigDecimal res = new BigDecimal(this.toDecode.substring(this.nextToDecode, this.nextToDecode + len));
        this.nextToDecode += len;
        return res;
    }

    public byte[] getByteArray() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        byte len = this.getByte();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        return new byte[0];
    }

    public char[] getCharArray() throws PExceptionNameCoding {
        if (this.toDecode == null) {
            throw new PExceptionNameCoding("Cannot decode: this is an encoder object.");
        }
        byte len = this.getByte();
        if (this.nextToDecode + len > this.toDecode.length()) {
            throw new PExceptionNameCoding("Cannot decode: no more data.");
        }
        return new char[0];
    }

    public void putByte(byte val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        this.long2hexIntoSB(val, new char[2]);
    }

    public void putObyte(Byte val) throws PExceptionNameCoding {
        this.putByte(val);
    }

    public void putChar(char val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        this.toEncode.append(val);
    }

    public void putOchar(Character val) throws PExceptionNameCoding {
        this.putChar(val.charValue());
    }

    public void putShort(short val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        this.long2hexIntoSB(val, new char[4]);
    }

    public void putOshort(Short val) throws PExceptionNameCoding {
        this.putShort(val);
    }

    public void putInt(int val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        this.long2hexIntoSB(val, new char[8]);
    }

    public void putOint(Integer val) throws PExceptionNameCoding {
        this.putInt(val);
    }

    public void putLong(long val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        this.long2hexIntoSB(val, new char[16]);
    }

    public void putOlong(Long val) throws PExceptionNameCoding {
        this.putLong(val);
    }

    public void putString(String val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        if (val.length() > Short.MAX_VALUE) {
            throw new PExceptionNameCoding("Cannot encode: String field too long.");
        }
        this.putShort((short)val.length());
        this.toEncode.append(val);
    }

    public void putDate(Date val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        String ds = DateFormat.getDateTimeInstance().format(val);
        if (ds.length() > 127) {
            throw new PExceptionNameCoding("Cannot encode: Date field too long.");
        }
        this.putByte((byte)ds.length());
        this.toEncode.append(ds);
    }

    public void putBigInteger(BigInteger val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        String ds = val.toString();
        if (ds.length() > 127) {
            throw new PExceptionNameCoding("Cannot encode: BigInteger field too long.");
        }
        this.putByte((byte)ds.length());
        this.toEncode.append(ds);
    }

    public void putBigDecimal(BigDecimal val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        String ds = val.toString();
        if (ds.length() > 127) {
            throw new PExceptionNameCoding("Cannot encode: BigDecimal field too long.");
        }
        this.putByte((byte)ds.length());
        this.toEncode.append(ds);
    }

    public void putByteArray(byte[] va) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
    }

    public void putCharArray(char[] val) throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
    }

    public String getStringCode() throws PExceptionNameCoding {
        if (this.toEncode == null) {
            throw new PExceptionNameCoding("Cannot encode: this is a decoder object.");
        }
        return this.toEncode.toString();
    }
}

