/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XidImpl;
import org.objectweb.jotm.abortXAResourceXid;
import org.objectweb.jotm.commitXAResourceXid;

public class JotmRecovery {
    private static JotmRecovery unique = null;
    private static Vector vTxRecovered = new Vector();
    private static Vector vRecoverRmInfo = new Vector();
    private Vector userRecoveryRecords = new Vector();

    public JotmRecovery() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("JotmRecovery constructor");
        }
        unique = this;
    }

    public static JotmRecovery getJotmRecovery() {
        return unique;
    }

    public static Vector getTxRecovered() {
        return vTxRecovered;
    }

    public static Vector getRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public int getRmIndex(byte[] pxares) {
        int numRm = vRecoverRmInfo.size();
        for (int i = 0; i < numRm; ++i) {
            RecoverRmInfo myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(i);
            byte[] inrmxares = myrecoverRmInfo.getRecoverXaRes();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("XAResource param " + pxares);
                TraceTm.recovery.debug("XAResource in rm " + inrmxares);
            }
            if (inrmxares != pxares) continue;
            return myrecoverRmInfo.getRecoverIndex();
        }
        return 99;
    }

    public Vector getUserRecoveryVector() {
        return this.userRecoveryRecords;
    }

    public void rebuildTransaction(XALogRecord lr) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("rebuildTransaction");
        }
        RecoverRmInfo myrecoverRmInfo = null;
        TxxidRecovered myrecoverTxInfo = null;
        TxRecovered mytxRecovered = null;
        byte[] rt = new byte[3];
        byte[] rmname = null;
        Object rmxares = null;
        byte[] txXid = null;
        int xarescount = 0;
        byte[] rt2 = new byte[3];
        XACommittingTx myxacommittx = lr.getTx();
        byte[] tempRec = lr.getFields()[0];
        ByteBuffer rr = ByteBuffer.wrap(tempRec);
        rr.get(rt, 0, 3);
        String trt = new String(rt);
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("Recovery Record type= " + trt);
        }
        if (trt.equals("RM1")) {
            long rmdatetime = rr.getLong();
            int rmcount = rr.getInt();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Resource Manager count= " + rmcount);
            }
            for (int i = 1; i <= rmcount; ++i) {
                byte[] resmgr2 = lr.getFields()[i];
                ByteBuffer resm2 = ByteBuffer.wrap(resmgr2);
                resm2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RM2")) continue;
                int rmlength = resm2.getInt();
                rmname = new byte[rmlength];
                resm2.get(rmname, 0, rmlength);
                int xareslength = resm2.getInt();
                byte[] xares = new byte[xareslength];
                resm2.get(xares, 0, xareslength);
                int xaresnamelength = resm2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                resm2.get(xaresname, 0, xaresnamelength);
                int rmindx = resm2.getInt();
                String myrmname = new String(rmname);
                String myxares = new String(xares);
                String myxaresname = new String(xaresname);
                myrecoverRmInfo = new RecoverRmInfo();
                myrecoverRmInfo.addRecoverRmXaRes(myrmname, xares, myxaresname, rmindx);
                vRecoverRmInfo.addElement(myrecoverRmInfo);
            }
        } else if (trt.equals("RR1")) {
            long rcdatetime = rr.getLong();
            int txxidlength = rr.getInt();
            txXid = new byte[txxidlength];
            rr.get(txXid, 0, txxidlength);
            int txdatelength = rr.getInt();
            byte[] txdatetime = new byte[txdatelength];
            rr.get(txdatetime, 0, txdatelength);
            xarescount = rr.getInt();
            String mytxXid = new String(txXid);
            String mytxdatetime = new String(txdatetime);
            mytxRecovered = new TxRecovered();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("XAResource count= " + xarescount);
            }
            mytxRecovered.addtxrecovered(rcdatetime, txXid, mytxdatetime, xarescount, myxacommittx);
            for (int i = 1; i <= xarescount; ++i) {
                myrecoverTxInfo = new TxxidRecovered();
                byte[] recov2 = lr.getFields()[i];
                ByteBuffer rr2 = ByteBuffer.wrap(recov2);
                rr2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RR2")) continue;
                int xaresindex = rr2.getInt();
                int xareslength = rr2.getInt();
                byte[] xares = new byte[xareslength];
                rr2.get(xares, 0, xareslength);
                int xaresnamelength = rr2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                rr2.get(xaresname, 0, xaresnamelength);
                int xidlength = rr2.getInt();
                byte[] recoveryxid = new byte[xidlength];
                rr2.get(recoveryxid, 0, xidlength);
                int xidstatus = rr2.getInt();
                String myxares = new String(xares);
                String myxaresname = new String(xaresname);
                String myrecoveryxid = new String(recoveryxid);
                myrecoverTxInfo.addXidInfo(xaresindex, xares, myxaresname, recoveryxid, xidstatus);
                mytxRecovered.addRecoverTxXidInfo(myrecoverTxInfo, i - 1);
            }
            vTxRecovered.addElement(mytxRecovered);
        } else if (trt.equals("RU1")) {
            XidImpl.setUuids(rr.getLong(), rr.getLong());
        } else {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Unknown record type during replay = " + trt);
            }
            rr.rewind();
            this.userRecoveryRecords.add(rr);
            this.userRecoveryRecords.add(myxacommittx);
        }
    }

    public void recoverTransactions(Vector rmreg) throws XAException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("recoverTransactions");
        }
        Object myregisteredRmInfo = null;
        String myregrm = null;
        XAResource myregxares = null;
        int rmregsize = rmreg.size();
        RecoverRmInfo myrecoverRmInfo = null;
        String myrm = null;
        byte[] byxares = null;
        int rcflag = 0;
        int rmsize = vRecoverRmInfo.size();
        if (rmsize == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("Nothing to recover");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("number Resource Manager recover= " + rmsize);
        }
        for (int i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            myregrm = myrmreg.rmGetName();
            myregxares = myrmreg.rmCheckoutXARes();
            for (int j = 0; j < rmsize; ++j) {
                Xid[] javaxid;
                myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(j);
                myrm = myrecoverRmInfo.getRecoverRm();
                byxares = myrecoverRmInfo.getRecoverXaRes();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("Registered Resource Manager " + myregrm);
                    TraceTm.recovery.debug("Registered XAResource " + myregxares);
                    TraceTm.recovery.debug("Recover Resource Manager " + myrm);
                    TraceTm.recovery.debug("Recover XAResource " + new String(byxares));
                }
                if (!myregrm.equals(myrm)) continue;
                try {
                    javaxid = myregxares.recover(rcflag);
                }
                catch (XAException e) {
                    throw new XAException("xaResource.recover call failed during recovery " + e.getMessage());
                }
                if (javaxid == null) {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("No XIDs to recover for Xares javaxid is null");
                    break;
                }
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("javaxid size= " + javaxid.length);
                }
                if (javaxid.length == 0) {
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug("No XIDs to recover for Xares= " + myregxares);
                    break;
                }
                this.settxxidrecoveraction(myregxares, javaxid);
                break;
            }
            myrmreg.rmCheckinXARes();
        }
        this.doActionXidRecover();
        this.doCleanupXidRecover();
    }

    private void settxxidrecoveraction(XAResource actxares, Xid[] actionxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("settxxidrecoveraction");
        }
        TxxidRecovered mytxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        block0: for (int i = 0; i < actionxid.length; ++i) {
            boolean xidfound = false;
            Xid myjavaxid = actionxid[i];
            XidImpl myxid = new XidImpl(myjavaxid);
            byte[] mybrqu = myxid.getBranchQualifier();
            for (int j = 0; j < vTxRecovered.size(); ++j) {
                mytxRecovered = (TxRecovered)vTxRecovered.elementAt(j);
                if (mytxRecovered != null) {
                    for (int k = 0; k < mytxRecovered.getxidcount(); ++k) {
                        mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(k);
                        if (mytxxidRecovered == null) continue;
                        byte[] mytxxid = mytxxidRecovered.getRecoverxid();
                        XidImpl mymytxxid = new XidImpl(mytxxid);
                        if (mymytxxid.IsThisOneOfOurs(mybrqu)) {
                            if (TraceTm.recovery.isDebugEnabled()) {
                                TraceTm.recovery.debug("mymytxxid= " + mymytxxid.toString(true));
                                TraceTm.recovery.debug("myxid  = " + myxid.toString(true));
                            }
                            if (!new String(mytxxid).equals(myxid.toString(true))) continue;
                            xidfound = true;
                            int myaction = 1;
                            mytxxidRecovered.setRecoveraction(myaction);
                            mytxxidRecovered.setCommitxares(actxares);
                            mytxxidRecovered.setCommitxid(myjavaxid);
                            mytxRecovered.addRecoverTxXidInfo(mytxxidRecovered, k);
                            break;
                        }
                        if (!TraceTm.recovery.isDebugEnabled()) continue;
                        TraceTm.recovery.debug("Xid is not one of ours");
                    }
                    if (xidfound) continue block0;
                }
                if (xidfound) continue block0;
                this.abortimmediate(actxares, myjavaxid);
            }
        }
    }

    private void doActionXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("doActionXidRecover");
        }
        TxxidRecovered mytxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        for (int i = 0; i < vTxRecovered.size(); ++i) {
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            XAResource commitxares = null;
            Xid commitxid = null;
            for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (mytxxidRecovered == null || mytxxidRecovered.getRecoveraction() != 1) continue;
                byte[] myrcxid = mytxxidRecovered.getRecoverxid();
                commitxares = mytxxidRecovered.getCommitxares();
                commitxid = mytxxidRecovered.getCommitxid();
                new commitXAResourceXid(commitxares, commitxid).start();
            }
        }
    }

    private void abortimmediate(XAResource abortxares, Xid abortxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("abortimmediate");
        }
        new abortXAResourceXid(abortxares, abortxid).start();
    }

    private void doCleanupXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("doCleanupXidRecover");
        }
        TxxidRecovered myTxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug("vTxRecovered.size= " + vTxRecovered.size());
        }
        for (int i = vTxRecovered.size() - 1; i >= 0; --i) {
            boolean possibleheuristic = false;
            XACommittingTx myxacommittingtx = null;
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("mytxRecovered.xidcount= " + mytxRecovered.getxidcount());
            }
            for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                myTxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (myTxxidRecovered == null || myTxxidRecovered.getRecoveraction() == 0 || myTxxidRecovered.getRecoveraction() == 1) continue;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug("possibleheuristic");
                }
                possibleheuristic = true;
            }
            if (possibleheuristic) continue;
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("write howlDonelog");
            }
            myxacommittingtx = mytxRecovered.getXACommittingTx();
            byte[] rmDone = new byte[11];
            byte[][] rmDoneRecord = new byte[1][11];
            rmDone = "RR3JOTMDONE".getBytes();
            try {
                rmDoneRecord[0] = rmDone;
                TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(rmDoneRecord, myxacommittingtx);
            }
            catch (Exception f) {
                String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                TraceTm.jotm.error("Got LogException from howlDoneLog: " + howlerror);
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug("remove txRecovered entry");
            }
            vTxRecovered.remove(i);
        }
    }
}

