/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.component;

import java.net.URL;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

public final class CMIServerConfigurator {
    private static Log logger = LogFactory.getLog(CMIServerConfigurator.class);

    private CMIServerConfigurator() {
    }

    public static ServerClusterViewManager init(ServerClusterViewManager serverClusterViewManager, URL xmlConfigurationURL) throws ServerClusterViewManagerException {
        CMIServerConfigurator.configure(serverClusterViewManager, xmlConfigurationURL);
        return serverClusterViewManager;
    }

    private static void configure(ServerClusterViewManager serverClusterViewManager, URL xmlConfigurationURL) throws ServerClusterViewManagerException {
        long tStart = System.currentTimeMillis();
        logger.debug("Starting configuration of CMI server", new Object[0]);
        XMLConfiguration xmlConfiguration = new XMLConfiguration(xmlConfigurationURL, "cmi-server-mapping.xml");
        xmlConfiguration.setPropertyResolver(new SystemPropertyResolver());
        try {
            xmlConfiguration.configure(serverClusterViewManager);
        }
        catch (XMLConfigurationException e) {
            throw new ServerClusterViewManagerException("Cannot configure the CMI server", e);
        }
        if (logger.isInfoEnabled()) {
            logger.debug("Configuration done in : " + (System.currentTimeMillis() - tStart) + " ms", new Object[0]);
        }
    }
}

