/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.policy;

import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.policy.AbstractPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.NoStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class RoundRobin<T extends LoadBalanceable>
extends AbstractPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(RoundRobin.class);
    private static final int INITIAL_VALUE = -1;
    private int pointer = -1;
    private final Random rand = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List<T> cmiRefsWithStrategy;
        if (loadBalanceables == null || loadBalanceables.isEmpty()) {
            LOGGER.error("The given list is null or empty: " + loadBalanceables, new Object[0]);
            throw new NoLoadBalanceableException("The given list is null or empty: " + loadBalanceables);
        }
        IStrategy<T> strategy = this.getStrategy();
        if (strategy != null) {
            cmiRefsWithStrategy = strategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        int size = cmiRefsWithStrategy.size();
        if (this.pointer == -1) {
            this.pointer = strategy != null && !(strategy instanceof NoStrategy) ? 0 : this.rand.nextInt(size);
        } else {
            if (this.pointer >= size) {
                this.pointer = -1;
            }
            this.pointer = (this.pointer + 1) % size;
        }
        return (T)((LoadBalanceable)cmiRefsWithStrategy.get(this.pointer));
    }

    public String toString() {
        return "RoundRobin[pointer: " + this.pointer + " - strategy: " + this.getStrategy() + "]";
    }
}

