/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateful;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionFactory
extends SessionFactory<EasyBeansSFSB>
implements PoolFactory<EasyBeansSFSB, Long> {
    private static Log logger = LogFactory.getLog(StatefulSessionFactory.class);
    private long idCount = 0L;

    public StatefulSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        JPool<EasyBeansSFSB, Long> pool = new JPool<EasyBeansSFSB, Long>(this);
        pool.setAllowSharedInstance(false);
        this.setPool(pool);
    }

    @Override
    public boolean isMatching(EasyBeansSFSB bean, Long clue) {
        logger.debug("Called with bean = {0} and beanId = {1}", bean, clue);
        Long beanId = bean.getEasyBeansStatefulID();
        boolean val = beanId.equals(clue);
        logger.debug("Found id = {0} and will return = {1}", beanId, val);
        return val;
    }

    @Override
    public boolean validate(EasyBeansSFSB object, PoolEntryStatistics stats) {
        return true;
    }

    @Override
    protected synchronized Long getId(Long beanId) {
        Long newId = beanId;
        if (newId == null) {
            ++this.idCount;
            newId = this.idCount;
        }
        return newId;
    }

    @Override
    public synchronized EasyBeansSFSB create(Long clue) throws PoolException {
        EasyBeansSFSB bean = (EasyBeansSFSB)super.create(clue);
        return bean;
    }

    @Override
    protected synchronized EasyBeansSFSB getBean(Long beanId) throws IllegalArgumentException {
        EasyBeansSFSB bean = null;
        try {
            bean = (EasyBeansSFSB)this.getPool().get(beanId);
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
        logger.debug("Set for bean {0} the Id = {1}", bean, beanId);
        bean.setEasyBeansStatefulID(beanId);
        return bean;
    }

    @Override
    public void remove(EasyBeansSFSB instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse localCall(long hash, Object[] methodArgs, Long beanId) {
        Long id = this.getId(beanId);
        JEJBResponse ejbResponse = new JEJBResponse();
        ejbResponse.setBeanId(id);
        EasyBeansSFSB bean = null;
        try {
            bean = this.getBean(id);
        }
        catch (IllegalArgumentException e) {
            ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", e));
            return ejbResponse;
        }
        catch (NoSuchEJBException e) {
            ejbResponse.setRPCException(new RPCException("Bean has been removed", e));
            return ejbResponse;
        }
        Method m = this.getHashes().get(hash);
        if (m == null) {
            ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
            return ejbResponse;
        }
        Object value = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        EasyBeansSFSB easyBeansSFSB = bean;
        synchronized (easyBeansSFSB) {
            try {
                value = m.invoke((Object)bean, methodArgs);
            }
            catch (IllegalArgumentException e) {
                ejbResponse.setRPCException(new RPCException(e));
            }
            catch (IllegalAccessException e) {
                ejbResponse.setRPCException(new RPCException(e));
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                RPCException rpcException = new RPCException(cause);
                ApplicationException applicationException = this.getBeanInfo().getApplicationExceptions().get(cause.getClass().getName());
                if (applicationException != null) {
                    rpcException.setApplicationException();
                }
                ejbResponse.setRPCException(rpcException);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                try {
                    this.getPool().release(bean);
                }
                catch (PoolException e) {
                    ejbResponse.setRPCException(new RPCException("cannot release bean", e));
                }
                if (bean.getEasyBeansRemoved()) {
                    ejbResponse.setRemoved(true);
                }
            }
        }
        ejbResponse.setValue(value);
        return ejbResponse;
    }

    @Override
    public void notifyTimeout(Timer timer) {
        throw new EJBException("Stateful bean cannot receive Timer objects");
    }
}

