/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.session;

import java.util.List;
import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarMethodMetadata;
import org.ow2.util.ee.metadata.common.impl.struct.JAnnotationResource;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class SessionBeanInterface {
    private static final String SESSION_BEAN_INTERFACE = "javax/ejb/SessionBean";
    private static final JMethod SETSESSIONCONTEXT_METHOD = new JMethod(1, "setSessionContext", "(Ljavax/ejb/SessionContext;)V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});
    private static final JMethod EJBREMOVE_METHOD = new JMethod(1, "ejbRemove", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});
    private static final JMethod EJBACTIVATE_METHOD = new JMethod(1, "ejbActivate", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});
    private static final JMethod EJBPASSIVATE_METHOD = new JMethod(1, "ejbPassivate", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});

    private SessionBeanInterface() {
    }

    public static void resolve(EjbJarClassMetadata sessionBean) {
        List<String> allInterfaces = ResolverHelper.getAllInterfacesFromClass(sessionBean);
        if (allInterfaces.contains(SESSION_BEAN_INTERFACE)) {
            JAnnotationResource jAnnotationResource = new JAnnotationResource();
            EjbJarMethodMetadata setCtxMethod = ResolverHelper.getMethod(sessionBean, SETSESSIONCONTEXT_METHOD, false, SESSION_BEAN_INTERFACE);
            setCtxMethod.setJAnnotationResource(jAnnotationResource);
            EjbJarMethodMetadata ejbRemoveMethod = ResolverHelper.getMethod(sessionBean, EJBREMOVE_METHOD, true, SESSION_BEAN_INTERFACE);
            ejbRemoveMethod.setPreDestroy(true);
            if (!sessionBean.getPreDestroyMethodsMetadata().contains(ejbRemoveMethod)) {
                sessionBean.addPreDestroyMethodMetadata(ejbRemoveMethod);
            }
            EjbJarMethodMetadata ejbActivateMethod = ResolverHelper.getMethod(sessionBean, EJBACTIVATE_METHOD, true, SESSION_BEAN_INTERFACE);
            ejbRemoveMethod.setPostActivate(true);
            if (!sessionBean.getPostActivateMethodsMetadata().contains(ejbActivateMethod)) {
                sessionBean.addPostActivateMethodMetadata(ejbActivateMethod);
            }
            EjbJarMethodMetadata ejbPassivateMethod = ResolverHelper.getMethod(sessionBean, EJBPASSIVATE_METHOD, true, SESSION_BEAN_INTERFACE);
            ejbRemoveMethod.setPrePassivate(true);
            if (!sessionBean.getPrePassivateMethodsMetadata().contains(ejbPassivateMethod)) {
                sessionBean.addPrePassivateMethodMetadata(ejbPassivateMethod);
            }
        }
    }
}

