/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.metadata.ejbjar;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarArchiveMetadata {
    private static Log logger = LogFactory.getLog(EjbJarArchiveMetadata.class);
    private Map<String, EjbJarClassMetadata> classesAnnotationMetadata = new HashMap<String, EjbJarClassMetadata>();
    private EasyBeansDD easybeansDD = null;
    private Map<String, ApplicationException> applicationExceptions = null;
    private Map<InterceptorType, List<? extends IJClassInterceptor>> defaultInterceptors = null;
    private IJInterceptors defaultInterceptorsClasses = null;
    private EJB3Deployable deployable;

    public void addEjbJarClassMetadata(EjbJarClassMetadata classAnnotationMetadata) {
        String key = classAnnotationMetadata.getClassName();
        if (this.classesAnnotationMetadata.containsKey(key)) {
            String msg = logger.getI18n().getMessage("EjbJarAnnotationMetadata.addClassAnnotationMetadata.alreadyPresent", key);
            logger.debug(msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.classesAnnotationMetadata.put(key, classAnnotationMetadata);
    }

    public EjbJarClassMetadata getEjbJarClassMetadataForEjbName(String ejbName) {
        for (EjbJarClassMetadata metadata : this.classesAnnotationMetadata.values()) {
            IJCommonBean bean = metadata.getJCommonBean();
            if (bean == null || !ejbName.equals(bean.getName())) continue;
            return metadata;
        }
        return null;
    }

    public EjbJarClassMetadata getEjbJarClassMetadata(String className) {
        return this.classesAnnotationMetadata.get(className);
    }

    public Collection<EjbJarClassMetadata> getEjbJarClassMetadataCollection() {
        return this.classesAnnotationMetadata.values();
    }

    public EasyBeansDD getEasyBeansDD() {
        return this.easybeansDD;
    }

    public void setEasyBeansDD(EasyBeansDD easybeansDD) {
        this.easybeansDD = easybeansDD;
    }

    public Map<String, ApplicationException> getApplicationExceptions() {
        if (this.applicationExceptions != null) {
            return this.applicationExceptions;
        }
        this.applicationExceptions = new HashMap<String, ApplicationException>();
        for (EjbJarClassMetadata classMetadata : this.getEjbJarClassMetadataCollection()) {
            ApplicationException appException = classMetadata.getApplicationException();
            if (appException == null) continue;
            this.applicationExceptions.put(classMetadata.getClassName().replaceAll("/", "."), appException);
        }
        this.applicationExceptions.put("DEFAULT", new JApplicationException());
        return this.applicationExceptions;
    }

    public Map<InterceptorType, List<? extends IJClassInterceptor>> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(Map<InterceptorType, List<? extends IJClassInterceptor>> defaultInterceptors) {
        this.defaultInterceptors = defaultInterceptors;
    }

    public IJInterceptors getDefaultInterceptorsClasses() {
        return this.defaultInterceptorsClasses;
    }

    public void setDefaultInterceptorsClasses(IJInterceptors defaultInterceptorsClasses) {
        this.defaultInterceptorsClasses = defaultInterceptorsClasses;
    }

    public void setDeployable(EJB3Deployable deployable) {
        this.deployable = deployable;
    }

    public EJB3Deployable getDeployable() {
        return this.deployable;
    }
}

