/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.metadata.ejbjar.xml;

import java.net.URL;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.EJB3DeploymentDescException;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;

public final class EasyBeansDeploymentDesc {
    private static final String EASYBEANS_DD_ENTRY = "META-INF/easybeans.xml";

    private EasyBeansDeploymentDesc() {
    }

    public static EasyBeansDD getEasyBeansDD(IArchive archive) throws EJB3DeploymentDescException {
        URL easybeansXmlURL = null;
        try {
            easybeansXmlURL = archive.getResource(EASYBEANS_DD_ENTRY);
        }
        catch (ArchiveException e) {
            throw new EJB3DeploymentDescException("Cannot get resource 'META-INF/easybeans.xml' on the archive '" + archive.getName() + "'.");
        }
        EasyBeansDD easyBeansDD = null;
        if (easybeansXmlURL != null) {
            easyBeansDD = new EasyBeansDD();
            XMLConfiguration xmlConfiguration = new XMLConfiguration(easybeansXmlURL, "easybeans-mapping.xml");
            try {
                xmlConfiguration.configure(easyBeansDD);
            }
            catch (XMLConfigurationException e) {
                throw new EJB3DeploymentDescException("Cannot create the object representing EasyBeans specific Deployment Descriptor", e);
            }
        }
        return easyBeansDD;
    }
}

