/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.transaction.SessionSynchronizationListener;
import org.ow2.easybeans.transaction.interceptors.AbsTransactionInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ListenerSessionSynchronizationInterceptor
extends AbsTransactionInterceptor {
    private Log logger = LogFactory.getLog(ListenerSessionSynchronizationInterceptor.class);
    private Map<Object, SessionSynchronizationListener> listeners = new WeakHashMap<Object, SessionSynchronizationListener>();

    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        this.logger.debug("Calling ListenerSessionSynchronizationInterceptor interceptor", new Object[0]);
        if (this.getTransactionManager().getTransaction() != null) {
            this.addSynchronization(invocationContext);
        } else {
            this.logger.warn("No transaction but the bean is implementing session synchonization interface.", new Object[0]);
        }
        return invocationContext.proceed();
    }

    private void addSynchronization(EasyBeansInvocationContext invocationContext) {
        Object o = invocationContext.getTarget();
        if (!(o instanceof SessionSynchronization)) {
            throw new IllegalArgumentException("This interceptor should not have been added on this bean which doesn't implement SessionSynchronization interface.");
        }
        SessionSynchronization bean = (SessionSynchronization)o;
        SessionSynchronizationListener sessionSynchronizationListener = this.listeners.get(bean);
        if (sessionSynchronizationListener == null) {
            sessionSynchronizationListener = new SessionSynchronizationListener(bean);
            this.listeners.put(bean, sessionSynchronizationListener);
        }
        if (sessionSynchronizationListener.isReady()) {
            try {
                this.getTransactionManager().getTransaction().registerSynchronization(sessionSynchronizationListener);
            }
            catch (IllegalStateException e) {
                throw new EJBException("Cannot register the synchronization", e);
            }
            catch (RollbackException e) {
                throw new TransactionRolledbackLocalException("Session rolled back");
            }
            catch (SystemException e) {
                throw new EJBException("Cannot register the synchronization", e);
            }
            try {
                bean.afterBegin();
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Cannot call afterBefin method", e);
            }
            sessionSynchronizationListener.inTX();
        }
    }
}

