/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.proxy.clusterd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.proxy.JMXProxy;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxyMBean;
import org.ow2.jonas.lib.management.javaee.J2EEServerState;
import org.ow2.jonas.lib.util.JonasObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterDaemonProxy
extends JMXProxy
implements ClusterDaemonProxyMBean {
    private ArrayList controlledServersNames = null;
    private String hostName;
    String runTimeSpecVendor = null;
    String runTimeSpecVersion = null;
    String runTimeVmName = null;
    String runTimeVmVendor = null;
    String runTimeVmVersion = null;
    String operatingSystemAvailableProcessors = null;
    String operatingSystemArch = null;
    String operatingSystemName = null;
    String operatingSystemVersion = null;
    private boolean ALREADY_HAVE_HOST_REMOTE_INFOS = false;
    private boolean hasDiscovery = false;

    public ClusterDaemonProxy(DomainMonitor dm, String name, Collection urls) {
        super(dm, name, urls);
    }

    public void checkit() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        if (this.checkConnection()) {
            this.setState(J2EEServerState.RUNNING);
        } else {
            this.setState(J2EEServerState.UNREACHABLE);
        }
    }

    @Override
    public boolean startServer(String serverName, String otherParams) {
        logger.log(BasicLevel.DEBUG, (Object)("Start remote server: " + serverName));
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return false;
        }
        String opName = "startJOnAS";
        Object[] opParams = new String[]{serverName, this.getDomain(), otherParams};
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, opName, opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot start server: " + e));
            return false;
        }
        return true;
    }

    @Override
    public boolean stopServer(String serverName, String otherParams) {
        logger.log(BasicLevel.DEBUG, (Object)("Stop remote server: " + serverName));
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return false;
        }
        String opName = "stopJOnAS";
        Object[] opParams = new String[]{serverName};
        String[] opSignature = new String[]{"java.lang.String"};
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, opName, opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot stop server: " + e));
            return false;
        }
        return true;
    }

    @Override
    public void startAllServers(String otherParams) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return;
        }
        String opName = "startAllJOnAS";
        Object[] opParams = new String[]{this.getDomain(), otherParams};
        String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, opName, opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot start server: " + e));
        }
    }

    @Override
    public void stopAllServers(String otherParams) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return;
        }
        String opName = "stopAllJOnAS";
        Object[] opParams = new String[]{};
        String[] opSignature = new String[]{};
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, opName, opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot stop server: " + e));
        }
    }

    public String pingAllJOnAS() {
        return null;
    }

    @Override
    public int pingJOnAS(String name) {
        return 0;
    }

    @Override
    public void reloadConfiguration() {
    }

    @Override
    public void save(String name) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + name));
            return;
        }
        this.setName(name);
        String opName = "saveToXml";
        Object[] opParams = new String[]{name};
        String[] opSignature = new String[]{"java.lang.String"};
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, opName, opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot save cluster daemon Info To xml file: " + e));
        }
    }

    public void getServersNames() {
        logger.log(BasicLevel.DEBUG, (Object)"getting controlled server names");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return;
        }
        ArrayList ret = null;
        String opName = "serversNames";
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (ArrayList)this.getConnection().invoke(on, opName, null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get Controlled server names:" + e));
        }
        this.controlledServersNames = ret;
    }

    @Override
    public ArrayList getControlledServersNames() {
        this.getServersNames();
        return this.controlledServersNames;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setName(String name) {
        this.setName(name);
    }

    public void setControlledServersNames(ArrayList controlledServersNames) {
        this.controlledServersNames = controlledServersNames;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    private void initRemoteHostInfos() {
        if (!this.ALREADY_HAVE_HOST_REMOTE_INFOS) {
            this.getRemoteHostInfo();
        }
    }

    public void getRemoteHostInfo() {
        logger.log(BasicLevel.DEBUG, (Object)"getting cluster daemon jmx url");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return;
        }
        ObjectName on = null;
        try {
            on = JonasObjectName.clusterDaemon(this.getDomain());
            String[] attributes = new String[]{"RunTimeSpecVendor", "RunTimeSpecVersion", "RunTimeVmName", "RunTimeVmVendor", "RunTimeVmVersion", "OperatingSystemAvailableProcessors", "OperatingSystemName", "OperatingSystemVersion", "OperatingSystemArch"};
            AttributeList al = this.getConnection().getAttributes(on, attributes);
            for (int i = 0; i < al.size(); ++i) {
                Attribute at = (Attribute)al.get(i);
                String name = at.getName();
                if ("RunTimeSpecVendor".equals(name)) {
                    this.runTimeSpecVendor = (String)at.getValue();
                    continue;
                }
                if ("RunTimeSpecVersion".equals(name)) {
                    this.runTimeSpecVersion = (String)at.getValue();
                    continue;
                }
                if ("RunTimeVmName".equals(name)) {
                    this.runTimeVmName = (String)at.getValue();
                    continue;
                }
                if ("RunTimeVmVendor".equals(name)) {
                    this.runTimeVmVendor = (String)at.getValue();
                    continue;
                }
                if ("RunTimeVmVersion".equals(name)) {
                    this.runTimeVmVersion = (String)at.getValue();
                    continue;
                }
                if ("OperatingSystemAvailableProcessors".equals(name)) {
                    this.operatingSystemAvailableProcessors = (String)at.getValue();
                    continue;
                }
                if ("OperatingSystemName".equals(name)) {
                    this.operatingSystemName = (String)at.getValue();
                    continue;
                }
                if ("OperatingSystemArch".equals(name)) {
                    this.operatingSystemArch = (String)at.getValue();
                    continue;
                }
                this.operatingSystemVersion = (String)at.getValue();
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get Cluster daemon's Host Operating System:" + e));
            return;
        }
        this.ALREADY_HAVE_HOST_REMOTE_INFOS = true;
    }

    @Override
    public Hashtable<String, String> dynamicRemoteHostInfos() {
        logger.log(BasicLevel.DEBUG, (Object)"getting cluster daemon Dynamic host's infos");
        if (!this.checkConnection() && !this.connect(this.getUrls())) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to get connection to cluster daemon " + this.getName()));
            return null;
        }
        Hashtable ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (Hashtable)this.getConnection().getAttribute(on, "DynamicHostAttributes");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public String getOperatingSystemAvailableProcessors() {
        return this.operatingSystemAvailableProcessors;
    }

    @Override
    public String getOperatingSystemName() {
        this.initRemoteHostInfos();
        return this.operatingSystemName;
    }

    @Override
    public String getOperatingSystemVersion() {
        this.initRemoteHostInfos();
        return this.operatingSystemVersion;
    }

    @Override
    public String getRunTimeSpecVendor() {
        this.initRemoteHostInfos();
        return this.runTimeSpecVendor;
    }

    @Override
    public String getRunTimeSpecVersion() {
        this.initRemoteHostInfos();
        return this.runTimeSpecVersion;
    }

    @Override
    public String getRunTimeVmName() {
        this.initRemoteHostInfos();
        return this.runTimeVmName;
    }

    @Override
    public String getRunTimeVmVendor() {
        this.initRemoteHostInfos();
        return this.runTimeVmVendor;
    }

    @Override
    public String getRunTimeVmVersion() {
        this.initRemoteHostInfos();
        return this.runTimeVmVersion;
    }

    @Override
    public String getOperatingSystemArch() {
        this.initRemoteHostInfos();
        return this.operatingSystemArch;
    }

    @Override
    public String vmCurrentUsedMemory() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "vmCurrentUsedMemory", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public String vmTotalMemory() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "vmTotalMemory", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get Vm Total Memory");
        return ret;
    }

    @Override
    public String vmCurrentUsedHeapMemory() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "vmCurrentUsedHeapMemory", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public String vmCurrentUsedNonHeapMemory() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "vmCurrentUsedNonHeapMemory", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public String osCurrentUsedSpace() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "osCurrentUsedSpace", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public String osTotalSpace() {
        this.initRemoteHostInfos();
        String ret = null;
        try {
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            ret = (String)this.getConnection().invoke(on, "osTotalSpace", null, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get monitoring informations for cluster daemon remote host :" + e));
            return null;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Finisched to get clusterd host infos");
        return ret;
    }

    @Override
    public void addServer(String name, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String saveIt) {
        this.initRemoteHostInfos();
        try {
            logger.log(BasicLevel.DEBUG, (Object)("Adding server" + name + " to cluster daemon " + this.getName() + " control "));
            this.controlledServersNames.add(name);
            Object[] opParams = new String[]{name, description, jonasRoot, jonasBase, javaHome, xprem, autoBoot, saveIt};
            String[] opSignature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, "addServer", opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot Add server named " + name + " to cluster daemon " + this.getName() + " control " + e));
            return;
        }
    }

    @Override
    public void removeServer(String serverName, String saveIt) {
        this.initRemoteHostInfos();
        try {
            this.controlledServersNames.remove(this.getName());
            Object[] opParams = new String[]{this.getName(), saveIt};
            String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
            ObjectName on = JonasObjectName.clusterDaemon(this.getDomain());
            this.getConnection().invoke(on, "removeServer", opParams, opSignature);
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot Remove server named " + this.getName() + " to cluster daemon " + this.getName() + " control " + e));
            return;
        }
    }

    public void notifyStarting(Collection urls) {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        this.hasDiscovery = true;
        if (J2EEServerState.RUNNING.equals((Object)this.getJ2EEServerState())) {
            logger.log(BasicLevel.DEBUG, (Object)"Already running");
        } else if (this.connect(urls)) {
            this.setState(J2EEServerState.RUNNING);
        } else {
            this.setState(J2EEServerState.FAILED);
        }
    }

    public void notifyStopping() {
        logger.log(BasicLevel.DEBUG, (Object)this.getName());
        this.hasDiscovery = true;
        if (J2EEServerState.STOPPED.equals((Object)this.getJ2EEServerState())) {
            logger.log(BasicLevel.DEBUG, (Object)"Already stopped");
        } else if (J2EEServerState.UNKNOWN.equals((Object)this.getJ2EEServerState())) {
            logger.log(BasicLevel.WARN, (Object)"Running now with discovery");
        } else {
            this.setState(J2EEServerState.STOPPED);
            this.disconnect();
        }
    }
}

