/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.osgi;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASConfiguration
implements ConfigurationManager,
ConfigurationPlugin {
    private ConfigurationAdmin configurationAdmin = null;
    private static final String DATE = "date";
    private static final String JONAS_SERVICE = "jonas.service";
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String SERVER_CONFIG = "org.ow2.jonas.server";
    private JProp serverProperties = null;
    private BundleContext bc = null;
    private List<String> mandatoryServices = null;
    private boolean isRunnable = false;
    private Log logger = LogFactory.getLog(JOnASConfiguration.class);
    private ServiceManager serviceManager = null;

    public JOnASConfiguration(BundleContext bc) {
        this.bc = bc;
        this.loadServerProperties();
        this.mandatoryServices = new ArrayList<String>();
        this.mandatoryServices.add("registry");
        this.mandatoryServices.add("jmx");
    }

    public void configure() throws Exception {
        ServiceReference sr;
        boolean boostrapMode = Boolean.getBoolean(JONAS_BOOTSTRAP);
        if (boostrapMode) {
            this.manageServiceConfigurations(this.getOptionalServices(), true);
        }
        if (this.doUpdateServiceConfigurations()) {
            this.deleteOldConfigurations();
            this.manageServiceConfigurations(this.mandatoryServices, false);
            if (!boostrapMode) {
                this.manageServiceConfigurations(this.getOptionalServices(), false);
            }
        }
        if ((sr = this.bc.getServiceReference(ServerProperties.class.getName())) == null) {
            this.bc.registerService(ServerProperties.class.getName(), (Object)this.serverProperties, null);
        }
    }

    @Override
    public synchronized void updateServiceConfigurations() throws Exception {
        if (this.doUpdateServiceConfigurations() || !this.isRunnable) {
            this.manageServiceConfigurations(this.getOptionalServices(), false);
            this.isRunnable = true;
        }
    }

    @Override
    public synchronized void deleteServiceConfigurations() throws Exception {
        this.manageServiceConfigurations(this.reverseList(this.getOptionalServices()), true);
        this.isRunnable = false;
    }

    @Override
    public void haltServer() throws Exception {
        Configuration serverConfiguration = this.configurationAdmin.getConfiguration(SERVER_CONFIG);
        serverConfiguration.delete();
        this.bc.getBundle(0L).stop();
    }

    @Override
    public synchronized void updateServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, false);
    }

    @Override
    public synchronized void deleteServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, true);
    }

    private boolean doUpdateServiceConfigurations() throws Exception {
        long lastModification;
        Configuration serverConfiguration = this.configurationAdmin.getConfiguration(SERVER_CONFIG);
        Hashtable<String, Long> serverProps = serverConfiguration.getProperties();
        if (serverProps == null) {
            serverProps = new Hashtable<String, Long>();
            ((Dictionary)serverProps).put(DATE, this.getLastModification());
            serverConfiguration.update(serverProps);
            return true;
        }
        long currentModification = (Long)((Dictionary)serverProps).get(DATE);
        if (currentModification != (lastModification = this.getLastModification())) {
            this.loadServerProperties();
            if (this.serviceManager != null) {
                this.serviceManager.update();
            }
            ((Dictionary)serverProps).put(DATE, lastModification);
            serverConfiguration.update(serverProps);
            return true;
        }
        return false;
    }

    private void manageServiceConfigurations(List<String> services, boolean delete) throws Exception {
        for (String service : this.removeDuplicateServices(services)) {
            boolean mandatory = this.mandatoryServices.contains(service);
            String serviceClass = "jonas.service." + service + ".class";
            String factoryPID = this.serverProperties.getValue(serviceClass);
            if (factoryPID != null) {
                Dictionary<String, Object> newProperties = null;
                if (!delete) {
                    newProperties = this.getServiceProperties(service);
                    newProperties.put(JONAS_SERVICE, service);
                    newProperties.put("jonas.service.mandatory", mandatory);
                }
                Configuration[] storedConfigurations = this.configurationAdmin.listConfigurations("(service.factoryPid=" + factoryPID + ")");
                Configuration configuration = null;
                if (!delete && storedConfigurations.length == 0) {
                    configuration = this.configurationAdmin.createFactoryConfiguration(factoryPID, null);
                    configuration.update(newProperties);
                    continue;
                }
                if (storedConfigurations.length != 1) continue;
                configuration = this.configurationAdmin.getConfiguration(storedConfigurations[0].getPid());
                if (delete) {
                    configuration.delete();
                    continue;
                }
                Dictionary storedProperties = configuration.getProperties();
                if (!this.isConfigurationModified(storedProperties, newProperties)) continue;
                configuration.update(newProperties);
                continue;
            }
            this.logger.error("Missing configuration for ''{0}'' service in jonas.properties.", service);
        }
    }

    private List<String> removeDuplicateServices(List<String> services) {
        LinkedList<String> result = new LinkedList<String>();
        for (String service : services) {
            if (!result.contains(service)) {
                result.add(service);
                continue;
            }
            this.logger.warn("Service ''{0}'' declared many times in jonas.properties", service);
        }
        return result;
    }

    @Override
    public List<String> getMandatoryServices() {
        return this.mandatoryServices;
    }

    @Override
    public List<String> getAllServices() {
        List<String> allServices = this.getOptionalServices();
        for (int i = 0; i < this.mandatoryServices.size(); ++i) {
            allServices.add(i, this.mandatoryServices.get(i));
        }
        return allServices;
    }

    @Override
    public List<String> getOptionalServices() {
        String[] declaredServices = this.serverProperties.getValueAsArray("jonas.services");
        ArrayList<String> optionalServices = new ArrayList<String>();
        for (String declaredService : declaredServices) {
            if (this.mandatoryServices.contains(declaredService)) continue;
            optionalServices.add(declaredService);
        }
        return optionalServices;
    }

    private boolean isConfigurationModified(Dictionary<String, Object> storedProperties, Dictionary<String, Object> newProperties) {
        storedProperties.remove("service.pid");
        storedProperties.remove("service.factoryPid");
        storedProperties.remove("service.bundleLocation");
        if (storedProperties.size() != newProperties.size()) {
            return true;
        }
        Enumeration<String> enProps = storedProperties.keys();
        while (enProps.hasMoreElements()) {
            String key = enProps.nextElement();
            if (newProperties.get(key) == null) {
                return true;
            }
            if (storedProperties.get(key).equals(newProperties.get(key))) continue;
            return true;
        }
        return false;
    }

    private Dictionary<String, Object> getServiceProperties(String service) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (Object key : this.serverProperties.getConfigFileEnv().keySet()) {
            String servicePrefix;
            String name = (String)key;
            if (!name.startsWith(servicePrefix = "jonas.service." + service + ".")) continue;
            String value = this.serverProperties.getValue(name);
            name = name.substring(servicePrefix.length());
            ((Dictionary)props).put(name, value);
        }
        return props;
    }

    private long getLastModification() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File jonasPropertyFile = new File(conf, "jonas.properties");
        return jonasPropertyFile.lastModified();
    }

    private List<String> reverseList(List<String> list) {
        ArrayList<String> reversedList = new ArrayList<String>();
        for (String element : list) {
            reversedList.add(0, element);
        }
        return reversedList;
    }

    private void deleteOldConfigurations() throws Exception {
        Configuration[] storedConfigurations;
        for (Configuration configuration : storedConfigurations = this.configurationAdmin.listConfigurations(null)) {
            String serviceName = (String)configuration.getProperties().get(JONAS_SERVICE);
            if (configuration.getPid().equals(SERVER_CONFIG) || this.getAllServices().contains(serviceName)) continue;
            configuration.delete();
        }
    }

    private void loadServerProperties() {
        this.serverProperties = new JProp();
    }

    public void modifyConfiguration(ServiceReference serviceReference, Dictionary storedProperties) {
        try {
            if (this.doUpdateServiceConfigurations()) {
                String serviceName = (String)storedProperties.get(JONAS_SERVICE);
                Dictionary<String, Object> newProperties = this.getServiceProperties(serviceName);
                Enumeration<String> enProps = newProperties.keys();
                while (enProps.hasMoreElements()) {
                    String key = enProps.nextElement();
                    storedProperties.put(key, newProperties.get(key));
                }
                this.manageServiceConfigurations(this.getAllServices(), false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void bindServiceManager(ServiceManager serviceManagerUpdater) {
        this.serviceManager = serviceManagerUpdater;
    }

    public void unbindServiceManager(ServiceManager serviceManagerUpdater) {
        this.serviceManager = null;
    }
}

