/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.component;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.component.ComponentRegistry;
import org.ow2.util.component.Components;
import org.ow2.util.component.api.ComponentException;
import org.ow2.util.component.api.IComponent;
import org.ow2.util.component.api.IComponentManager;
import org.ow2.util.component.api.IComponentRegistry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ComponentManager
implements IComponentManager {
    private static final String COMPONENT_STR = "Component";
    private Log logger = LogFactory.getLog(ComponentManager.class);
    private List<String> componentNames = null;
    private Components components = null;
    private ComponentRegistry componentRegistry = new ComponentRegistry();

    public ComponentManager() {
        this.componentNames = new ArrayList<String>();
    }

    public ComponentManager(Components components) {
        this();
        this.setComponents(components);
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public void addComponent(IComponent component) throws ComponentException {
        this.addComponent(this.getComponentName(component), component);
    }

    public void removeComponent(IComponent component) throws ComponentException {
        String componentName = this.componentRegistry.getComponentName(component);
        this.componentNames.remove(componentName);
        this.componentRegistry.unregister(componentName);
    }

    private String getComponentName(IComponent component) {
        String componentName = component.getClass().getCanonicalName();
        int index = 2;
        if (this.componentNames.contains(componentName)) {
            while (this.componentNames.contains(componentName)) {
                componentName = componentName + index++;
            }
        }
        return componentName;
    }

    private void addComponent(String componentName, IComponent component) throws ComponentException {
        this.componentRegistry.register(componentName, component);
        this.componentNames.add(componentName);
    }

    public void initComponents() throws ComponentException {
        if (this.components == null) {
            return;
        }
        List<IComponent> componentList = this.components.getComponents();
        if (componentList != null) {
            for (IComponent component : componentList) {
                this.addComponent(component);
            }
            for (String componentName : this.componentNames) {
                IComponent component = this.componentRegistry.getComponent(componentName);
                component.init();
            }
        }
    }

    public void startComponents() throws ComponentException {
        StringBuilder sb = new StringBuilder();
        sb.append("[ Component(s) started : ");
        for (String componentName : this.componentNames) {
            IComponent component = this.componentRegistry.getComponent(componentName);
            component.start();
            String name = component.getClass().getSimpleName();
            if (name.endsWith(COMPONENT_STR)) {
                name = name.substring(0, name.lastIndexOf(COMPONENT_STR));
            }
            sb.append(name);
            sb.append(" ");
        }
        sb.append("]");
        this.logger.info(sb.toString(), new Object[0]);
    }

    public void stopComponents() {
        int size = this.componentNames.size();
        for (int i = size - 1; i >= 0; --i) {
            String componentName = this.componentNames.get(i);
            IComponent component = this.componentRegistry.getComponent(componentName);
            try {
                component.stop();
                continue;
            }
            catch (ComponentException e) {
                this.logger.error("Cannot stop component with name '" + componentName + "'.", e);
            }
        }
    }

    public IComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }
}

