/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.util.component.api.ComponentException;
import org.ow2.util.component.api.IComponent;
import org.ow2.util.component.api.IComponentRegistry;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry
implements IComponentRegistry {
    private Log logger = LogFactory.getLog(ComponentRegistry.class);
    private Map<String, IComponent> components = new HashMap<String, IComponent>();

    @Override
    public void register(String componentName, IComponent component) throws ComponentException {
        if (this.components.containsKey(componentName)) {
            throw new ComponentException("Cannot register the component with the name '" + componentName + "'. There is an existing component with this name.");
        }
        this.logger.debug("Registering component with name {0}.", componentName);
        this.components.put(componentName, component);
    }

    @Override
    public void unregister(String componentName) throws ComponentException {
        if (!this.components.containsKey(componentName)) {
            throw new ComponentException("No component with the name '" + componentName + "' found. Component not unregistered");
        }
        this.logger.info("Unregistering component with name {0}.", componentName);
        this.components.remove(componentName);
    }

    @Override
    public void unregister(IComponent component) throws ComponentException {
        String name = null;
        Set<String> keys = this.components.keySet();
        for (String key : keys) {
            IComponent foundComponent = this.components.get(key);
            if (!foundComponent.equals(component)) continue;
            name = key;
            break;
        }
        if (name != null) {
            this.unregister(name);
        }
        throw new ComponentException("No component found in the registry with the given component '" + component + "'.");
    }

    @Override
    public IComponent getComponent(String componentName) {
        return this.components.get(componentName);
    }

    @Override
    public String getComponentName(IComponent component) {
        String match = null;
        Iterator<String> i = this.components.keySet().iterator();
        while (i.hasNext() && match == null) {
            String key = i.next();
            IComponent candidate = this.components.get(key);
            if (!component.equals(candidate)) continue;
            match = key;
            break;
        }
        if (match == null) {
            throw new IllegalStateException("Each component should be registered in the registry. No component found for '" + component + "'.");
        }
        return match;
    }

    @Override
    public <T extends IComponent> List<T> getComponents(Class<T> itf) {
        if (itf == null) {
            throw new IllegalArgumentException("Cannot find component with a null interface");
        }
        if (!itf.isInterface()) {
            throw new IllegalArgumentException("The given class '" + itf + "' is not an interface");
        }
        ArrayList<IComponent> matchComponents = new ArrayList<IComponent>();
        for (IComponent component : this.components.values()) {
            if (!Arrays.asList(component.getClass().getInterfaces()).contains(itf)) continue;
            matchComponents.add(component);
        }
        return matchComponents;
    }
}

