/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.impl.deployable.metadata.DeployableMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.impl.JClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbJarDeployableMetadata<E extends EJBDeployable<E>>
extends DeployableMetadata<E>
implements IEjbJarDeployableMetadata<E> {
    private static Log logger = LogFactory.getLog(EjbJarDeployableMetadata.class);
    private Map<String, IEjbJarClassMetadata<E>> classesAnnotationMetadata = new HashMap<String, IEjbJarClassMetadata<E>>();
    private EJB3 ejb3 = null;
    private Map<String, ApplicationException> applicationExceptions = null;
    private Map<InterceptorType, List<JClassInterceptor>> defaultInterceptors = null;
    private IJInterceptors defaultInterceptorsClasses = null;

    public EjbJarDeployableMetadata(E deployable) {
        super(deployable);
    }

    @Override
    public void addEjbJarClassMetadata(IEjbJarClassMetadata<E> classAnnotationMetadata) {
        String key = classAnnotationMetadata.getClassName();
        if (this.classesAnnotationMetadata.containsKey(key)) {
            String msg = logger.getI18n().getMessage("EjbJarAnnotationMetadata.addClassAnnotationMetadata.alreadyPresent", key);
            logger.debug(msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.classesAnnotationMetadata.put(key, classAnnotationMetadata);
    }

    @Override
    public IEjbJarClassMetadata<E> getEjbJarClassMetadataForEjbName(String ejbName) {
        for (IEjbJarClassMetadata<E> metadata : this.classesAnnotationMetadata.values()) {
            IJCommonBean bean = metadata.getJCommonBean();
            if (bean == null || !ejbName.equals(bean.getName())) continue;
            return metadata;
        }
        return null;
    }

    @Override
    public IEjbJarClassMetadata<E> getEjbJarClassMetadata(String className) {
        return this.classesAnnotationMetadata.get(className);
    }

    @Override
    public Collection<IEjbJarClassMetadata<E>> getEjbJarClassMetadataCollection() {
        return this.classesAnnotationMetadata.values();
    }

    public EJB3 getEjb3() {
        return this.ejb3;
    }

    public void setEjb3(EJB3 ejb3) {
        this.ejb3 = ejb3;
    }

    @Override
    public Map<String, ApplicationException> getApplicationExceptions() {
        if (this.applicationExceptions != null) {
            return this.applicationExceptions;
        }
        this.applicationExceptions = new HashMap<String, ApplicationException>();
        for (IEjbJarClassMetadata<E> classMetadata : this.getEjbJarClassMetadataCollection()) {
            ApplicationException appException = classMetadata.getApplicationException();
            if (appException == null) continue;
            this.applicationExceptions.put(classMetadata.getClassName().replaceAll("/", "."), appException);
        }
        this.applicationExceptions.put("DEFAULT", new JApplicationException());
        return this.applicationExceptions;
    }

    public Map<InterceptorType, List<JClassInterceptor>> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(Map<InterceptorType, List<JClassInterceptor>> defaultInterceptors) {
        this.defaultInterceptors = defaultInterceptors;
    }

    @Override
    public IJInterceptors getDefaultInterceptorsClasses() {
        return this.defaultInterceptorsClasses;
    }

    @Override
    public void setDefaultInterceptorsClasses(IJInterceptors defaultInterceptorsClasses) {
        this.defaultInterceptorsClasses = defaultInterceptorsClasses;
    }
}

