/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Listener;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Servlet;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.WAR;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AbsWebLoader
extends AbsDeploymentDescLoader {
    private WAR war = null;

    protected AbsWebLoader(URL url) {
        this(url, new WAR());
    }

    protected AbsWebLoader(URL url, WAR war) {
        super(url);
        this.war = war;
    }

    protected void analyzeServlet(Element servletElement, Servlet servlet) {
        String name = XMLUtils.getStringValueElement(servletElement, "servlet-name");
        servlet.setName(name);
        String className = XMLUtils.getStringValueElement(servletElement, "servlet-class");
        servlet.setClassName(className);
    }

    protected void analyzeListeners(Element rootElement) {
        NodeList listenerList = rootElement.getElementsByTagName("listener");
        for (int i = 0; i < listenerList.getLength(); ++i) {
            Element listenerElement = (Element)listenerList.item(i);
            Listener listener = new Listener();
            this.war.addListener(listener);
            this.analyzeListener(listenerElement, listener);
        }
    }

    protected void analyzeServlets(Element rootElement) {
        NodeList servletList = rootElement.getElementsByTagName("servlet");
        for (int i = 0; i < servletList.getLength(); ++i) {
            Element servletElement = (Element)servletList.item(i);
            Servlet servlet = new Servlet();
            this.getWAR().addServlet(servlet);
            this.analyzeServlet(servletElement, servlet);
        }
    }

    protected void analyzeListener(Element listenerElement, Listener listener) {
        String listenerClassName = XMLUtils.getStringValueElement(listenerElement, "listener-class");
        listener.setListenerClassName(listenerClassName);
    }

    public WAR getWAR() {
        return this.war;
    }
}

