/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventToken;

public class EventDispatcher
implements IEventDispatcher {
    private static final int DEFAULT_SIZE = 1;
    private final HashMap<EventPriority, CopyOnWriteArrayList<IEventListener>> listeners;
    private final EventQueue queue;
    private final EventToken kill = new EventToken();
    private boolean available = false;
    private int size = 1;

    public EventDispatcher() {
        this.queue = new EventQueue();
        this.listeners = new HashMap();
        for (EventPriority priority : EventPriority.values()) {
            this.listeners.put(priority, new CopyOnWriteArrayList());
        }
    }

    public synchronized void start() {
        if (!this.available) {
            this.available = true;
            this.createWorkers(this.size);
        }
    }

    public synchronized void stop() {
        if (this.available) {
            this.available = false;
            this.destroyWorkers(this.size);
        }
    }

    public synchronized boolean isAvailable() {
        return this.available;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void setSize(int size) {
        if (this.available) {
            int diff = this.size - size;
            if (diff > 0) {
                this.destroyWorkers(diff);
            } else {
                this.createWorkers(-diff);
            }
        }
        this.size = size;
    }

    public void addListener(IEventListener listener) {
        this.listeners.get((Object)listener.getPriority()).add(listener);
    }

    public void removeListener(IEventListener listener) {
        this.listeners.get((Object)listener.getPriority()).remove(listener);
    }

    public IEventToken dispatch(IEvent event) {
        return this.dispatch(event, Long.MAX_VALUE);
    }

    public IEventToken dispatch(IEvent event, long timeout) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        EventToken token = new EventToken(event);
        token.allocate();
        while (System.currentTimeMillis() < start + timeout) {
            try {
                token.join(EventPriority.values()[EventPriority.NONE.ordinal() - 1], start + timeout - System.currentTimeMillis());
            }
            catch (InterruptedException e) {}
        }
        return token;
    }

    private void createWorkers(int nb) {
        for (int i = 0; i < nb; ++i) {
            new EventWorker().start();
        }
    }

    private void destroyWorkers(int nb) {
        EventToken kill = this.kill;
        EventQueue queue = this.queue;
        for (int i = 0; i < nb; ++i) {
            queue.put(kill);
        }
    }

    private final class EventToken
    implements IEventToken {
        private IEvent event;
        private boolean killed = false;
        private Semaphore lock = new Semaphore(1, true);
        private LinkedList<EventWorker> workers = new LinkedList();
        private HashMap<EventPriority, Integer> counts = new HashMap();
        private HashMap<EventPriority, Semaphore> semaphores = new HashMap();
        private HashMap<IEventListener, EventPriority> priorities = new HashMap();
        private ConcurrentLinkedQueue<IEventListener> listeners = new ConcurrentLinkedQueue();

        private EventToken() {
        }

        private EventToken(IEvent event) {
            this.event = event;
            this.counts.put(null, 0);
            this.semaphores.put(null, new Semaphore(0, true));
            for (EventPriority priority : EventPriority.values()) {
                int count = 0;
                for (IEventListener listener : (CopyOnWriteArrayList)EventDispatcher.this.listeners.get((Object)priority)) {
                    if (!listener.accept(event)) continue;
                    this.priorities.put(listener, priority);
                    this.listeners.add(listener);
                    ++count;
                }
                this.counts.put(priority, count);
                this.semaphores.put(priority, new Semaphore(0, true));
            }
        }

        public void terminate() {
            this.lock.acquireUninterruptibly();
            this.killed = true;
            for (EventWorker worker : this.workers) {
                worker.stop();
            }
            EventDispatcher.this.createWorkers(this.workers.size());
            this.lock.release();
        }

        public void allocate() {
            EventDispatcher.this.queue.put(this);
        }

        public boolean join(long timeout) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, false);
        }

        public boolean join(long timeout, boolean kill) throws InterruptedException {
            return this.join(EventPriority.values()[EventPriority.values().length - 1], timeout, kill);
        }

        public boolean join(EventPriority priority, long timeout) throws InterruptedException {
            return this.join(priority, timeout, false);
        }

        public boolean join(EventPriority priority, long timeout, boolean kill) throws InterruptedException {
            int count = this.counts.get((Object)priority);
            Semaphore semaphore = this.semaphores.get((Object)priority);
            boolean ok = semaphore.tryAcquire(count, timeout, TimeUnit.MILLISECONDS);
            if (ok) {
                semaphore.release(count);
            } else if (kill) {
                this.terminate();
            }
            return ok;
        }
    }

    private final class EventWorker
    extends Thread {
        private EventWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EventQueue queue = EventDispatcher.this.queue;
            EventToken kill = EventDispatcher.this.kill;
            EventToken token;
            while ((token = queue.take()) != kill) {
                IEventListener listener;
                token.lock.acquireUninterruptibly();
                if (token.killed) {
                    token.lock.release();
                    continue;
                }
                token.workers.add(this);
                token.lock.release();
                while ((listener = (IEventListener)token.listeners.poll()) != null) {
                    EventPriority[] priorities = EventPriority.values();
                    EventPriority currPrio = (EventPriority)((Object)token.priorities.get(listener));
                    EventPriority prevPrio = currPrio.ordinal() > 0 ? priorities[currPrio.ordinal() - 1] : null;
                    Semaphore currSemaphore = (Semaphore)token.semaphores.get((Object)currPrio);
                    Semaphore prevSemaphore = (Semaphore)token.semaphores.get((Object)prevPrio);
                    int prevCount = (Integer)token.counts.get((Object)prevPrio);
                    prevSemaphore.acquireUninterruptibly(prevCount);
                    prevSemaphore.release(prevCount);
                    try {
                        listener.handle(token.event);
                    }
                    catch (Exception ex) {}
                    continue;
                    finally {
                        currSemaphore.release();
                    }
                }
                token.lock.acquireUninterruptibly();
                token.workers.remove(this);
                token.lock.release();
            }
            return;
        }
    }

    private final class EventQueue {
        private final SynchronousQueue<EventToken> synchronousQueue = new SynchronousQueue(true);
        private final ConcurrentLinkedQueue<EventToken> concurrentLinkedQueue = new ConcurrentLinkedQueue();

        private EventQueue() {
        }

        public void put(EventToken token) {
            if (!this.synchronousQueue.offer(token)) {
                this.concurrentLinkedQueue.offer(token);
            }
        }

        public EventToken take() {
            while (true) {
                try {
                    EventToken token = this.concurrentLinkedQueue.poll();
                    if (token != null) {
                        return token;
                    }
                    return this.synchronousQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
    }
}

