/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import org.ow2.util.asm.ClassReader;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.impl.ScanClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASMScannerImpl
implements IScanner {
    @Override
    public void scanClass(URL url, Set<String> referencedClasses, List<IArchiveConfigurator> archiveConfiguratorList) throws ScanException {
        InputStream is = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
            is = urlConnection.getInputStream();
            new ClassReader(is).accept(new ScanClassVisitor(archiveConfiguratorList, referencedClasses), 0);
        }
        catch (Exception ioe) {
            throw new ScanException("Error while analyzing file entry '" + url + "'", ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new ScanException("Error while closing input stream of the entry '" + url + "'", e);
                }
            }
        }
    }
}

