/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.url;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.ow2.util.url.URLUtilsException;

public final class URLUtils {
    public static final String FILE_PROTOCOL = "file";

    private URLUtils() {
    }

    public static URL fileToURL(File file) {
        try {
            return URLUtils.fileToURL2(file);
        }
        catch (URLUtilsException e) {
            throw new IllegalArgumentException("Cannot get URL from the given file '" + file + "'.", e);
        }
    }

    public static URL fileToURL2(File file) throws URLUtilsException {
        if (file == null) {
            throw new URLUtilsException("Invalid File. It is null");
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new URLUtilsException("Cannot get URL from the given file '" + file + "'.", e);
        }
    }

    public static File urlToFile(URL url) {
        try {
            return URLUtils.urlToFile2(url);
        }
        catch (URLUtilsException e) {
            throw new IllegalArgumentException("Cannot get File from the given url '" + url + "'.", e);
        }
    }

    public static File urlToFile2(URL url) throws URLUtilsException {
        if (url == null) {
            throw new URLUtilsException("Invalid URL. It is null");
        }
        if (!url.getProtocol().equals(FILE_PROTOCOL)) {
            throw new URLUtilsException("Invalid protocol named '" + url.getProtocol() + "'. Protocol should be '" + FILE_PROTOCOL + "'.");
        }
        try {
            return new File(new URI(url.toString()));
        }
        catch (URISyntaxException ignored) {
            File temp = new File(url.getFile());
            try {
                temp.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new URLUtilsException("Cannot get File from the given url '" + url + "'.", e);
            }
            return temp;
        }
    }

    public static String shorterName(URL url) {
        String urlExternalForm = url.toExternalForm();
        if (urlExternalForm.charAt(urlExternalForm.length() - 1) == '/') {
            urlExternalForm = urlExternalForm.substring(0, urlExternalForm.length() - 1);
        }
        int slashPos = urlExternalForm.lastIndexOf(47);
        return urlExternalForm.substring(slashPos + 1, urlExternalForm.length());
    }
}

