/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.jonasbase.JEcho;
import org.ow2.jonas.ant.jonasbase.JMkdir;
import org.ow2.jonas.ant.jonasbase.JTouch;
import org.ow2.jonas.ant.jonasbase.Tasks;

public class ModJk
extends Tasks {
    private static final String INFO = "[ModJk] ";
    private static final String MOD_JK_WORKER_FILE = "workers.properties";
    private static final String MOD_JK_TOMCAT_FILE = "tomcat_jk.conf";
    private static final String HTTPD_CONF_FILE = "httpd.conf";
    private File fileWorker = null;
    private File fileTomcat = null;
    private File fileHttpd = null;
    private List workersList = new ArrayList();
    private boolean stickySession = false;
    private String rootDir = null;
    private String dir = null;

    public void createFiles() {
        String modJkDir = this.rootDir + File.separator + this.dir;
        JMkdir mkdir = new JMkdir();
        mkdir.setDestDir(new File(modJkDir));
        this.addTask((Task)mkdir);
        JTouch touchWorker = new JTouch();
        this.fileWorker = new File(modJkDir + "/" + MOD_JK_WORKER_FILE);
        touchWorker.setDestDir(this.fileWorker);
        this.addTask((Task)touchWorker);
        JTouch touchTomcat = new JTouch();
        this.fileTomcat = new File(modJkDir + "/" + MOD_JK_TOMCAT_FILE);
        touchTomcat.setDestDir(this.fileTomcat);
        this.addTask((Task)touchTomcat);
    }

    public String addWorker(String portNumber, String lbFactor) {
        Worker worker = new Worker();
        worker.setPortNumber(portNumber);
        worker.setLbFactor(lbFactor);
        int index = this.workersList.size() + 1;
        worker.setName("worker" + index);
        this.workersList.add(worker);
        return worker.getName();
    }

    private String getWorkerDef(Worker worker) {
        String workerDef = "\n# -----------------------\n# " + worker.getName() + "\n" + "# -----------------------" + "\n" + "worker." + worker.getName() + ".port=" + worker.getPortNumber() + "\n" + "worker." + worker.getName() + ".host=localhost" + "\n" + "worker." + worker.getName() + ".type=ajp13" + "\n" + "# Load balance factor" + "\n" + "worker." + worker.getName() + ".lbfactor=" + worker.getLbFactor() + "\n" + "# Define prefered failover node for " + worker.getName() + "\n" + "#worker." + worker.getName() + ".redirect=worker2" + "\n" + "# Disable " + worker.getName() + " for all requests except failover" + "\n" + "#worker." + worker.getName() + ".disabled=True" + "\n";
        return workerDef;
    }

    private void flushWorkerFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.fileWorker);
        String workersNameList = "";
        String workersDefs = "";
        for (Worker worker : this.workersList) {
            workersNameList = workersNameList.compareTo("") == 0 ? workersNameList + worker.getName() : workersNameList + "," + worker.getName();
            workersDefs = workersDefs + this.getWorkerDef(worker);
        }
        String contentFile = "\n# -----------------------\n# List the workers name\n# -----------------------\nworker.list=loadbalancer,jkstatus\n" + workersDefs + "\n" + "# -----------------------" + "\n" + "# Load Balancer worker" + "\n" + "# -----------------------" + "\n" + "worker.loadbalancer.type=lb" + "\n" + "worker.loadbalancer.balanced_workers=" + workersNameList + "\n" + "worker.loadbalancer.sticky_session=" + this.stickySession + "\n" + "# -----------------------" + "\n" + "# jkstatus worker" + "\n" + "# -----------------------" + "\n" + "worker.jkstatus.type=status" + "\n";
        echo.setMessage(contentFile);
        echo.setLogInfo("[ModJk] Flushing Configuration in '" + this.fileWorker + "'");
        this.addTask((Task)echo);
    }

    private void flushTomcatFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.fileTomcat);
        String contentFile = "\nLoadModule jk_module modules/mod_jk.so\n# Location of the worker file\nJkWorkersFile " + this.dir + File.separator + MOD_JK_WORKER_FILE + "\n" + "# Location of the log file" + "\n" + "JkLogFile " + this.dir + File.separator + "mod_jk.log" + "\n" + "# Log level : debug, info, error or emerg" + "\n" + "JkLogLevel emerg" + "\n" + "# Shared Memory Filename ( Only for Unix platform ) required by loadbalancer" + "\n" + "JkShmFile " + this.dir + File.separator + "jk.shm" + "\n" + "# Assign specific URL to Tomcat workers" + "\n" + "JkMount /sampleCluster2 loadbalancer" + "\n" + "JkMount /sampleCluster2/* loadbalancer" + "\n" + "# A mount point to the status worker" + "\n" + "JkMount /jkmanager jkstatus" + "\n" + "JkMount /jkmanager/* jkstatus" + "\n" + "# Enable the Jk manager access only from localhost" + "\n" + "<Location /jkmanager/>" + "\n" + "    JkMount jkstatus" + "\n" + "    Order deny,allow" + "\n" + "    Deny from all" + "\n" + "    Allow from 127.0.0.1" + "\n" + "</Location>" + "\n";
        echo.setMessage(contentFile);
        echo.setLogInfo("[ModJk] Flushing Configuration in '" + this.fileTomcat + "'");
        this.addTask((Task)echo);
    }

    private void flushHttpdFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.fileHttpd);
        String contentFile = "\nInclude " + this.dir + File.separator + MOD_JK_TOMCAT_FILE + "\n";
        echo.setMessage(contentFile);
        echo.setLogInfo("[ModJk] Flushing Configuration in '" + this.fileHttpd + "'");
        this.addTask((Task)echo);
    }

    public void flushFiles() {
        this.flushWorkerFile();
        this.flushTomcatFile();
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setRootDir(String dir) {
        this.rootDir = dir;
    }

    public class Worker {
        private String portNumber = null;
        private String lbFactor = null;
        private String name = null;

        public String getPortNumber() {
            return this.portNumber;
        }

        public void setPortNumber(String portNumber) {
            this.portNumber = portNumber;
        }

        public String getLbFactor() {
            return this.lbFactor;
        }

        public void setLbFactor(String lbFactor) {
            this.lbFactor = lbFactor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

