/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadata;
import org.ow2.util.ee.metadata.war.api.IWarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.war.api.exceptions.WARDeploymentDescException;
import org.ow2.util.ee.metadata.war.impl.WarClassesLocator;
import org.ow2.util.ee.metadata.war.impl.configurator.WarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.war.impl.specific.ISpecificWarDeployableFactory;
import org.ow2.util.ee.metadata.war.impl.xml.Filter;
import org.ow2.util.ee.metadata.war.impl.xml.Listener;
import org.ow2.util.ee.metadata.war.impl.xml.Servlet;
import org.ow2.util.ee.metadata.war.impl.xml.Tag;
import org.ow2.util.ee.metadata.war.impl.xml.WAR;
import org.ow2.util.ee.metadata.war.impl.xml.WARDeploymentDesc;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.ScanException;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.impl.ASMScannerImpl;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDeployableMetadataFactory
implements IWarDeployableMetadataFactory {
    private static final Log LOGGER = LogFactory.getLog(WarDeployableMetadataFactory.class);
    private IScanner scanner;

    public WarDeployableMetadataFactory() throws ScanException {
        this.scanner = new ASMScannerImpl();
    }

    public WarDeployableMetadataFactory(IScanner scanner) {
        this.scanner = scanner;
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(deployable, null, null);
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        if (classLoader != null) {
            classesLocatorList = Arrays.asList(new ClassLoaderClassesLocator(classLoader));
        }
        return this.createDeployableMetadata(deployable, classesLocatorList, null);
    }

    private void completeClassList(WAR war, Set<String> classNames) {
        String className;
        for (Servlet servlet : war.getServlets()) {
            className = servlet.getClassName();
            if (className == null) continue;
            classNames.add(className.replace('.', '/'));
        }
        for (Listener listener : war.getListeners()) {
            className = listener.getListenerClassName();
            if (className == null) continue;
            classNames.add(className.replace('.', '/'));
        }
        for (Tag tag : war.getTags()) {
            className = tag.getTagClassName();
            if (className == null) continue;
            classNames.add(className.replace('.', '/'));
        }
        for (Filter filter : war.getFilters()) {
            className = filter.getFilterClassName();
            if (className == null) continue;
            classNames.add(className.replace('.', '/'));
        }
    }

    public IWarDeployableMetadata createDeployableMetadata(WARDeployable deployable, List<? extends IClassesLocator> warExternLibraries, List<? extends ISpecificWarDeployableFactory> specificDeployableFactoryList) throws DeployableMetadataException {
        WAR war;
        try {
            if (!URLUtils.urlToFile2((URL)deployable.getArchive().getURL()).isDirectory()) {
                throw new DeployableMetadataException("war must be uncompressed (local directory expected)");
            }
        }
        catch (URLUtilsException e) {
            throw new DeployableMetadataException("war must be uncompressed (local directory expected)");
        }
        catch (ArchiveException e) {
            throw new DeployableMetadataException("war exception", (Throwable)e);
        }
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = deployable.getArchive();
        try {
            war = WARDeploymentDesc.getWAR(archive);
        }
        catch (WARDeploymentDescException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        WarDeployableMetadataConfigurator warArchiveMetadataConfigurator = new WarDeployableMetadataConfigurator(deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        if (specificDeployableFactoryList != null) {
            for (ISpecificWarDeployableFactory iSpecificWarDeployableFactory : specificDeployableFactoryList) {
                warArchiveMetadataConfigurator.addSpecificMetadataConfigurator(iSpecificWarDeployableFactory.beforeScan(deployable, classNameSet));
            }
        }
        this.completeClassList(war, classNameSet);
        if (war.isMetadataComplete()) {
            warArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        }
        List<IArchiveConfigurator> archiveConfiguratorList = Arrays.asList(warArchiveMetadataConfigurator);
        WarClassesLocator warClassesLocator = new WarClassesLocator(archive);
        ArrayList<String> scannedClasses = new ArrayList<String>();
        ArrayList<String> nextClassNameToScan = new ArrayList<String>();
        nextClassNameToScan.addAll(classNameSet);
        try {
            while (nextClassNameToScan.size() != 0) {
                classNameSet.clear();
                for (String className : nextClassNameToScan) {
                    URL url = warClassesLocator.getClassURL(className);
                    if (url == null && warExternLibraries != null) {
                        IClassesLocator classesLocator;
                        Iterator<? extends IClassesLocator> i$ = warExternLibraries.iterator();
                        while (i$.hasNext() && (url = (classesLocator = i$.next()).getClassURL(className)) == null) {
                        }
                    }
                    if (url != null) {
                        this.scanner.scanClass(url, classNameSet, archiveConfiguratorList);
                    }
                    scannedClasses.add(className);
                }
                nextClassNameToScan.clear();
                for (String className : classNameSet) {
                    if (scannedClasses.contains(className)) continue;
                    nextClassNameToScan.add(className);
                }
            }
        }
        catch (ScanException e) {
            throw new DeployableMetadataException("Error during scan", (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Analyze of file {0} took {1} ms.", new Object[]{archive.getName(), tAnalyzeStartEnd - tAnalyzeStart});
            }
        }
        return warArchiveMetadataConfigurator.getWarDeployableMetadata();
    }

    public Class<IWarDeployableMetadata> getDeployableMetadataClass() {
        return IWarDeployableMetadata.class;
    }
}

