/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.cmi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.cmi.CmiCluster;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmiClusterFactory
extends ClusterFactory {
    private HashMap<String, CmiCluster> myclusters = new HashMap();

    public CmiClusterFactory(DomainMonitor dm) {
        super(dm);
    }

    @Override
    public BaseCluster getCluster(String name) {
        return this.myclusters.get(name);
    }

    @Override
    public boolean notifyServer(ServerProxy proxy) {
        ObjectName ons;
        String serverName = proxy.getServerName();
        logger.log(BasicLevel.DEBUG, (Object)serverName);
        try {
            ons = ObjectName.getInstance(this.domainName + ":name=CMIServer,*");
        }
        catch (MalformedObjectNameException e1) {
            logger.log(BasicLevel.ERROR, (Object)"MalformedObjectNameException");
            return false;
        }
        Set set = proxy.queryNames(ons);
        if (set == null) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot reach " + serverName));
            return false;
        }
        if (set.isEmpty()) {
            logger.log(BasicLevel.DEBUG, (Object)"No CMI Cluster with name=CMIServer declared");
            return false;
        }
        ObjectName on2 = null;
        String protocol = null;
        Iterator it = set.iterator();
        while (it.hasNext() && !"UDP".equals(protocol = (on2 = (ObjectName)it.next()).getKeyProperty("protocol")) && !"TCP".equals(protocol)) {
        }
        logger.log(BasicLevel.DEBUG, (Object)("Found CMICluster protocol=" + protocol));
        String clusterName = on2.getKeyProperty("cluster");
        CmiCluster cluster = this.myclusters.get(clusterName);
        if (cluster == null) {
            ObjectName clon = null;
            try {
                cluster = new CmiCluster(this);
                clon = cluster.setName(clusterName);
            }
            catch (JMException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create CMI Cluster:" + e));
                return false;
            }
            cluster.setProtocol(protocol);
            String strprop = (String)proxy.getAttribute(on2, "PropertiesAsString");
            StringTokenizer stk = new StringTokenizer(strprop, "{},");
            int nb = stk.countTokens();
            for (int i = 0; i < nb; ++i) {
                String str = stk.nextToken();
                int ind = str.indexOf(61, 0);
                if (ind <= 0) {
                    logger.log(BasicLevel.ERROR, (Object)("Bad property: " + str));
                }
                String key = str.substring(0, ind).trim();
                String value = str.substring(ind + 1).trim();
                logger.log(BasicLevel.DEBUG, (Object)(key + "=" + value));
                if (key.equals("mcast_port")) {
                    int mcastPort = new Integer(value);
                    cluster.setMcastPort(mcastPort);
                }
                if (!key.equals("mcast_addr")) continue;
                cluster.setMcastAddr(value);
            }
            ObjectName cmiOn = null;
            for (ObjectName on2 : set) {
                String type = on2.getKeyProperty("type");
                if (!"cmi".equals(type)) continue;
                cmiOn = on2;
                break;
            }
            cluster.delayToRefresh = (Integer)proxy.getAttribute(cmiOn, "DelayToRefresh");
            if (!this.mbeanServer.isRegistered(clon)) {
                try {
                    this.mbeanServer.registerMBean(cluster, clon);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot register cluster:" + e));
                    return false;
                }
            }
            this.myclusters.put(clusterName, cluster);
        }
        return cluster.addCmiServer(serverName, proxy);
    }

    @Override
    public Collection<CmiCluster> getClusterList() {
        return this.myclusters.values();
    }

    @Override
    public void getMonitoringInfo() {
        for (CmiCluster cmiCluster : this.myclusters.values()) {
            cmiCluster.getMonitoringInfo();
        }
    }
}

