/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIAdminConnectorManager;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.config.CMIProperty;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.cmi.controller.server.ClusteredDummyRegistry;
import org.ow2.cmi.controller.server.DistributedObjectInfo;
import org.ow2.cmi.controller.server.IPolicyStrategyManager;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.cmi.controller.server.filter.BlacklistFilter;
import org.ow2.cmi.controller.server.filter.IFilter;
import org.ow2.cmi.controller.server.manager.DefaultPolicyStrategyManager;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.CMIInfoRepository;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.loader.IDefaultPolicyStrategyLoader;
import org.ow2.cmi.loader.IPolicyStrategyLoader;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.component.ComponentManager;
import org.ow2.util.component.Components;
import org.ow2.util.component.api.IComponent;
import org.ow2.util.component.api.IComponentManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsServerClusterViewManager
extends AbsClusterViewManager
implements ServerClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsServerClusterViewManager.class);
    private final Map<String, String> initialContextFactories = new ConcurrentHashMap<String, String>();
    private final Map<String, ServerId> refsOnLocalRegistries = new ConcurrentHashMap<String, ServerId>();
    private final Map<String, Remote> clientClusterViewProviders = new ConcurrentHashMap<String, Remote>();
    private final Map<String, Context> contexts = new ConcurrentHashMap<String, Context>();
    private InetAddress inetAddress = null;
    private ClusteredObjectInfo clusteredObjectInfoForDummyRegistry;
    private boolean replicationManagerStarted = false;
    private static boolean started = false;
    private final ConcurrentHashMap<String, Class<?>> interfaces = new ConcurrentHashMap();
    protected IPolicyStrategyManager policyStrategyManager = null;
    protected IPolicyStrategyLoader policyStrategyLoader = null;
    private final List<IFilter> localFilters = new ArrayList<IFilter>();
    private Components components;
    private IComponentManager componentManager = null;

    protected AbsServerClusterViewManager() {
        IPolicyStrategyManager policStrategyManager = AbsServerClusterViewManager.registerPolicyStrategyManager(this);
        AbsServerClusterViewManager.registerPolicyStrategyLoader(this, policStrategyManager);
        policStrategyManager.loadEmbeddedLBClasses();
        this.localFilters.add(new BlacklistFilter(this));
        try {
            this.clusteredObjectInfoForDummyRegistry = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(CMIConfig.getBindNameForDummyRegistry(), null, ClusteredDummyRegistry.class, false, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot get infos for dummy context", new Object[]{e});
            throw new ServerClusterViewManagerException("Cannot get infos for dummy context", e);
        }
        this.components = new Components();
        this.componentManager = new ComponentManager(this.components);
    }

    public static synchronized ServerClusterViewManager start() throws ServerClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (!started && clusterViewManager != null) {
            LOGGER.warn((Object)"CMI has been already started with the creation of a new initial context.", new Object[0]);
            started = true;
            if (!(clusterViewManager instanceof ServerClusterViewManager)) {
                throw new ServerClusterViewManagerException("A cluster view manager already exists but doesn't implement the interface ServerClusterViewManager");
            }
        } else if (!started) {
            clusterViewManager = AbsServerClusterViewManager.getServerClusterViewManager();
            ((AbsServerClusterViewManager)clusterViewManager).doStart();
            started = true;
        }
        return (ServerClusterViewManager)clusterViewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (started) {
            AbsServerClusterViewManager serverClusterViewManager = (AbsServerClusterViewManager)AbsServerClusterViewManager.getServerClusterViewManager();
            try {
                MBeanUtils.unregisterCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error((Object)"Cannot unregister CMIMBean", new Object[]{e});
            }
            for (String protocol : serverClusterViewManager.initialContextFactories.keySet()) {
                try {
                    serverClusterViewManager.contexts.get(protocol).unbind(CMIConfig.getBindNameForProvider());
                }
                catch (NamingException e) {
                    LOGGER.error((Object)"Cannot unbind the instance of ClientClusterViewProvider for the protocol {0}", new Object[]{protocol, e});
                }
                System.setProperty("carol.multipro.protocol", protocol);
                try {
                    PortableRemoteObject.unexportObject((Remote)serverClusterViewManager.clientClusterViewProviders.get(protocol));
                }
                catch (NoSuchObjectException e) {
                    LOGGER.error((Object)"Cannot unexport the instance of ClientClusterViewProvider for the protocol {0}", new Object[]{protocol, e});
                }
                finally {
                    System.setProperty("carol.multipro.protocol", "any");
                }
            }
            serverClusterViewManager.doStop();
            AbsClusterViewManager.setClusterViewManager(null);
            started = false;
            LOGGER.info((Object)"The server-side manager is now stopped.", new Object[0]);
        }
    }

    public abstract void doStart();

    public abstract void doStop();

    public static final synchronized ServerClusterViewManager getServerClusterViewManager() throws ServerClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager == null) {
            AbsServerClusterViewManager serverClusterViewManager;
            Class<? extends ServerClusterViewManager> serverClusterViewManagerClass;
            try {
                MBeanUtils.initCMIMBean();
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error((Object)"Cannot initializes CMIMBean", new Object[]{e});
            }
            try {
                serverClusterViewManagerClass = CMIConfig.getServerClusterViewManagerClass();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)"Cannot load the class implementing a server-side manager.", new Object[0]);
                throw new ServerClusterViewManagerException("Cannot load the class implementing a server-side manager.", e);
            }
            LOGGER.debug((Object)"The ServerClusterViewManager is: {0}", new Object[]{serverClusterViewManagerClass.getName()});
            try {
                serverClusterViewManager = (AbsServerClusterViewManager)serverClusterViewManagerClass.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot create the instance (singleton) of ServerClusterViewManager", new Object[]{e});
                throw new ServerClusterViewManagerException("Cannot get an instance of ServerClusterViewManager", e);
            }
            LOGGER.debug((Object)"ServerClusterViewManager has been created", new Object[0]);
            serverClusterViewManager.setDelayToRefresh(CMIConfig.getRefreshTime());
            try {
                MBeanUtils.registerCMIMBean(serverClusterViewManager);
            }
            catch (CMIMBeanConfigException e) {
                LOGGER.error((Object)"Cannot register CMIMBean", new Object[]{e});
            }
            serverClusterViewManager.initStats();
            clusterViewManager = serverClusterViewManager;
            AbsClusterViewManager.setClusterViewManager(clusterViewManager);
            LOGGER.info((Object)"The server-side manager was successfully started", new Object[0]);
        } else if (!(clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"An instance of the manager that is not a ServerClusterViewManager already exists in the JVM", new Object[0]);
            throw new ServerClusterViewManagerException("An instance of the manager that is not a ServerClusterViewManager already exists in the JVM");
        }
        return (ServerClusterViewManager)clusterViewManager;
    }

    private static IPolicyStrategyManager registerPolicyStrategyManager(AbsServerClusterViewManager serverClusterViewManager) {
        Class<? extends IPolicyStrategyManager> policyStrategyManager = null;
        try {
            policyStrategyManager = CMIConfig.getPolicyStrategyManagerClass();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot load the class implementing a policy/strategy manager.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot load the class implementing a policy/strategy manager.", e);
        }
        LOGGER.debug((Object)"The Manager for policies and strategies is: {0}", new Object[]{policyStrategyManager.getName()});
        IPolicyStrategyManager policStrategyManager = null;
        try {
            if (policyStrategyManager.getName().equals(CMIProperty.DEFAULT_POLICY_STRATEGY_MANAGER.getPropertyName())) {
                policStrategyManager = policyStrategyManager.newInstance();
                serverClusterViewManager.setPolicyStrategyManager(policStrategyManager);
                ((DefaultPolicyStrategyManager)policStrategyManager).setServerClusterViewManager(serverClusterViewManager);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot instantiate default class implementing a policy/strategy manager.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot instantiate default class implementing a policy/strategy manager.", e);
        }
        return policStrategyManager;
    }

    private static void registerPolicyStrategyLoader(AbsServerClusterViewManager serverClusterViewManager, IPolicyStrategyManager policStrategyManager) {
        Class<? extends IPolicyStrategyLoader> policyStrategyLoader = null;
        try {
            policyStrategyLoader = CMIConfig.getPolicyStrategyLoaderClass();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot load the class implementing a policy/strategy loader.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot load the class implementing a policy/strategy loader.", e);
        }
        if (policyStrategyLoader == null) {
            LOGGER.debug((Object)"No policy/strategy loader set.", new Object[0]);
            return;
        }
        LOGGER.debug((Object)"The Loader for policies and stretgies is: {0}", new Object[]{policyStrategyLoader.getName()});
        IPolicyStrategyLoader pStrategyLoader = null;
        try {
            if (policyStrategyLoader.getName().equals(CMIProperty.DEFAULT_OSGI_POLICY_STRATEGY_LOADER.getPropertyName())) {
                pStrategyLoader = policyStrategyLoader.newInstance();
                serverClusterViewManager.setPolicyStrategyLoader(pStrategyLoader);
                ((IDefaultPolicyStrategyLoader)pStrategyLoader).setPolicyStrategyManager(policStrategyManager);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot instantiate default class implementing a policy/strategy loader.", new Object[0]);
            throw new ServerClusterViewManagerException("Cannot instantiate default class implementing a policy/strategy loader.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addProtocol(String initialContextFactoryName, ServerId serverRef, Context cmiContext) throws ServerClusterViewManagerException {
        String protocol = serverRef.getProtocol();
        String providerURL = serverRef.getProviderURL();
        String string = initialContextFactoryName;
        synchronized (string) {
            if (!this.initialContextFactories.containsKey(protocol)) {
                LOGGER.debug((Object)"New protocol {0} added", new Object[]{protocol});
                this.initialContextFactories.put(protocol, initialContextFactoryName);
                if (CMIConfig.isProviderBound()) {
                    LOGGER.debug((Object)"Binds a provider of the cluster view for protocol {0}", new Object[]{protocol});
                    this.bindClientClusterViewProvider(cmiContext, protocol);
                }
                if (CMIConfig.isRegistryBound()) {
                    LOGGER.debug((Object)"Binds a dummy object that represents the registry for protocol {0}", new Object[]{protocol});
                    this.bindDummyRegistry(serverRef);
                }
                this.refsOnLocalRegistries.put(protocol, serverRef);
                InetAddress newInetAddress = serverRef.getInetAddress();
                try {
                    if (NetworkInterface.getByInetAddress(newInetAddress) == null) {
                        LOGGER.error((Object)"The referenced server is not local", new Object[0]);
                        throw new ServerClusterViewManagerException("The referenced server is not local");
                    }
                }
                catch (SocketException e) {
                    LOGGER.error((Object)"Cannot know if the IP is local", new Object[]{e});
                    throw new ServerClusterViewManagerException("Cannot know if the IP is local", e);
                }
                if (this.inetAddress == null) {
                    LOGGER.debug((Object)"InetAdress of manager is {0}", new Object[]{newInetAddress});
                    this.inetAddress = newInetAddress;
                } else if (!newInetAddress.equals(this.inetAddress)) {
                    LOGGER.error((Object)"Host name expected: {0} - Host name found : {1}. All the protocol have to use the same host name !", new Object[]{this.inetAddress, newInetAddress});
                    throw new ServerClusterViewManagerException("Host name expected: " + this.inetAddress.getHostName() + " - Host name found : " + newInetAddress.getHostName() + ". All the protocol have to use the same host name !");
                }
                this.initServerConfig(initialContextFactoryName, serverRef, cmiContext);
                if (!CMIConfig.isEmbedded() && CMIConfig.isConnectorEnabled(protocol)) {
                    try {
                        CMIAdminConnectorManager.startConnector(protocol, providerURL);
                    }
                    catch (CMIMBeanConfigException e) {
                        LOGGER.error((Object)"The connector for the protocol {0} cannot be added", new Object[]{protocol, e});
                        throw new ServerClusterViewManagerException("The connector for the protocol " + protocol + " cannot be added", e);
                    }
                }
            }
        }
    }

    protected void initServerConfig(String initialContextFactoryName, ServerId serverId, Context context) {
        this.setLoadFactor(serverId, CMIConfig.getLoadFactor());
    }

    private void bindClientClusterViewProvider(Context cmiContext, String protocol) throws ServerClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        ClusteredClientClusterViewProvider clientClusterViewProvider = null;
        System.setProperty("carol.multipro.protocol", protocol);
        try {
            clientClusterViewProvider = new ClusteredClientClusterViewProvider(this);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot export the instance of ClientClusterViewProvider for the protocol {0}", new Object[]{protocol, e});
            throw new ServerClusterViewManagerException("Cannot export the instance of ClientClusterViewProvider for the protocol " + protocol, e);
        }
        finally {
            System.setProperty("carol.multipro.protocol", "any");
        }
        String bindName = CMIConfig.getBindNameForProvider();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(bindName, ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot get infos for client provider", new Object[]{e});
            throw new ServerClusterViewManagerException("Cannot get infos for client provider", e);
        }
        CMIInfoRepository.addClusteredObjectInfo(bindName, clusteredObjectInfo);
        try {
            cmiContext.rebind(bindName, (Object)clientClusterViewProvider);
        }
        catch (NamingException e) {
            LOGGER.error((Object)"Cannot rebind a ClientClusterViewProvider for protocol {0}", new Object[]{protocol, e});
            throw new ServerClusterViewManagerException("Cannot rebind a ClientClusterViewProvider " + protocol, e);
        }
        this.clientClusterViewProviders.put(protocol, clientClusterViewProvider);
        this.contexts.put(protocol, cmiContext);
        LOGGER.debug((Object)"ClientClusterViewProvider has been rebound for the protocol {0} with the name {1}", new Object[]{protocol, bindName});
    }

    private void bindDummyRegistry(ServerId serverRef) {
        String bindName = CMIConfig.getBindNameForDummyRegistry();
        CMIReference cmiReference = new CMIReference(serverRef, bindName);
        this.addObjectInstance(this.clusteredObjectInfoForDummyRegistry, cmiReference);
    }

    @Override
    public final synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException {
        if (!this.isWatched(objectName)) {
            LOGGER.debug((Object)"Adding {0} to the set of watched object", new Object[]{objectName});
            this.watch(objectName);
            this.updatePolicy(objectName);
        }
    }

    @Override
    public final synchronized void addObjectInstance(ClusteredObjectInfo clusteredObjectInfo, CMIReference cmiReference) {
        Class<?> itfClass = clusteredObjectInfo.getItfClass();
        String businessName = null;
        String itfName = null;
        if (itfClass != null) {
            Class<? extends EJBObject> businessClass = clusteredObjectInfo.getBusinessClass();
            itfName = itfClass.getName();
            this.interfaces.putIfAbsent(itfName, itfClass);
            if (businessClass != null) {
                businessName = businessClass.getName();
                this.interfaces.putIfAbsent(businessName, businessClass);
            }
        }
        Class<IPolicy<?>> policyClass = clusteredObjectInfo.getPolicyType();
        Class<IStrategy<?>> strategyClass = clusteredObjectInfo.getStrategyType();
        String clusterName = clusteredObjectInfo.getClusterName();
        IPoolConfiguration poolConfiguration = clusteredObjectInfo.getPoolConfiguration();
        String policyType = policyClass.getName();
        String strategyType = strategyClass.getName();
        Map<String, Object> properties = clusteredObjectInfo.getProperties();
        boolean hasState = clusteredObjectInfo.hasState();
        boolean replicated = clusteredObjectInfo.isReplicated();
        Set<String> applicationExceptionNames = clusteredObjectInfo.getApplicationExceptionNames();
        new PolicyFactory(this).getPolicy(policyClass, strategyClass, properties);
        PolicyData policyData = new PolicyData(policyType, strategyType, properties);
        String objectName = cmiReference.getObjectName();
        DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(clusterName, objectName, itfName, businessName, policyData, hasState, replicated, applicationExceptionNames, poolConfiguration);
        this.addDefaultPolicyStrategy(objectName, policyType, strategyType);
        this.addDistributedObjectInfo(objectName, distributedObjectInfo);
        LOGGER.debug((Object)"Adding {0}...", new Object[]{cmiReference});
        this.addCMIReference(cmiReference);
    }

    private void addDefaultPolicyStrategy(String objectName, String policyType, String strategyType) {
        this.policyStrategyManager.addDefaultPolicyClassName(objectName, policyType);
        this.policyStrategyManager.addDefaultStrategyClassName(objectName, strategyType);
    }

    protected abstract boolean containObject(String var1);

    protected abstract DistributedObjectInfo getDistributedObjectInfo(String var1) throws ObjectNotFoundException;

    protected abstract void addDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    protected abstract void setDistributedObjectInfo(String var1, DistributedObjectInfo var2);

    @Override
    public final String getItfName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getItfName();
    }

    @Override
    public final Class<?> getInterface(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getItfName(objectName));
    }

    @Override
    public final String getBusinessName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getBusinessName();
    }

    @Override
    public final Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException {
        return this.interfaces.get(this.getBusinessName(objectName));
    }

    @Override
    public final List<String> getProviderURLs(String protocolName) throws ServerClusterViewManagerException {
        String providerName = CMIConfig.getBindNameForProvider();
        ArrayList<String> providerURLs = new ArrayList<String>();
        try {
            for (CMIReference cmiReference : this.getCMIReferences(providerName, protocolName)) {
                providerURLs.add(cmiReference.getServerRef().getProviderURL());
            }
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot get CMIReferences for the provider whith name {0}", new Object[]{providerName, e});
            throw new ServerClusterViewManagerException("Cannot get CMIReferences for the provider whith name " + providerName, e);
        }
        return providerURLs;
    }

    @Override
    public final Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        return this.policyStrategyManager.getPolicyClass(objectName);
    }

    @Override
    public final Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ServerClusterViewManagerException {
        return this.policyStrategyManager.getStrategyClass(objectName);
    }

    @Override
    public final long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getDateOfProperties();
    }

    @Override
    public final Map<String, Object> getPropertiesForPolicy(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties();
    }

    @Override
    public final Object getPropertyForPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getProperties().get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertiesForPolicy(String objectName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            for (String propertyName : properties.keySet()) {
                distributedObjectInfo.getPolicyData().setProperty(propertyName, properties.get(propertyName));
            }
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPropertyForPolicy(String objectName, String propertyName, Object valueName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setProperty(propertyName, valueName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getInitialContextFactoryName(String protocolName) {
        return this.initialContextFactories.get(protocolName);
    }

    @Override
    public final boolean isClustered(String objectName) {
        return this.containObject(objectName);
    }

    @Override
    public final String getClusterName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getClusterName();
    }

    @Override
    public final String getPolicyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getPolicyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPolicyClassName(String objectName, String policyType) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setPolicyType(policyType);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final String getStrategyClassName(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPolicyData().getStrategyType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStrategyClassName(String objectName, String strategyClassName) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.getPolicyData().setStrategyType(strategyClassName);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAlgorithmForPolicy(String objectName, String policyClassName, String strategyClassName, Map<String, Object> properties) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            PolicyData policyData = distributedObjectInfo.getPolicyData();
            policyData.setPolicyType(policyClassName);
            policyData.setStrategyType(strategyClassName);
            policyData.setProperties(properties);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final IPoolConfiguration getPoolConfiguration(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getPoolConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPoolConfiguration(String objectName, IPoolConfiguration poolConfiguration) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.setPoolConfiguration(poolConfiguration);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    @Override
    public final InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public final Set<String> getProtocols() {
        return new HashSet<String>(this.refsOnLocalRegistries.keySet());
    }

    @Override
    public final JMXServiceURL getJMXServiceURL(String protocolName) {
        return CMIAdminConnectorManager.getJMXServiceURL(protocolName);
    }

    @Override
    public final ServerId getRefOnLocalRegistry(String protocolName) {
        return this.refsOnLocalRegistries.get(protocolName);
    }

    protected abstract void initStats();

    @Override
    public final boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return this.isReplicationManagerStarted() && this.getDistributedObjectInfo(objectName).isReplicated();
    }

    @Override
    public final Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).getApplicationExceptionNames();
    }

    @Override
    public final boolean hasState(String objectName) throws ObjectNotFoundException {
        return this.getDistributedObjectInfo(objectName).hasState();
    }

    @Override
    public final boolean isReplicationManagerStarted() {
        return this.replicationManagerStarted;
    }

    @Override
    public final void setReplicationManagerStarted(boolean replicationManagerStarted) {
        this.replicationManagerStarted = replicationManagerStarted;
    }

    @Override
    public final Map<String, Set<String>> getAvailablePoliciesAndStrategies() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        ret.put("policies", new HashSet<String>(this.policyStrategyManager.getPolicyClassNames()));
        ret.put("strategies", new HashSet<String>(this.policyStrategyManager.getStrategyClassNames()));
        return ret;
    }

    public final boolean isEmbeddedPolicy(String className) {
        return this.policyStrategyManager.isEmbeddedPolicy(className);
    }

    public final boolean isEmbeddedStrategy(String className) {
        return this.policyStrategyManager.isEmbeddedStrategy(className);
    }

    @Override
    public Object addLoadBalancingArchive(byte[] bytesOfFile, String location, Class<?>[] policies, Class<?>[] strategies) {
        LOGGER.debug((Object)"Sending new load balancing archive located at '{0}'. Step 3: server-side manager is delegating reception to policy/stretegy manager ", new Object[]{location});
        return this.policyStrategyManager.addLoadBalancingArchive(bytesOfFile, location, policies, strategies);
    }

    @Override
    public void removeLoadBalancingArchive(Object archiveId, String[] policies, String[] strategies, boolean isArchiveOwner) throws Exception {
        this.policyStrategyManager.removeLoadBalancingArchive(archiveId, policies, strategies, isArchiveOwner);
    }

    public abstract void broadCastArchive(Object var1, byte[] var2);

    public abstract boolean isAlreadyDistributed(Object var1);

    public abstract void removeDistributedArchive(Object var1);

    public IPolicyStrategyManager getPolicyStrategyManager() {
        return this.policyStrategyManager;
    }

    public void setPolicyStrategyManager(IPolicyStrategyManager policyStrategyManager) {
        this.policyStrategyManager = policyStrategyManager;
    }

    public IPolicyStrategyLoader getPolicyStrategyLoader() {
        return this.policyStrategyLoader;
    }

    public void setPolicyStrategyLoader(IPolicyStrategyLoader policyStrategyLoader) {
        this.policyStrategyLoader = policyStrategyLoader;
    }

    @Override
    public final Set<ServerId> getServerRefs(String protocolName) {
        HashSet<ServerId> serverRefs = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName)) {
                    serverRefs.add((ServerId)cmiRef.getServerRef());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverRefs;
    }

    @Override
    public final Set<ServerId> getRefsOnRegistries(String serverName) {
        HashSet<ServerId> serverRefs = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!serverId.getServerName().equals(serverName)) continue;
                    serverRefs.add(serverId);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverRefs;
    }

    @Override
    public final Set<String> getServerObjectForProtocol(String serverUrl, String protocolName) {
        HashSet<String> objectRefs = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName, protocolName)) {
                    if (!cmiRef.getServerRef().getProviderURL().equals(serverUrl)) continue;
                    objectRefs.add(objectName);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return objectRefs;
    }

    @Override
    public final List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        return this.getCMIReferences(objectName, protocolName, null);
    }

    @Override
    public final Set<String> getDomainNames() {
        HashSet<String> domainNames = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    domainNames.add(((ServerId)cmiRef.getServerRef()).getDomainName());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return domainNames;
    }

    @Override
    public final Set<String> getServerNames(String domainName) {
        HashSet<String> serverNames = new HashSet<String>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!serverId.getDomainName().equals(domainName)) continue;
                    serverNames.add(serverId.getServerName());
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverNames;
    }

    @Override
    public final Set<ServerId> getBlacklistedServers() {
        HashSet<ServerId> serverIds = new HashSet<ServerId>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerId serverId = (ServerId)cmiRef.getServerRef();
                    if (!this.isServerBlackListed(serverId)) continue;
                    serverIds.add(serverId);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return serverIds;
    }

    @Override
    public final Set<CMIReference> getCMIRefsForServerRef(ServerRef serverRef) {
        HashSet<CMIReference> cmiRefs = new HashSet<CMIReference>();
        for (String objectName : this.getObjectNames()) {
            try {
                for (CMIReference cmiRef : this.getCMIReferences(objectName)) {
                    ServerRef serverId = cmiRef.getServerRef();
                    if (!serverId.equals(serverRef)) continue;
                    cmiRefs.add(cmiRef);
                }
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return cmiRefs;
    }

    @Override
    public List<IFilter> getFilters(String objectName) throws ObjectNotFoundException {
        return new ArrayList<IFilter>(this.getDistributedObjectInfo(objectName).getFilters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(String objectName, IFilter filter) throws ObjectNotFoundException {
        DistributedObjectInfo distributedObjectInfo;
        if (!(filter instanceof Serializable)) {
            throw new IllegalArgumentException("The provided filter is not serializable.");
        }
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            distributedObjectInfo.addFilter(filter);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFilter(String objectName, IFilter filter) throws ObjectNotFoundException {
        boolean deleted;
        DistributedObjectInfo distributedObjectInfo;
        DistributedObjectInfo distributedObjectInfo2 = distributedObjectInfo = this.getDistributedObjectInfo(objectName);
        synchronized (distributedObjectInfo2) {
            deleted = distributedObjectInfo.removeFilter(filter);
            this.setDistributedObjectInfo(objectName, distributedObjectInfo);
        }
        return deleted;
    }

    protected List<CMIReference> applyFilters(List<CMIReference> cmiReferences, Set<Object> qualities) {
        if (cmiReferences.isEmpty()) {
            return cmiReferences;
        }
        List<CMIReference> availables = new ArrayList<CMIReference>(cmiReferences);
        for (IFilter localFilter : this.localFilters) {
            if (!localFilter.accept(qualities)) continue;
            availables = localFilter.choose(availables);
        }
        for (IFilter globalFilter : this.getGlobalFilters()) {
            if (!globalFilter.accept(qualities)) continue;
            availables = globalFilter.choose(availables);
        }
        String objectName = cmiReferences.get(0).getObjectName();
        try {
            for (IFilter objectFilter : this.getFilters(objectName)) {
                if (!objectFilter.accept(qualities)) continue;
                availables = objectFilter.choose(availables);
            }
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot get filters for the object {0}", new Object[]{objectName, e});
            throw new ServerClusterViewManagerException("Cannot get filters for the object " + objectName, e);
        }
        return availables;
    }

    public Components getComponents() {
        return this.components;
    }

    public void setComponents(Components components) {
        this.components = components;
    }

    public IComponent getComponent(String componentName) {
        if (this.componentManager != null) {
            return this.componentManager.getComponentRegistry().getComponent(componentName);
        }
        return null;
    }

    public IComponentManager getComponentManager() {
        return this.componentManager;
    }
}

