/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.policy;

import java.lang.reflect.Method;
import java.util.List;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.decision.BasicDecisionManager;
import org.ow2.cmi.lb.decision.DecisionManager;
import org.ow2.cmi.lb.decision.DecisionUtil;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicy<T extends LoadBalanceable>
implements IPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(AbstractPolicy.class);
    private ClusterViewManager clusterViewManager;
    private IStrategy<T> strategy = null;

    public AbstractPolicy() {
        this.clusterViewManager = null;
    }

    public AbstractPolicy(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public abstract T choose(List<T> var1) throws NoLoadBalanceableException;

    public BasicDecisionManager<Void> onInvokeException(Method method, Object[] parameters, T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnInvoke(thr, this.clusterViewManager, loadBalanceable)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow(thr);
    }

    @Override
    public <ReturnType> DecisionManager<ReturnType> onChoose(Method method, Object[] parameters, ReturnType chosenValue) {
        return BasicDecisionManager.doReturn(chosenValue);
    }

    @Override
    public <ReturnType> BasicDecisionManager<ReturnType> onReturn(Method method, Object[] parameters, T loadBalanceable, ReturnType retVal) {
        LOGGER.debug((Object)"onReturn: do nothing !", new Object[0]);
        return BasicDecisionManager.doReturn(retVal);
    }

    public BasicDecisionManager<Void> onLookupException(T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnLookup(thr, this.clusterViewManager, loadBalanceable)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow(thr.getCause());
    }

    @Override
    public synchronized void setStrategy(IStrategy<T> strategy) {
        this.strategy = strategy;
    }

    @Override
    public IStrategy<T> getStrategy() {
        return this.strategy;
    }

    public void setClusterViewManager(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }
}

