/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.policy;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.policy.AbstractPolicy;
import org.ow2.cmi.lb.policy.FirstAvailable;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class HASingleton<T extends LoadBalanceable>
extends AbstractPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(HASingleton.class);
    private volatile List<String> serverRefs = new ArrayList<String>();
    private volatile IPolicy<T> policy;

    public HASingleton() {
        try {
            this.policy = new FirstAvailable();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot instanciate FirstAvailable.class", new Object[]{e});
        }
    }

    @Override
    public synchronized T choose(List<T> cmiReferences) throws NoLoadBalanceableException {
        if (cmiReferences == null || cmiReferences.isEmpty()) {
            LOGGER.error((Object)("The given list is null or empty: " + cmiReferences), new Object[0]);
            throw new NoLoadBalanceableException("The given list is null or empty: " + cmiReferences);
        }
        for (String serverRef : this.serverRefs) {
            for (LoadBalanceable cmiReference : cmiReferences) {
                if (!serverRef.equals(cmiReference.getServerRef().getProviderURL())) continue;
                LOGGER.debug((Object)"Found a singleton: {0}", new Object[]{serverRef});
                return (T)cmiReference;
            }
        }
        return this.policy.choose(cmiReferences);
    }

    @Override
    public void setStrategy(IStrategy<T> strategy) {
        super.setStrategy(strategy);
        this.policy.setStrategy(strategy);
    }

    public List<String> getSingletons() {
        return this.serverRefs;
    }

    public synchronized void setSingletons(List<String> serverRefs) {
        this.serverRefs = serverRefs;
    }

    public synchronized void setSingleton(String serverRef) {
        this.serverRefs.add(0, serverRef);
    }

    public synchronized String getSingleton() {
        return this.serverRefs.get(0);
    }

    public String toString() {
        return "HASingleton[ServerRefs: " + this.serverRefs + " - master: " + this.serverRefs.get(0) + " - Rescue policy: " + this.policy + " - Rescue strategy: " + this.getStrategy() + "]";
    }
}

