/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.util.HashMap;
import java.util.Map;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveFactory;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.archive.impl.DefaultArchiveFactory;
import org.ow2.util.archive.impl.URLArchiveFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveManager
implements IArchiveManager {
    private static Log logger = LogFactory.getLog(ArchiveManager.class);
    private static ArchiveManager archiveManager;
    private Map<Class<?>, IArchiveFactory<?>> factories = new HashMap();

    private ArchiveManager() {
        this.addFactory(new DefaultArchiveFactory());
        this.addFactory(new URLArchiveFactory());
    }

    public static ArchiveManager getInstance() {
        if (archiveManager == null) {
            archiveManager = new ArchiveManager();
        }
        return archiveManager;
    }

    public void addFactory(IArchiveFactory<?> factory) {
        Class<?> factoryClass = factory.getClass();
        Class argumentClass = factory.getSupportedClass();
        logger.debug((Object)("Adding factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'."), new Object[0]);
        this.factories.put(argumentClass, factory);
    }

    public void removeFactory(IArchiveFactory<?> factory) {
        Class<?> factoryClass = factory.getClass();
        Class argumentClass = factory.getSupportedClass();
        if (this.factories.containsKey(argumentClass)) {
            logger.debug((Object)("Removing factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'."), new Object[0]);
            this.factories.remove(argumentClass);
        } else {
            logger.debug((Object)("Factory '" + factoryClass.getName() + "' was not registered in the ArchiveManager."), new Object[0]);
        }
    }

    public IArchive getArchive(Object o) {
        Class<?> objectClass = o.getClass();
        IArchiveFactory<?> factory = this.factories.get(objectClass);
        if (factory == null) {
            for (Class<?> cls : this.factories.keySet()) {
                if (!cls.isAssignableFrom(objectClass) || factory != null) continue;
                factory = this.factories.get(cls);
            }
            if (factory == null) {
                throw new IllegalArgumentException("No factory found for the type '" + objectClass + "'.");
            }
        }
        return factory.create(o);
    }
}

