/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.pool.lib;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.resource.internal.pool.Pool;
import org.ow2.jonas.resource.internal.pool.PoolItemStats;
import org.ow2.jonas.resource.internal.pool.PoolMatchFactory;
import org.ow2.jonas.resource.internal.pool.lib.HArrayPoolMonitor;

public class HArrayPool
implements Pool {
    private Logger logger = null;
    private Logger conLogger = null;
    private long timeout = 0L;
    private PoolMatchFactory matchFactory = null;
    private HashSet freeList = null;
    private HashSet activeList = null;
    private Hashtable infoList = null;
    private static final int NO_POOLING = -2;
    private static final int NO_LIMIT = -1;
    private static final long ONE_DAY = 86400000L;
    private static final int MAX_REMOVE_FREELIST = 10;
    private int busyMin = 0;
    private int busyMax = 0;
    private int initSize = -1;
    private int jdbcConnLevel = 0;
    private String jdbcTestStatement = "";
    private int maxAge = 0;
    private int maxOpentime = 0;
    private int maxSize = -1;
    private int maxWaiters = 1000;
    private long maxWaitTimeout = 10000L;
    private int minSize = 0;
    private boolean minLimit = false;
    private HArrayPoolMonitor poolMonitor = null;
    private int samplingPeriod = 60;
    private int waiterCount = 0;
    private long waitingTime = 0L;
    private int busyMaxRecent = 0;
    private int busyMinRecent = 0;
    private int currentWaiters = 0;
    private int openedCount = 0;
    private int connectionFailures = 0;
    private int connectionLeaks = 0;
    private int servedOpen = 0;
    private int rejectedFull = 0;
    private int rejectedTimeout = 0;
    private int rejectedOther = 0;
    private int waitersHigh = 0;
    private int waitersHighRecent = 0;
    private int totalWaiterCount = 0;
    private long totalWaitingTime = 0L;
    private long waitingHigh = 0L;
    private long waitingHighRecent = 0L;

    public HArrayPool(Logger logger) {
        this.logger = logger;
        if (this.conLogger == null) {
            this.conLogger = Log.getLogger((String)"org.ow2.jonas.jca.connection");
        }
        this.freeList = new HashSet();
        this.activeList = new HashSet();
        this.infoList = new Hashtable();
    }

    public int getCurrentBusy() {
        return this.activeList.size();
    }

    public int getCurrentOpened() {
        return this.getSize();
    }

    public int getInitSize() {
        return this.initSize;
    }

    public synchronized void setInitSize(int initsize) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory is mandatory!");
        }
        if (this.initSize < 0 && initsize >= 0) {
            this.initSize = initsize;
            this.setInitSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitSize() throws Exception {
        int initsize;
        if (this.initSize <= 0 || this.maxSize == -2) {
            return;
        }
        if (this.maxSize < 0) {
            initsize = this.initSize;
        } else {
            int n = initsize = this.initSize < this.maxSize ? this.initSize : this.maxSize;
        }
        if (initsize >= this.minSize) {
            this.minLimit = true;
        }
        HArrayPool hArrayPool = this;
        synchronized (hArrayPool) {
            for (int i = 0; i < initsize; ++i) {
                ManagedConnection res = this.createResource(null);
                this.freeList.add(res);
                this.infoList.put(res, new PoolItemStats());
                this.setItemStats(res);
            }
        }
    }

    public int getJdbcConnLevel() {
        return this.jdbcConnLevel;
    }

    public void setJdbcConnLevel(int jdbcConnLevel) {
        this.jdbcConnLevel = jdbcConnLevel;
    }

    public String getJdbcTestStatement() {
        return this.jdbcTestStatement;
    }

    public void setJdbcTestStatement(String jdbcTestStatement) {
        this.jdbcTestStatement = jdbcTestStatement;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxOpentime() {
        return this.maxOpentime;
    }

    public void setMaxOpentime(int mx) {
        this.maxOpentime = mx;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(int maxsize) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory mandatory!!");
        }
        if (maxsize < this.minSize && maxsize > 0 || maxsize == this.maxSize) {
            return;
        }
        if (maxsize < 0) {
            if (this.currentWaiters > 0) {
                this.notify();
            }
            this.maxSize = maxsize;
        } else {
            if (this.currentWaiters > 0 && this.maxSize < maxsize) {
                this.notify();
            }
            this.maxSize = maxsize;
            this.adjust();
        }
    }

    public int getMaxWaiters() {
        return this.maxWaiters;
    }

    public void setMaxWaiters(int nb) {
        this.maxWaiters = nb;
    }

    public int getMaxWaitTime() {
        return (int)(this.maxWaitTimeout / 1000L);
    }

    public void setMaxWaitTime(int sec) {
        this.maxWaitTimeout = (long)sec * 1000L;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public synchronized void setMinSize(int minsize) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("A matchFactory is mandatory!");
        }
        if (minsize < 0 || minsize > this.maxSize || minsize == this.minSize) {
            return;
        }
        if (minsize < this.minSize) {
            this.minSize = minsize;
            return;
        }
        this.minSize = minsize;
        this.adjust();
    }

    public int getSamplingPeriod() {
        return this.samplingPeriod;
    }

    public void setSamplingPeriod(int sec) {
        if (sec > 0) {
            this.samplingPeriod = sec;
            this.poolMonitor.setSamplingPeriod(sec);
        }
    }

    public synchronized int getSize() {
        return this.activeList.size() + this.freeList.size();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long crto) {
    }

    public int getBusyMaxRecent() {
        return this.busyMaxRecent;
    }

    public int getBusyMinRecent() {
        return this.busyMinRecent;
    }

    public int getCurrentWaiters() {
        return this.currentWaiters;
    }

    public int getOpenedCount() {
        return this.openedCount;
    }

    public int getConnectionFailures() {
        return this.connectionFailures;
    }

    public int getConnectionLeaks() {
        return this.connectionLeaks;
    }

    public int getServedOpen() {
        return this.servedOpen;
    }

    public int getRejectedFull() {
        return this.rejectedFull;
    }

    public int getRejectedTimeout() {
        return this.rejectedTimeout;
    }

    public int getRejectedOther() {
        return this.rejectedOther;
    }

    public int getRejectedOpen() {
        return this.rejectedFull + this.rejectedTimeout + this.rejectedOther;
    }

    public int getWaitersHigh() {
        return this.waitersHigh;
    }

    public int getWaitersHighRecent() {
        return this.waitersHighRecent;
    }

    public int getWaiterCount() {
        return this.totalWaiterCount;
    }

    public long getWaitingTime() {
        return this.totalWaitingTime;
    }

    public long getWaitingHigh() {
        return this.waitingHigh;
    }

    public long getWaitingHighRecent() {
        return this.waitingHighRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getResource(Object hints) throws Exception {
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory mandatory!!");
        }
        ManagedConnection res = null;
        long timetowait = this.maxWaitTimeout;
        long starttime = 0L;
        while (res == null) {
            block25: {
                if (!this.freeList.isEmpty()) {
                    try {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)"Free entries available");
                        }
                        if ((res = (ManagedConnection)this.matchFactory.matchResource(this.freeList, hints)) != null) {
                            this.freeList.remove(res);
                            this.activeList.add(res);
                            if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                                this.conLogger.log(BasicLevel.DEBUG, (Object)("Returned Resource: " + res));
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!this.logger.isLoggable(BasicLevel.DEBUG)) break block25;
                        this.logger.log(BasicLevel.DEBUG, (Object)"Error from matchResource", (Throwable)ex);
                    }
                }
            }
            if (res != null) continue;
            int curSize = this.activeList.size() + this.freeList.size();
            if (this.maxSize < 0 || curSize < this.maxSize) {
                res = this.createResource(hints);
                this.activeList.add(res);
                continue;
            }
            if (this.freeList.size() > 0) {
                res = (ManagedConnection)this.freeList.iterator().next();
                this.matchFactory.releaseResource(res);
                res.destroy();
                this.freeList.remove(res);
                this.infoList.remove(res);
                res = this.createResource(hints);
                this.activeList.add(res);
                continue;
            }
            boolean stoplooping = true;
            if (timetowait > 0L && this.currentWaiters < this.maxWaiters) {
                ++this.currentWaiters;
                if (this.waiterCount < this.currentWaiters) {
                    this.waiterCount = this.currentWaiters;
                }
                if (starttime == 0L) {
                    starttime = System.currentTimeMillis();
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"Wait for a free Connection");
                    }
                }
                try {
                    this.wait(timetowait);
                }
                catch (InterruptedException ign) {
                    this.logger.log(BasicLevel.WARN, (Object)"Interrupted");
                }
                finally {
                    --this.currentWaiters;
                }
                long stoptime = System.currentTimeMillis();
                long stillwaited = stoptime - starttime;
                timetowait = this.maxWaitTimeout - stillwaited;
                boolean bl = stoplooping = timetowait <= 0L;
                if (stoplooping) {
                    ++this.totalWaiterCount;
                    this.totalWaitingTime += stillwaited;
                    if (this.waitingTime < stillwaited) {
                        this.waitingTime = stillwaited;
                    }
                } else {
                    if (this.freeList.isEmpty()) continue;
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Notified after " + stillwaited));
                    }
                    ++this.totalWaiterCount;
                    this.totalWaitingTime += stillwaited;
                    if (this.waitingTime >= stillwaited) continue;
                    this.waitingTime = stillwaited;
                    continue;
                }
            }
            if (!stoplooping || !this.freeList.isEmpty()) continue;
            if (starttime > 0L) {
                ++this.rejectedTimeout;
                this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection - timeout");
            } else {
                ++this.rejectedFull;
                this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection");
            }
            throw new Exception("No more connections");
        }
        this.infoList.put(res, new PoolItemStats());
        this.printLists();
        this.setItemStats(res);
        this.recomputeBusy();
        return res;
    }

    private ManagedConnection createResource(Object hints) throws Exception {
        ManagedConnection res = null;
        try {
            res = (ManagedConnection)this.matchFactory.createResource(hints);
            if (res == null) {
                Exception exc = new Exception("A null ManagedConnection was returned.");
                throw exc;
            }
            ++this.openedCount;
        }
        catch (Exception ex) {
            ++this.connectionFailures;
            ++this.rejectedOther;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Cannot create new Connection", (Throwable)ex);
            }
            throw ex;
        }
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)("Created Resource: " + res));
        }
        if (!this.minLimit && this.getSize() >= this.minSize) {
            this.minLimit = true;
        }
        return res;
    }

    public synchronized void releaseResource(Object resource, boolean destroy, boolean adjustment) throws Exception {
        ManagedConnection res = (ManagedConnection)resource;
        if (this.matchFactory == null) {
            throw new Exception("The matchFactory mandatory!!");
        }
        if (this.activeList == null) {
            throw new Exception("No active resources to releases!!");
        }
        if (!this.activeList.contains(res)) {
            return;
        }
        this.activeList.remove(res);
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)("Freed Resource: " + res));
        }
        if (this.maxSize == -2 || destroy) {
            this.infoList.remove(res);
            res.destroy();
            if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                this.conLogger.log(BasicLevel.DEBUG, (Object)("Destroyed Resource: " + res));
            }
        } else {
            this.freeList.add(res);
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
            if (pis != null) {
                pis.setTotalConnectionTime(System.currentTimeMillis() - pis.getStartTime());
            }
        }
        if (this.currentWaiters > 0) {
            this.notify();
        }
        if (adjustment) {
            this.adjust();
        }
    }

    public synchronized void closeAllConnections() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.poolMonitor.stopit();
        for (ManagedConnection res : this.freeList) {
            try {
                res.destroy();
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error while closing a Connection:", (Throwable)e);
            }
        }
        for (ManagedConnection res : this.activeList) {
            try {
                res.destroy();
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error while closing a Connection:", (Throwable)e);
            }
        }
    }

    public PoolMatchFactory getMatchFactory() {
        return this.matchFactory;
    }

    public synchronized void setMatchFactory(PoolMatchFactory pmf) {
        this.matchFactory = pmf;
    }

    public void startMonitor() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.poolMonitor = new HArrayPoolMonitor(this);
        this.poolMonitor.start();
    }

    public synchronized void validateMCs() throws Exception {
        this.matchFactory.validateResource(this.freeList);
    }

    public synchronized void adjust() throws Exception {
        long curTime = System.currentTimeMillis();
        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
            this.conLogger.log(BasicLevel.DEBUG, (Object)(" activeList.size()  = " + this.activeList.size() + " minSize= " + this.minSize));
        }
        this.printLists();
        int count = 0;
        Vector<ManagedConnection> rList = new Vector<ManagedConnection>();
        for (ManagedConnection res : this.freeList) {
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
            if (this.maxAge <= 0 || pis == null || pis.getMaxAgeTimeout() <= 0L || curTime <= pis.getMaxAgeTimeout()) continue;
            if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                this.conLogger.log(BasicLevel.DEBUG, (Object)("remove a timed out connection " + res));
            }
            rList.add(res);
            if (++count < 10) continue;
            break;
        }
        for (ManagedConnection res : rList) {
            try {
                this.matchFactory.releaseResource(res);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.freeList.remove(res);
            this.infoList.remove(res);
            try {
                res.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        curTime = System.currentTimeMillis();
        Vector<ManagedConnection> aList = new Vector<ManagedConnection>();
        for (ManagedConnection res : this.activeList) {
            PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
            if (this.maxOpentime <= 0 || pis == null || pis.getMaxOpenTimeout() <= 0L || curTime <= pis.getMaxOpenTimeout()) continue;
            aList.add(res);
        }
        for (ManagedConnection item : aList) {
            this.logger.log(BasicLevel.WARN, (Object)"close a timed out active connection");
            this.logger.log(BasicLevel.WARN, (Object)("MC = " + item));
            this.releaseResource(item, true, false);
            ++this.connectionLeaks;
        }
        int curSize = this.getSize();
        if (this.maxSize > 0 && this.maxSize < curSize || this.maxSize == -2) {
            int nbRemove = curSize;
            if (this.maxSize > 0) {
                nbRemove -= this.maxSize;
            }
            if (this.freeList != null) {
                while (!this.freeList.isEmpty() && nbRemove > 0) {
                    ManagedConnection res = (ManagedConnection)this.freeList.iterator().next();
                    this.matchFactory.releaseResource(res);
                    res.destroy();
                    this.freeList.remove(res);
                    this.infoList.remove(res);
                    --nbRemove;
                    --curSize;
                }
            }
        }
        if (this.maxSize != -2) {
            while (this.minSize > curSize) {
                ManagedConnection res = this.createResource(null);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("recreate connection " + res));
                }
                this.freeList.add(res);
                this.infoList.put(res, new PoolItemStats());
                this.setItemStats(res);
                ++curSize;
            }
        }
        this.recomputeBusy();
    }

    public void recomputeBusy() {
        int busy = this.getCurrentBusy();
        if (this.busyMax < busy) {
            this.busyMax = busy;
        }
        if (this.busyMin > busy) {
            this.busyMin = busy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampling() throws Exception {
        this.waitingHighRecent = this.waitingTime;
        if (this.waitingHigh < this.waitingTime) {
            this.waitingHigh = this.waitingTime;
        }
        this.waitingTime = 0L;
        this.waitersHighRecent = this.waiterCount;
        if (this.waitersHigh < this.waiterCount) {
            this.waitersHigh = this.waiterCount;
        }
        this.waiterCount = 0;
        this.busyMaxRecent = this.busyMax;
        this.busyMax = this.getCurrentBusy();
        this.busyMinRecent = this.busyMin;
        this.busyMin = this.getCurrentBusy();
        if (this.jdbcConnLevel == 3 && this.jdbcTestStatement != null && this.jdbcTestStatement.length() > 0) {
            Vector fList = new Vector(this.freeList);
            ConnectionRequestInfo cxri = null;
            for (int i = 0; i < fList.size(); ++i) {
                ManagedConnection mc = (ManagedConnection)fList.elementAt(i);
                Connection connection = (Connection)mc.getConnection(null, cxri);
                Statement stmt = null;
                if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                    this.conLogger.log(BasicLevel.DEBUG, (Object)("Sending " + this.jdbcTestStatement + " on MC " + mc));
                }
                try {
                    stmt = connection.createStatement();
                    stmt.execute(this.jdbcTestStatement);
                    stmt.close();
                    continue;
                }
                catch (SQLException se) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    HArrayPool hArrayPool = this;
                    synchronized (hArrayPool) {
                        if (this.conLogger.isLoggable(BasicLevel.DEBUG)) {
                            this.conLogger.log(BasicLevel.DEBUG, (Object)("Freeing MC " + mc));
                        }
                        try {
                            this.matchFactory.releaseResource(mc);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            this.freeList.remove(mc);
                            this.infoList.remove(mc);
                            mc.destroy();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
        }
    }

    private void setItemStats(Object res) {
        PoolItemStats pis = (PoolItemStats)this.infoList.get(res);
        if (pis != null) {
            pis.incrementUses();
            long sTime = System.currentTimeMillis();
            pis.setStartTime(sTime);
            if (this.maxAge > 0 && pis.getMaxAgeTimeout() == 0L) {
                pis.setMaxAgeTimeout(sTime + (long)this.maxAge * 60L * 1000L);
            }
            if (this.maxOpentime > 0) {
                pis.setMaxOpenTimeout(sTime + (long)this.maxOpentime * 60L * 1000L);
            }
        }
        ++this.servedOpen;
    }

    void printLists() {
        int count = 0;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            PoolItemStats pis;
            ManagedConnection mc;
            Iterator it;
            this.logger.log(BasicLevel.DEBUG, (Object)("minSize=" + this.minSize + ", maxSize=" + this.maxSize + ",  freeSize=" + this.freeList.size()));
            this.logger.log(BasicLevel.DEBUG, (Object)"activeList:");
            if (this.activeList == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)" null");
            } else {
                it = this.activeList.iterator();
                while (it.hasNext() && ++count < 40) {
                    mc = (ManagedConnection)it.next();
                    pis = (PoolItemStats)this.infoList.get(mc);
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + mc));
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + pis.toString()));
                }
            }
            this.logger.log(BasicLevel.DEBUG, (Object)"freeList:");
            if (this.freeList == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)" null");
            } else {
                count = 0;
                it = this.freeList.iterator();
                while (it.hasNext() && ++count < 40) {
                    mc = (ManagedConnection)it.next();
                    pis = (PoolItemStats)this.infoList.get(mc);
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + mc));
                    this.logger.log(BasicLevel.DEBUG, (Object)(" " + pis.toString()));
                }
            }
        }
    }
}

