/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server.impl.jgroups;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;
import org.ow2.cmi.controller.server.impl.jgroups.IIntercepted;
import org.ow2.util.cluster.jgroups.IDistributedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizedDistributedTree
implements MessageListener,
MembershipListener,
IDistributedTree,
IIntercepted {
    private volatile Node root = null;
    private final Vector<IDistributedTree.DistributedTreeListener> listeners = new Vector();
    private final Vector<IDistributedTree.ViewListener> view_listeners = new Vector();
    private final Vector<Address> members = new Vector();
    private volatile Channel channel = null;
    private volatile RpcDispatcher disp = null;
    private volatile boolean rc = false;
    private volatile String groupname = "SynchronizedDistributedTreeGroup";
    private volatile String channel_properties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=0;tos=8;ucast_recv_buf_size=20000000;ucast_send_buf_size=640000;mcast_recv_buf_size=25000000;mcast_send_buf_size=640000loopback=false;discard_incompatible_packets=true;max_bundle_size=64000;max_bundle_timeout=30;use_incoming_packet_handler=trueip_ttl=0;enable_bundling=true;enable_diagnostics=true;thread_naming_pattern=cl;use_concurrent_stack=true;thread_pool.enabled=truethread_pool.min_threads=1;thread_pool.max_threads=25;thread_pool.keep_alive_time=5000;thread_pool.queue_enabled=falsethread_pool.queue_max_size=100;thread_pool.rejection_policy=Run;oob_thread_pool.enabled=true;oob_thread_pool.min_threads=1oob_thread_pool.max_threads=8;oob_thread_pool.keep_alive_time=5000;oob_thread_pool.queue_enabled=false;oob_thread_pool.queue_max_size=100oob_thread_pool.rejection_policy=Run):PING(timeout=5000;num_initial_members=3):MERGE2(max_interval=30000;min_interval=10000):FD_SOCK:FD (timeout=2000 max_tries=3 shun=true):BARRIER:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(use_mcast_xmit=false;gc_lag=0;retransmit_timeout=300,600,1200,2400,4800;discard_delivered_msgs=true):UNICAST(timeout=300,600,1200,2400,3600):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000):VIEW_SYNC avg_send_interval=60000:FRAG(down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;shun=false;print_local_addr=true):SEQUENCER:FC(max_credits=20000000;min_threshold=0.10):FRAG2 frag_size=60000:pbcast.STATE_TRANSFER()";
    private volatile boolean send_message = false;
    private static final Log log = LogFactory.getLog(SynchronizedDistributedTree.class);
    private final Object lock = new Object();

    public SynchronizedDistributedTree() {
    }

    public SynchronizedDistributedTree(String groupname, String channel_properties) {
        this.groupname = groupname;
        if (channel_properties != null) {
            this.channel_properties = channel_properties;
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.disp != null) {
            this.disp.setDeadlockDetection(flag);
        }
    }

    public void start() throws Exception {
        this.start(8000L);
    }

    public void start(long timeout) throws Exception {
        if (this.channel != null) {
            return;
        }
        this.channel = new JChannel(this.channel_properties);
        this.channel.setOpt(5, (Object)true);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.connect(this.groupname);
        this.rc = this.channel.getState(null, timeout);
        if (this.rc) {
            if (log.isInfoEnabled()) {
                log.info((Object)"state was retrieved successfully");
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"state could not be retrieved (must be first member in group)");
        }
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            this.channel.close();
            this.disp.stop();
        }
        this.channel = null;
        this.disp = null;
    }

    public void addDistributedTreeListener(IDistributedTree.DistributedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeDistributedTreeListener(IDistributedTree.DistributedTreeListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addViewListener(IDistributedTree.ViewListener listener) {
        if (!this.view_listeners.contains(listener)) {
            this.view_listeners.addElement(listener);
        }
    }

    public void removeViewListener(IDistributedTree.ViewListener listener) {
        this.view_listeners.removeElement(listener);
    }

    @Override
    public void add(String fqn) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_add", new Object[]{fqn}, new String[]{String.class.getName()});
                this.disp.callRemoteMethods(null, call, 2, 0L);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + ex));
                }
            }
        } else {
            this._add(fqn);
        }
    }

    @Override
    public void add(String fqn, Serializable element) {
        this.add(fqn, element, 0);
    }

    @Override
    public void reset(String fqn, Serializable element) {
        this.reset(fqn, element, 0);
    }

    @Override
    public void remove(String fqn) {
        this.remove(fqn, 0);
    }

    @Override
    public void add(String fqn, Serializable element, int timeout) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_add", new Object[]{fqn, element}, new String[]{String.class.getName(), Serializable.class.getName()});
                this.disp.callRemoteMethods(null, call, 2, (long)timeout);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + ex));
                }
            }
        } else {
            this._add(fqn, element);
        }
    }

    @Override
    public void reset(String fqn, Serializable element, int timeout) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_reset", new Object[]{fqn, element}, new String[]{String.class.getName(), Serializable.class.getName()});
                this.disp.callRemoteMethods(null, call, 2, (long)timeout);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + ex));
                }
            }
        } else {
            this._reset(fqn, element);
        }
    }

    @Override
    public void remove(String fqn, int timeout) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_remove", new Object[]{fqn}, new String[]{String.class.getName()});
                this.disp.callRemoteMethods(null, call, 2, (long)timeout);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + ex));
                }
            }
        } else {
            this._remove(fqn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fqn) {
        Object object = this.lock;
        synchronized (object) {
            return fqn != null && this.findNode(fqn) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable get(String fqn) {
        Node n = null;
        if (fqn == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            n = this.findNode(fqn);
            if (n != null) {
                return n.element;
            }
        }
        return null;
    }

    @Override
    public void set(String fqn, Serializable element) {
        this.set(fqn, element, 0);
    }

    @Override
    public void set(String fqn, Serializable element, int timeout) {
        if (this.send_message) {
            try {
                MethodCall call = new MethodCall("_set", new Object[]{fqn, element}, new String[]{String.class.getName(), Serializable.class.getName()});
                this.disp.callRemoteMethods(null, call, 2, (long)timeout);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + ex));
                }
            }
        } else {
            this._set(fqn, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<String> getChildrenNames(String fqn) {
        Vector<String> ret = new Vector<String>();
        if (fqn == null) {
            return ret;
        }
        Object object = this.lock;
        synchronized (object) {
            Node n = this.findNode(fqn);
            if (n == null || n.children == null) {
                return ret;
            }
            for (Node child : n.children) {
                ret.addElement(child.name);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print() {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.root == null) {
                return "/";
            }
            sb.append(this.root.print(indent));
        }
        return sb.toString();
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getGroupMembersNumber() {
        return this.members.size();
    }

    public void _add(String fqn) {
        this._add(fqn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(String fqn, Serializable element) {
        String tmp_fqn = "";
        Object object = this.lock;
        synchronized (object) {
            if (this.root == null) {
                this.root = new Node("/", null);
                this.notifyNodeAdded("/", null);
            }
            if (fqn == null) {
                return;
            }
            Node curr = this.root;
            StringTokenizer tok = new StringTokenizer(fqn, "/");
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                tmp_fqn = tmp_fqn + '/' + child_name;
                Node n = curr.findChild(child_name);
                if (n == null) {
                    n = new Node(child_name, null);
                    curr.addChild(n);
                    if (!tok.hasMoreTokens()) {
                        n.element = element;
                        this.notifyNodeAdded(tmp_fqn, element);
                        return;
                    }
                    this.notifyNodeAdded(tmp_fqn, null);
                }
                curr = n;
            }
            if (curr.element == null && element != null) {
                curr.element = element;
                this.notifyNodeModified(fqn, null, element);
            } else if (curr.element != null) {
                log.debug((Object)("Cannot add " + element + " at " + tmp_fqn + " because " + curr.element + " exists"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _remove(String fqn) {
        String child_name = null;
        Object object = this.lock;
        synchronized (object) {
            Node n;
            if (fqn == null || this.root == null) {
                return;
            }
            Node curr = this.root;
            StringTokenizer tok = new StringTokenizer(fqn, "/");
            while (tok.countTokens() > 1) {
                child_name = tok.nextToken();
                n = curr.findChild(child_name);
                if (n == null) {
                    return;
                }
                curr = n;
            }
            try {
                child_name = tok.nextToken();
                if (child_name != null && (n = curr.removeChild(child_name)) != null) {
                    this.notifyNodeRemoved(fqn);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _set(String fqn, Serializable element) {
        Serializable old_el = null;
        Object object = this.lock;
        synchronized (object) {
            if (fqn == null || element == null) {
                return;
            }
            Node n = this.findNode(fqn);
            if (n == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("node " + fqn + " not found"));
                }
                return;
            }
            old_el = n.element;
            n.element = element;
            this.notifyNodeModified(fqn, old_el, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _reset(String fqn, Serializable element) {
        Serializable old_el = null;
        Object object = this.lock;
        synchronized (object) {
            if (fqn == null || element == null) {
                return;
            }
            Node n = this.findNode(fqn);
            if (n == null) {
                this._add(fqn, element);
            } else {
                old_el = n.element;
                n.element = element;
            }
            this.notifyNodeModified(fqn, old_el, element);
        }
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Node copy = this.root != null ? this.root.copy() : null;
        try {
            return Util.objectToByteBuffer((Object)copy);
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception marshalling state: " + ex));
            }
            return null;
        }
    }

    public void setState(byte[] data) {
        Object new_state;
        try {
            new_state = Util.objectFromByteBuffer((byte[])data);
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception unmarshalling state: " + ex));
            }
            return;
        }
        if (new_state == null) {
            return;
        }
        if (!(new_state instanceof Node)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"object is not of type 'Node'");
            }
            return;
        }
        this.root = ((Node)new_state).copy();
        this.notifyAllNodesCreated(this.root, "");
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (Address mbr : new_mbrs) {
                this.members.addElement(mbr);
            }
        }
        this.send_message = true;
        this.send_message = this.members.size() > 1;
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector<Address> new_mbrs, Vector<Address> old_mbrs) {
        if (this.view_listeners.isEmpty() || old_mbrs == null || new_mbrs == null) {
            return;
        }
        Vector<Address> joined = new Vector<Address>();
        for (Address mbr : new_mbrs) {
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector<Address> left = new Vector<Address>();
        for (Address mbr : old_mbrs) {
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        this.notifyViewChange(joined, left);
    }

    private Node findNode(String fqn) {
        Node curr = this.root;
        if (fqn == null || this.root == null) {
            return null;
        }
        if ("/".equals(fqn) || "".equals(fqn)) {
            return this.root;
        }
        StringTokenizer tok = new StringTokenizer(fqn, "/");
        while (tok.hasMoreTokens()) {
            String child_name = tok.nextToken();
            if ((curr = curr.findChild(child_name)) != null) continue;
            return null;
        }
        return curr;
    }

    void notifyNodeAdded(String fqn, Serializable element) {
        for (IDistributedTree.DistributedTreeListener distributedTreeListener : this.listeners) {
            distributedTreeListener.nodeAdded(fqn, element);
        }
    }

    void notifyNodeRemoved(String fqn) {
        for (IDistributedTree.DistributedTreeListener distributedTreeListener : this.listeners) {
            distributedTreeListener.nodeRemoved(fqn);
        }
    }

    void notifyNodeModified(String fqn, Serializable old_element, Serializable new_element) {
        for (IDistributedTree.DistributedTreeListener distributedTreeListener : this.listeners) {
            distributedTreeListener.nodeModified(fqn, old_element, new_element);
        }
    }

    void notifyAllNodesCreated(Node curr, String tmp_fqn) {
        String path = "";
        if (curr == null) {
            return;
        }
        if (curr.name == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"curr.name is null");
            }
            return;
        }
        path = curr.equals(this.root) ? "/" : tmp_fqn;
        this.notifyNodeAdded(path, curr.element);
        if (curr.children != null) {
            for (Node n : curr.children) {
                log.debug((Object)("*** nodeCreated(): tmp_fqn is " + tmp_fqn));
                this.notifyAllNodesCreated(n, tmp_fqn + '/' + n.name);
            }
        }
    }

    void notifyViewChange(Vector<Address> new_mbrs, Vector<Address> old_mbrs) {
        for (IDistributedTree.ViewListener viewListener : this.view_listeners) {
            viewListener.viewChange(new_mbrs, old_mbrs);
        }
    }

    private static class Node
    implements Serializable {
        final String name;
        volatile Vector<Node> children = null;
        volatile Serializable element = null;
        private static final long serialVersionUID = -635336369135391033L;

        Node(String name, Serializable element) {
            this.name = name;
            this.element = element;
        }

        void addChild(String relative_name, Serializable element) {
            if (relative_name == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            } else if (!this.children.contains(relative_name)) {
                this.children.addElement(new Node(relative_name, element));
            }
        }

        void addChild(Node n) {
            if (n == null) {
                return;
            }
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(n)) {
                this.children.addElement(n);
            }
        }

        Node removeChild(String rel_name) {
            Node n = this.findChild(rel_name);
            if (n != null) {
                this.children.removeElement(n);
            }
            return n;
        }

        Node findChild(String relative_name) {
            if (this.children == null || relative_name == null) {
                return null;
            }
            for (Node child : this.children) {
                if (child.name == null) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("child.name is null for " + relative_name));
                    continue;
                }
                if (!child.name.equals(relative_name)) continue;
                return child;
            }
            return null;
        }

        public boolean equals(Object other) {
            return other != null && ((Node)other).name != null && this.name != null && this.name.equals(((Node)other).name);
        }

        Node copy() {
            Node ret = new Node(this.name, this.element);
            if (this.children != null) {
                ret.children = (Vector)this.children.clone();
            }
            return ret;
        }

        String print(int indent) {
            StringBuilder sb = new StringBuilder();
            boolean is_root = this.name != null && "/".equals(this.name);
            for (int i = 0; i < indent; ++i) {
                sb.append(' ');
            }
            if (!is_root) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append('/' + this.name);
                }
            }
            sb.append('\n');
            if (this.children != null) {
                indent = is_root ? 0 : (indent += 4);
                for (Node child : this.children) {
                    sb.append(child.print(indent));
                }
            }
            return sb.toString();
        }

        public String toString() {
            if (this.element != null) {
                return "[name: " + this.name + ", element: " + this.element + ']';
            }
            return "[name: " + this.name + ']';
        }
    }
}

