/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.info;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBObject;
import net.jcip.annotations.Immutable;
import org.ow2.cmi.annotation.ArrayProperty;
import org.ow2.cmi.annotation.Policy;
import org.ow2.cmi.annotation.Properties;
import org.ow2.cmi.annotation.SimpleProperty;
import org.ow2.cmi.annotation.Strategy;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.info.mapping.ArrayPropertyInfo;
import org.ow2.cmi.info.mapping.CMIMapping;
import org.ow2.cmi.info.mapping.Cluster;
import org.ow2.cmi.info.mapping.ClusteredObjects;
import org.ow2.cmi.info.mapping.PropertiesInfo;
import org.ow2.cmi.info.mapping.SimplePropertyInfo;
import org.ow2.cmi.lb.PropertyConfigurationException;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.NoStrategy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.annotation.Pool;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.impl.PoolConfigurationHelper;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class CMIInfoExtractor {
    private static Log logger = LogFactory.getLog(CMIInfoExtractor.class);

    private CMIInfoExtractor() {
    }

    public static ClusteredObjectInfo extractClusteringInfoFromAnnotatedPOJO(String objectName, Class<?> itfClass, Class<?> impl, boolean stateful, boolean replicated, Set<String> applicationExceptionNames) throws CMIInfoExtractorException {
        Policy policy;
        URL url;
        org.ow2.cmi.annotation.Cluster cluster = impl.getAnnotation(org.ow2.cmi.annotation.Cluster.class);
        if (cluster == null) {
            logger.info((Object)"No annotation @Cluster found", new Object[0]);
            return null;
        }
        String descriptor = cluster.descriptor();
        if (descriptor != null && (url = Thread.currentThread().getContextClassLoader().getResource(descriptor)) != null) {
            try {
                return CMIInfoExtractor.extractClusteringInfoFromDD(objectName, itfClass, null, url, stateful, replicated, applicationExceptionNames);
            }
            catch (Exception e) {
                logger.debug((Object)"Cannot extract clustering infos from the descriptor {0}", new Object[]{descriptor, e});
            }
        }
        String clusterName = cluster.name();
        Pool poolAnnotation = cluster.pool();
        IPoolConfiguration poolConfiguration = null;
        if (poolAnnotation != null) {
            poolConfiguration = PoolConfigurationHelper.getConfiguration((Pool)poolAnnotation);
        }
        if ((policy = impl.getAnnotation(Policy.class)) == null) {
            logger.error((Object)"No annotation @Policy found !", new Object[0]);
            throw new CMIInfoExtractorException("No annotation @Policy found !");
        }
        Class<? extends IPolicy> policyType = policy.value();
        Strategy strategy = impl.getAnnotation(Strategy.class);
        Class strategyType = null;
        strategyType = strategy != null ? strategy.value() : NoStrategy.class;
        HashMap<String, Object> policyProperties = null;
        Properties properties = impl.getAnnotation(Properties.class);
        if (properties != null) {
            String propertyName;
            SimpleProperty[] simpleProperties = properties.simpleProperties();
            ArrayProperty[] arrayProperties = properties.arrayProperties();
            policyProperties = new HashMap<String, Object>();
            for (SimpleProperty simpleProperty : simpleProperties) {
                Object propertyValue;
                propertyName = simpleProperty.name();
                String svalue = simpleProperty.value();
                try {
                    propertyValue = PolicyFactory.convertString(policyType, propertyName, svalue);
                }
                catch (PropertyConfigurationException e) {
                    throw new CMIInfoExtractorException("Cannot cast property " + propertyName, e);
                }
                logger.debug((Object)"Adding pair ({0},{1})", new Object[]{propertyName, propertyValue});
                policyProperties.put(propertyName, propertyValue);
            }
            for (Annotation annotation : arrayProperties) {
                List<?> propertyValues;
                propertyName = annotation.name();
                String[] svalues = annotation.values();
                try {
                    propertyValues = PolicyFactory.convertStrings(policyType, propertyName, Arrays.asList(svalues));
                }
                catch (PropertyConfigurationException e) {
                    throw new CMIInfoExtractorException("Cannot cast property " + propertyName, e);
                }
                logger.debug((Object)"Adding pair ({0},{1})", new Object[]{propertyName, propertyValues});
                policyProperties.put(propertyName, propertyValues);
            }
        }
        return new ClusteredObjectInfo(itfClass, null, clusterName, poolConfiguration, policyType, strategyType, policyProperties, stateful, replicated, applicationExceptionNames);
    }

    public static ClusteredObjectInfo extractClusteringInfoFromDD(String objectName, Class<?> itfClass, Class<? extends EJBObject> businessClass, URL url, boolean stateful, boolean replicated, Set<String> applicationExceptionNames) throws CMIInfoExtractorException {
        Class strategyClass;
        Class<?> policyClass;
        XMLConfiguration xmlConfiguration = new XMLConfiguration(url, "cmi-mapping.xml");
        CMIMapping cmiMapping = new CMIMapping();
        try {
            xmlConfiguration.configure((Object)cmiMapping);
        }
        catch (XMLConfigurationException e) {
            logger.error((Object)"Cannot set informations for the clustered object with interface {0}", new Object[]{itfClass.getName(), e});
            throw new CMIInfoExtractorException("Cannot set informations for the clustered object with interface " + itfClass.getName(), e);
        }
        ClusteredObjects clusteredObjects = cmiMapping.getClusteredObjects();
        logger.debug((Object)"Clustered objects found: {0}", new Object[]{clusteredObjects});
        Cluster clusteredObject = null;
        for (Cluster clusteredObj : clusteredObjects.getClusteredObjects()) {
            if (clusteredObj.getObjectName() != null && !clusteredObj.getObjectName().equals(objectName)) continue;
            clusteredObject = clusteredObj;
            break;
        }
        if (clusteredObject == null) {
            logger.error((Object)"No definition of clustered object for {0}", new Object[]{objectName});
            throw new CMIInfoExtractorException("No definition of clustered object for " + objectName);
        }
        String clusterName = clusteredObject.getClusterName();
        if (clusterName == null || clusterName.equals("")) {
            logger.error((Object)"The cluster name is not set", new Object[0]);
            throw new CMIInfoExtractorException("The cluster name is not set");
        }
        String policyClassName = clusteredObject.getPolicyType();
        if (policyClassName == null || policyClassName.equals("")) {
            logger.error((Object)"The LB policy name is not set", new Object[0]);
            throw new CMIInfoExtractorException("The LB policy name is not set");
        }
        try {
            policyClass = Class.forName(policyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Cannot load the class {0} that define a policy", new Object[]{policyClassName, e});
            throw new CMIInfoExtractorException("Cannot load the class " + policyClassName + " that define a policy", e);
        }
        String strategyClassName = clusteredObject.getStrategyType();
        if (strategyClassName == null || strategyClassName.equals("")) {
            strategyClass = NoStrategy.class;
        } else {
            try {
                strategyClass = Class.forName(strategyClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"Cannot load the class {0} that define a strategy", new Object[]{strategyClassName, e});
                throw new CMIInfoExtractorException("Cannot load the class " + strategyClassName + " that define a strategy", e);
            }
        }
        IPoolConfiguration poolConfiguration = clusteredObject.getPoolConfiguration();
        PropertiesInfo propertiesInfo = clusteredObject.getPropertiesInfo();
        Map<String, Object> policyProperties = null;
        if (propertiesInfo != null) {
            try {
                policyProperties = CMIInfoExtractor.extractProperties(policyClass, propertiesInfo);
            }
            catch (PropertyConfigurationException e) {
                logger.error((Object)"Cannot convert properties", new Object[]{e});
                throw new CMIInfoExtractorException("Cannot convert properties", e);
            }
        }
        return new ClusteredObjectInfo(itfClass, businessClass, clusterName, poolConfiguration, policyClass, strategyClass, policyProperties, stateful, replicated, applicationExceptionNames);
    }

    private static Map<String, Object> extractProperties(Class<? extends IPolicy<?>> policyClass, PropertiesInfo propertiesInfo) throws PropertyConfigurationException {
        String propertyName;
        HashMap<String, Object> policyProperties = new HashMap<String, Object>();
        for (SimplePropertyInfo simplePropertyInfo : propertiesInfo.getSimplePropertyInfos()) {
            propertyName = simplePropertyInfo.getName();
            String svalue = simplePropertyInfo.getValue();
            Object propertyValue = PolicyFactory.convertString(policyClass, propertyName, svalue);
            logger.debug((Object)"Adding pair ({0},{1})", new Object[]{propertyName, propertyValue});
            policyProperties.put(propertyName, propertyValue);
        }
        for (ArrayPropertyInfo arrayPropertyInfo : propertiesInfo.getArrayPropertyInfos()) {
            propertyName = arrayPropertyInfo.getName();
            ArrayList<String> svalues = new ArrayList<String>();
            for (String lbValue : arrayPropertyInfo.getValues()) {
                svalues.add(lbValue);
            }
            List<?> propertyValues = PolicyFactory.convertStrings(policyClass, propertyName, svalues);
            logger.debug((Object)"Adding pair ({0},{1})", new Object[]{propertyName, propertyValues});
            policyProperties.put(propertyName, propertyValues);
        }
        return policyProperties;
    }
}

