/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends NavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private Map<String, List<ConfigNavigationCase>> caseListMap;
    private Set<String> wildCardSet;
    private boolean navigationConfigured;

    public NavigationHandlerImpl() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        aFactory.getApplication();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        if (associate != null) {
            this.caseListMap = associate.getNavigationCaseListMappings();
            this.wildCardSet = associate.getNavigationWildCardList();
            this.navigationConfigured = this.wildCardSet != null && this.caseListMap != null;
        }
    }

    NavigationHandlerImpl(ApplicationAssociate associate) {
        if (associate == null) {
            throw new NullPointerException();
        }
        this.caseListMap = associate.getNavigationCaseListMappings();
        this.wildCardSet = associate.getNavigationWildCardList();
        this.navigationConfigured = this.wildCardSet != null && this.caseListMap != null;
    }

    @Override
    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        if (outcome == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No navigation rule found for null outcome and viewId " + context.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        ExternalContext extContext = context.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(context);
            assert (null != viewHandler);
            if (caseStruct.navCase.hasRedirect()) {
                String newPath = viewHandler.getActionURL(context, caseStruct.viewId);
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Redirecting to path " + newPath + " for outcome " + outcome + "and viewId " + caseStruct.viewId);
                    }
                    extContext.redirect(extContext.encodeActionURL(newPath));
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "jsf.redirect_failed_error", newPath);
                    }
                    throw new FacesException(ioe.getMessage(), ioe);
                }
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext context, String fromAction, String outcome) {
        UIViewRoot root = context.getViewRoot();
        String viewId = root != null ? root.getViewId() : null;
        CaseStruct caseStruct = null;
        if (viewId != null && (caseStruct = this.findExactMatch(viewId, fromAction, outcome)) == null) {
            caseStruct = this.findWildCardMatch(viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(fromAction, outcome);
        }
        if (caseStruct == null && logger.isLoggable(Level.WARNING)) {
            if (fromAction == null) {
                logger.log(Level.FINE, "jsf.navigation.no_matching_outcome", new Object[]{viewId, outcome});
            } else {
                logger.log(Level.FINE, "jsf.navigation.no_matching_outcome_action", new Object[]{viewId, outcome, fromAction});
            }
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(String viewId, String fromAction, String outcome) {
        if (!this.navigationConfigured) {
            return null;
        }
        List<ConfigNavigationCase> caseList = this.caseListMap.get(viewId);
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct findWildCardMatch(String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        if (!this.navigationConfigured) {
            return null;
        }
        for (String fromViewId : this.wildCardSet) {
            if (!viewId.startsWith(fromViewId)) continue;
            String wcFromViewId = new StringBuilder(32).append(fromViewId).append('*').toString();
            List<ConfigNavigationCase> caseList = this.caseListMap.get(wcFromViewId);
            if (caseList == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(caseList, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        return result;
    }

    private CaseStruct findDefaultMatch(String fromAction, String outcome) {
        if (!this.navigationConfigured) {
            return null;
        }
        List<ConfigNavigationCase> caseList = this.caseListMap.get("*");
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct determineViewFromActionOutcome(List<ConfigNavigationCase> caseList, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        for (ConfigNavigationCase cnc : caseList) {
            String cncFromAction = cnc.getFromAction();
            String fromOutcome = cnc.getFromOutcome();
            String toViewId = cnc.getToViewId();
            if (cncFromAction != null && fromOutcome != null && cncFromAction.equals(fromAction) && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction == null && fromOutcome != null && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null && fromOutcome == null && cncFromAction.equals(fromAction)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null || fromOutcome != null) continue;
            result.viewId = toViewId;
            result.navCase = cnc;
            return result;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        private CaseStruct() {
        }
    }
}

