/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ThreadFinalizer;
import java.io.IOException;
import java.util.Hashtable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Driver {
    protected Thread thread = null;
    protected int id;
    public volatile boolean isRunning = false;
    public volatile boolean canStop = false;
    protected Logger logmon = null;
    protected String name = null;
    protected static Hashtable drivers = new Hashtable();

    protected Driver(int id) {
        this.id = id;
        this.isRunning = true;
        String classname = this.getClass().getName();
        this.logmon = Debug.getLogger("fr.dyade.aaa.agent.Agent.ProxyAgent." + classname.substring(classname.lastIndexOf(46) + 1));
        this.name = classname + '#' + id;
    }

    protected Driver() {
        this(0);
        this.isRunning = true;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "(" + this.getClass().getName() + ",name=" + this.getName() + ",id=" + this.id + ")" + ",isRunning=" + this.isRunning + ",canStop=" + this.canStop;
    }

    public abstract void run() throws Exception;

    protected void end() {
    }

    public void start() {
        this.thread = new Thread((Runnable)new ThreadFinalizer(this), this.getName());
        this.thread.setDaemon(true);
        drivers.put(this, this);
        this.thread.start();
    }

    synchronized void reset() {
        this.thread = null;
        drivers.remove(this);
    }

    public synchronized void stop() {
        if (this.thread == null) {
            return;
        }
        this.isRunning = false;
        if (this.canStop) {
            this.thread.interrupt();
            this.close();
        }
        this.thread = null;
    }

    public abstract void close();

    static void stopAll() {
        Logger logmon = Debug.getLogger("fr.dyade.aaa.agent.Agent.ProxyAgent");
        if (drivers == null || drivers.size() == 0) {
            return;
        }
        Driver[] tab = drivers.values().toArray(new Driver[0]);
        for (int i = 0; i < tab.length; ++i) {
            logmon.log(BasicLevel.WARN, (Object)(tab[i].getName() + " " + tab[i].isRunning + "/" + tab[i].canStop + " stop()"));
            tab[i].stop();
        }
    }

    protected final void sendTo(AgentId to, Notification not) throws IOException {
        Channel.sendTo(to, not);
    }
}

