/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentFactory;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentIdStamp;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.BagSerializer;
import fr.dyade.aaa.agent.Engine;
import fr.dyade.aaa.agent.EngineThread;
import fr.dyade.aaa.agent.HAStateReply;
import fr.dyade.aaa.agent.JGroups;
import fr.dyade.aaa.agent.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;

final class HAEngine
extends Engine {
    private Vector qinFromExt = new Vector();
    private JGroups jgroups = null;
    private static long DEFAULT_HA_TIMEOUT = 10000L;
    private static String HA_TIMEOUT_PROPERTY = "fr.dyade.aaa.agent.HAEngine.HA_TIMEOUT";
    volatile boolean needToSync = false;
    volatile Vector requestor = new Vector();

    HAEngine() throws Exception {
        this.timeout = Long.getLong(HA_TIMEOUT_PROPERTY, DEFAULT_HA_TIMEOUT);
    }

    public void setJGroups(JGroups jgroups) {
        this.jgroups = jgroups;
    }

    public void save() throws IOException {
    }

    public void restore() throws Exception {
    }

    public synchronized void post(Message msg) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " post(" + msg + ")"));
        }
        if (EngineThread.class.isInstance(Thread.currentThread())) {
            super.post(msg);
        } else {
            if (this.jgroups.coordinator) {
                this.jgroups.send(msg);
            }
            this.stamp(msg);
            msg.save();
            this.qinFromExt.addElement(msg);
        }
    }

    private void postFromExt() {
        Message msg = null;
        if (this.qin.size() == 0) {
            try {
                msg = (Message)this.qinFromExt.elementAt(0);
                this.qinFromExt.removeElementAt(0);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", postFromExt(): qinFromExt empty"));
                }
                return;
            }
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", postFromExt() -> " + msg));
            }
            this.qin.push(msg);
            this.qin.validate();
            return;
        }
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", postFromExt()"));
        }
    }

    public void validate() {
        if (!this.needToSync) {
            this.postFromExt();
        }
        super.validate();
    }

    void commit() throws Exception {
        if (!this.requestor.isEmpty()) {
            this.needToSync = true;
        }
        if (this.msg != null) {
            super.commit();
        }
        if (this.needToSync && this.qin.size() == 0) {
            this.getState();
            this.needToSync = false;
        }
        this.postFromExt();
    }

    void abort(Exception exc) throws Exception {
        super.abort(exc);
        this.postFromExt();
    }

    void receiveFromJGroups(Message msg) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " receiveFromJGroups(" + msg + ")"));
        }
        AgentServer.getTransaction().begin();
        this.stamp(msg);
        msg.save();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + " receiveFromJGroups qin.size() = " + this.qin.size() + ", qinFromExt.size() = " + this.qinFromExt.size()));
        }
        AgentServer.getTransaction().commit(false);
        this.qinFromExt.addElement(msg);
        this.postFromExt();
        AgentServer.getTransaction().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void getState() throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", getState()"));
        }
        HAStateReply reply = new HAStateReply();
        reply.now = this.now;
        reply.stamp = this.getStamp();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(AgentIdStamp.stamp);
            Enumeration e = this.agents.elements();
            while (e.hasMoreElements()) {
                Agent agent = (Agent)e.nextElement();
                if (agent instanceof AgentFactory) continue;
                oos.writeObject(agent.getId());
                oos.writeObject(agent);
                if (!(agent instanceof BagSerializer)) continue;
                ((BagSerializer)((Object)agent)).writeBag(oos);
            }
            oos.flush();
            reply.agents = baos.toByteArray();
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exc) {}
        }
        baos.reset();
        oos = new ObjectOutputStream(baos);
        try {
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                for (int i = 0; i < this.qinFromExt.size(); ++i) {
                    Message msg = (Message)this.qinFromExt.elementAt(i);
                    this.logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " getState() -> " + msg));
                }
            }
            oos.writeObject(this.qinFromExt);
            reply.messages = baos.toByteArray();
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception exc) {}
        }
        reply.setNetworkStamp(this.jgroups.network.getStamp());
        this.requestor.clear();
        this.jgroups.send(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setState(HAStateReply reply) throws Exception {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + ", setState()"));
        }
        this.now = reply.now;
        this.setStamp(reply.stamp);
        ByteArrayInputStream bis = new ByteArrayInputStream(reply.agents);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            AgentId id = null;
            Agent agent = null;
            AgentIdStamp.stamp = (AgentIdStamp)ois.readObject();
            while (true) {
                id = (AgentId)ois.readObject();
                agent = (Agent)ois.readObject();
                agent.id = id;
                agent.deployed = true;
                if (agent instanceof BagSerializer) {
                    ((BagSerializer)((Object)agent)).readBag(ois);
                } else {
                    agent.agentInitialize(false);
                }
                this.createAgent(agent);
            }
        }
        catch (EOFException exc) {
            this.logmon.log(BasicLevel.WARN, (Object)(AgentServer.getName() + " setState()"), (Throwable)exc);
            try {
                ois.close();
            }
            catch (Exception exc2) {}
        }
        catch (Exception exc) {
            try {
                this.logmon.log(BasicLevel.ERROR, (Object)(AgentServer.getName() + " setState()"), (Throwable)exc);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    ois.close();
                }
                catch (Exception exc3) {}
            }
        }
        bis = new ByteArrayInputStream(reply.messages);
        ois = new ObjectInputStream(bis);
        try {
            this.qinFromExt = (Vector)ois.readObject();
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                for (int i = 0; i < this.qinFromExt.size(); ++i) {
                    Message msg = (Message)this.qinFromExt.elementAt(i);
                    this.logmon.log(BasicLevel.DEBUG, (Object)(AgentServer.getName() + " setState() -> " + msg));
                }
            }
            this.postFromExt();
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exc) {}
        }
    }

    Object load(byte[] buf) throws Exception {
        Object obj = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        obj = ois.readObject();
        try {
            ois.close();
        }
        catch (IOException exc) {
            // empty catch block
        }
        return obj;
    }

    protected void onTimeOut() throws Exception {
        if (!this.requestor.isEmpty()) {
            this.commit();
        }
    }
}

