/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;

public final class Configuration {
    private DiskStoreConfiguration diskStoreConfiguration;
    private CacheConfiguration defaultCacheConfiguration;
    private FactoryConfiguration cacheManagerPeerProviderFactoryConfiguration;
    private FactoryConfiguration cacheManagerPeerListenerFactoryConfiguration;
    private FactoryConfiguration cacheManagerEventListenerFactoryConfiguration;
    private final Map cacheConfigurations = new HashMap();
    private String configurationSource;

    public final void addDiskStore(DiskStoreConfiguration diskStoreConfigurationParameter) throws ObjectExistsException {
        if (this.diskStoreConfiguration != null) {
            throw new ObjectExistsException("The Disk Store has already been configured");
        }
        this.diskStoreConfiguration = diskStoreConfigurationParameter;
    }

    public final void addCacheManagerEventListenerFactory(FactoryConfiguration cacheManagerEventListenerFactoryConfiguration) throws ObjectExistsException {
        if (this.cacheManagerEventListenerFactoryConfiguration == null) {
            this.cacheManagerEventListenerFactoryConfiguration = cacheManagerEventListenerFactoryConfiguration;
        }
    }

    public final void addCacheManagerPeerProviderFactory(FactoryConfiguration factory) {
        if (this.cacheManagerPeerProviderFactoryConfiguration == null) {
            this.cacheManagerPeerProviderFactoryConfiguration = factory;
        }
    }

    public final void addCacheManagerPeerListenerFactory(FactoryConfiguration factory) {
        if (this.cacheManagerPeerListenerFactoryConfiguration == null) {
            this.cacheManagerPeerListenerFactoryConfiguration = factory;
        }
    }

    public final void addDefaultCache(CacheConfiguration defaultCacheConfiguration) throws ObjectExistsException {
        if (this.defaultCacheConfiguration != null) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.defaultCacheConfiguration = defaultCacheConfiguration;
    }

    public final void addCache(CacheConfiguration cacheConfiguration) throws ObjectExistsException {
        if (this.cacheConfigurations.get(cacheConfiguration.name) != null) {
            throw new ObjectExistsException("Cannot create cache: " + cacheConfiguration.name + " with the same name as an existing one.");
        }
        if (cacheConfiguration.name.equalsIgnoreCase("default")) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.cacheConfigurations.put(cacheConfiguration.name, cacheConfiguration);
    }

    public final Set getCacheConfigurationsKeySet() {
        return this.cacheConfigurations.keySet();
    }

    public final CacheConfiguration getDefaultCacheConfiguration() {
        return this.defaultCacheConfiguration;
    }

    public final void setDefaultCacheConfiguration(CacheConfiguration defaultCacheConfiguration) {
        this.defaultCacheConfiguration = defaultCacheConfiguration;
    }

    public final DiskStoreConfiguration getDiskStoreConfiguration() {
        return this.diskStoreConfiguration;
    }

    public final FactoryConfiguration getCacheManagerPeerProviderFactoryConfiguration() {
        return this.cacheManagerPeerProviderFactoryConfiguration;
    }

    public final FactoryConfiguration getCacheManagerPeerListenerFactoryConfiguration() {
        return this.cacheManagerPeerListenerFactoryConfiguration;
    }

    public final FactoryConfiguration getCacheManagerEventListenerFactoryConfiguration() {
        return this.cacheManagerEventListenerFactoryConfiguration;
    }

    public final Map getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public final void setSource(String configurationSource) {
        this.configurationSource = configurationSource;
    }

    public final String getConfigurationSource() {
        return this.configurationSource;
    }
}

