/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.apache.felix.dependencymanager.DefaultNullObject;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.Logger;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceImpl;
import org.apache.felix.dependencymanager.ServiceTracker;
import org.apache.felix.dependencymanager.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceDependency
implements Dependency,
ServiceTrackerCustomizer {
    private boolean m_isRequired;
    private Service m_service;
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private boolean m_isAvailable;
    private Class m_trackedServiceName;
    private Object m_nullObject;
    private String m_trackedServiceFilter;
    private ServiceReference m_trackedServiceReference;
    private boolean m_isStarted;
    private Object m_callbackInstance;
    private String m_callbackAdded;
    private String m_callbackChanged;
    private String m_callbackRemoved;
    private boolean m_autoConfig;
    private ServiceReference m_reference;
    private Object m_serviceInstance;
    private final Logger m_logger;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$lang$Object;

    public ServiceDependency(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.m_autoConfig = true;
    }

    public synchronized boolean isRequired() {
        return this.m_isRequired;
    }

    public synchronized boolean isAvailable() {
        return this.m_isAvailable;
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public synchronized Object getService() {
        Object service = null;
        if (this.m_isStarted) {
            service = this.m_tracker.getService();
        }
        if (service == null) {
            service = this.getNullObject();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNullObject() {
        if (this.m_nullObject == null) {
            Class trackedServiceName;
            ServiceDependency serviceDependency = this;
            synchronized (serviceDependency) {
                trackedServiceName = this.m_trackedServiceName;
            }
            this.m_nullObject = Proxy.newProxyInstance(trackedServiceName.getClassLoader(), new Class[]{trackedServiceName}, (InvocationHandler)new DefaultNullObject());
        }
        return this.m_nullObject;
    }

    public synchronized Class getInterface() {
        return this.m_trackedServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Service service) {
        ServiceDependency serviceDependency = this;
        synchronized (serviceDependency) {
            if (this.m_isStarted) {
                throw new IllegalStateException("Service dependency was already started." + this.m_trackedServiceName);
            }
            this.m_service = service;
            if (this.m_trackedServiceName != null) {
                if (this.m_trackedServiceFilter != null) {
                    try {
                        this.m_tracker = new ServiceTracker(this.m_context, this.m_context.createFilter(this.m_trackedServiceFilter), (ServiceTrackerCustomizer)this);
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException("Invalid filter definition for dependency.");
                    }
                } else {
                    this.m_tracker = this.m_trackedServiceReference != null ? new ServiceTracker(this.m_context, this.m_trackedServiceReference, (ServiceTrackerCustomizer)this) : new ServiceTracker(this.m_context, this.m_trackedServiceName.getName(), (ServiceTrackerCustomizer)this);
                }
            } else {
                throw new IllegalStateException("Could not create tracker for dependency, no service name specified.");
            }
            this.m_isStarted = true;
        }
        this.m_tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Service service) {
        ServiceDependency serviceDependency = this;
        synchronized (serviceDependency) {
            if (!this.m_isStarted) {
                throw new IllegalStateException("Service dependency was not started.");
            }
            this.m_isStarted = false;
        }
        this.m_tracker.close();
        this.m_tracker = null;
    }

    public Object addingService(ServiceReference ref) {
        Object service = this.m_context.getService(ref);
        this.m_reference = ref;
        this.m_serviceInstance = service;
        return service;
    }

    public void addedService(ServiceReference ref, Object service) {
        if (this.makeAvailable()) {
            this.m_service.dependencyAvailable(this);
        } else {
            this.m_service.dependencyChanged(this);
        }
        if (!this.isRequired()) {
            this.invokeAdded(ref, service);
        }
    }

    public void invokeAdded() {
        this.invokeAdded(this.m_reference, this.m_serviceInstance);
    }

    public void invokeAdded(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackAdded != null) {
            try {
                this.invokeCallbackMethod(callbackInstance, this.m_callbackAdded, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackAdded + " on " + callbackInstance + ".", e);
            }
        }
    }

    public void modifiedService(ServiceReference ref, Object service) {
        this.m_reference = ref;
        this.m_serviceInstance = service;
        this.m_service.dependencyChanged(this);
        if (((ServiceImpl)this.m_service).isRegistered()) {
            this.invokeChanged(ref, service);
        }
    }

    public void invokeChanged(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackChanged != null) {
            try {
                if (this.m_reference == null) {
                    Thread.dumpStack();
                }
                this.invokeCallbackMethod(callbackInstance, this.m_callbackChanged, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackChanged + " on " + callbackInstance + ".", e);
            }
        }
    }

    public void removedService(ServiceReference ref, Object service) {
        if (this.makeUnavailable()) {
            this.m_service.dependencyUnavailable(this);
        }
        if (!this.isRequired()) {
            this.invokeRemoved(ref, service);
        }
        this.m_context.ungetService(ref);
    }

    public void invokeRemoved() {
        this.invokeRemoved(this.m_reference, this.m_serviceInstance);
    }

    public void invokeRemoved(ServiceReference reference, Object serviceInstance) {
        Object callbackInstance = this.getCallbackInstance();
        if (callbackInstance != null && this.m_callbackRemoved != null) {
            try {
                if (this.m_reference == null) {
                    Thread.dumpStack();
                }
                this.invokeCallbackMethod(callbackInstance, this.m_callbackRemoved, reference, serviceInstance);
            }
            catch (NoSuchMethodException e) {
                this.m_logger.log(1, "Could not invoke method " + this.m_callbackRemoved + " on " + callbackInstance + ".", e);
            }
        }
    }

    private synchronized boolean makeAvailable() {
        if (!this.m_isAvailable) {
            this.m_isAvailable = true;
            return true;
        }
        return false;
    }

    private synchronized boolean makeUnavailable() {
        if (this.m_isAvailable && this.m_tracker.getServiceReference() == null) {
            this.m_isAvailable = false;
            return true;
        }
        return false;
    }

    private synchronized Object getCallbackInstance() {
        Object callbackInstance = this.m_callbackInstance;
        if (callbackInstance == null) {
            callbackInstance = this.m_service.getService();
        }
        return callbackInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCallbackMethod(Object instance, String methodName, ServiceReference reference, Object service) throws NoSuchMethodException {
        Class<?> currentClazz = instance.getClass();
        boolean done = false;
        while (!done && currentClazz != null) {
            Class trackedServiceName;
            ServiceDependency serviceDependency = this;
            synchronized (serviceDependency) {
                trackedServiceName = this.m_trackedServiceName;
            }
            done = this.invokeMethod(instance, currentClazz, methodName, new Class[][]{{class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference, trackedServiceName}, {class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference, class$java$lang$Object == null ? ServiceDependency.class$("java.lang.Object") : class$java$lang$Object}, {class$org$osgi$framework$ServiceReference == null ? ServiceDependency.class$("org.osgi.framework.ServiceReference") : class$org$osgi$framework$ServiceReference}, {trackedServiceName}, {class$java$lang$Object == null ? ServiceDependency.class$("java.lang.Object") : class$java$lang$Object}, new Class[0]}, new Object[][]{{reference, service}, {reference, service}, {reference}, {service}, {service}, new Object[0]}, false);
            if (done) continue;
            currentClazz = currentClazz.getSuperclass();
        }
        if (!done && currentClazz == null) {
            throw new NoSuchMethodException(methodName);
        }
    }

    private boolean invokeMethod(Object object, Class clazz, String name, Class[][] signatures, Object[][] parameters, boolean isSuper) {
        Method m = null;
        for (int i = 0; i < signatures.length; ++i) {
            Class[] signature = signatures[i];
            try {
                m = clazz.getDeclaredMethod(name, signature);
                if (isSuper && Modifier.isPrivate(m.getModifiers())) continue;
                m.setAccessible(true);
                try {
                    m.invoke(object, parameters[i]);
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(1, "Exception while invoking method " + m + ".", e);
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Exception e) {
                this.m_logger.log(1, "Exception while trying to invoke method " + m + ".", e);
            }
        }
        return false;
    }

    public synchronized ServiceDependency setService(Class serviceName) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceReference = null;
        this.m_trackedServiceFilter = null;
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, String serviceFilter) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceFilter = serviceFilter;
        this.m_trackedServiceReference = null;
        return this;
    }

    public synchronized ServiceDependency setService(Class serviceName, ServiceReference serviceReference) {
        this.ensureNotActive();
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name cannot be null.");
        }
        this.m_trackedServiceName = serviceName;
        this.m_trackedServiceReference = serviceReference;
        this.m_trackedServiceFilter = null;
        return this;
    }

    public synchronized ServiceDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.m_isRequired = required;
        return this;
    }

    public synchronized ServiceDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        return this;
    }

    public synchronized ServiceDependency setCallbacks(String added, String removed) {
        return this.setCallbacks(null, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks(null, added, changed, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, null, removed);
    }

    public synchronized ServiceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.ensureNotActive();
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_tracker != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public synchronized String toString() {
        return "ServiceDependency[" + this.m_trackedServiceName + " " + this.m_trackedServiceFilter + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

