/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;

    public SymbolTable() {
        this(101);
    }

    public SymbolTable(int tableSize) {
        this.fTableSize = tableSize;
        this.fBuckets = new Entry[this.fTableSize];
    }

    public String addSymbol(String symbol2) {
        int bucket = this.hash(symbol2) % this.fTableSize;
        int length = symbol2.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (symbol2.charAt(i) == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[bucket] = entry = new Entry(symbol2, this.fBuckets[bucket]);
        return entry.symbol;
    }

    public String addSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return entry.symbol;
                }
            }
            entry = entry.next;
        }
        this.fBuckets[bucket] = entry = new Entry(buffer, offset, length, this.fBuckets[bucket]);
        return entry.symbol;
    }

    public int hash(String symbol2) {
        int code = 0;
        int length = symbol2.length();
        for (int i = 0; i < length; ++i) {
            code = code * 37 + symbol2.charAt(i);
        }
        return code & 0x7FFFFFF;
    }

    public int hash(char[] buffer, int offset, int length) {
        int code = 0;
        for (int i = 0; i < length; ++i) {
            code = code * 37 + buffer[offset + i];
        }
        return code & 0x7FFFFFF;
    }

    public boolean containsSymbol(String symbol2) {
        int bucket = this.hash(symbol2) % this.fTableSize;
        int length = symbol2.length();
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (symbol2.charAt(i) == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] buffer, int offset, int length) {
        int bucket = this.hash(buffer, offset, length) % this.fTableSize;
        Entry entry = this.fBuckets[bucket];
        while (entry != null) {
            block4: {
                if (length == entry.characters.length) {
                    for (int i = 0; i < length; ++i) {
                        if (buffer[offset + i] == entry.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public String symbol;
        public char[] characters;
        public Entry next;

        public Entry(String symbol2, Entry next) {
            this.symbol = symbol2.intern();
            this.characters = new char[symbol2.length()];
            symbol2.getChars(0, this.characters.length, this.characters, 0);
            this.next = next;
        }

        public Entry(char[] ch, int offset, int length, Entry next) {
            this.characters = new char[length];
            System.arraycopy(ch, offset, this.characters, 0, length);
            this.symbol = new String(this.characters).intern();
            this.next = next;
        }
    }
}

