/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Address;

class AddressTable {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$AddressTable == null ? (class$org$apache$juddi$datastore$jdbc$AddressTable = AddressTable.class$("org.apache.juddi.datastore.jdbc.AddressTable")) : class$org$apache$juddi$datastore$jdbc$AddressTable);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$AddressTable;

    AddressTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector addrList, Connection connection) throws SQLException {
        if (addrList == null || addrList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = addrList.size();
            for (int addressID = 0; addressID < listSize; ++addressID) {
                Address address = (Address)addrList.elementAt(addressID);
                statement.setInt(3, addressID);
                statement.setString(4, address.getUseType());
                statement.setString(5, address.getSortCode());
                statement.setString(6, address.getTModelKey());
                log.debug("insert into ADDRESS table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t ADDRESS_ID=" + addressID + "\n\t USE_TYPE=" + address.getUseType() + "\n\t SORT_CODE=" + address.getSortCode() + "\n\t TMODEL_KEY=" + address.getTModelKey() + "\n");
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Address> addrList = new Vector<Address>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            log.debug("select from ADDRESS table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Address address = new Address();
                address.setUseType(resultSet.getString(1));
                address.setSortCode(resultSet.getString(2));
                address.setTModelKey(resultSet.getString(3));
                addrList.add(address);
                address = null;
            }
            Vector<Address> vector = addrList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug("delete from ADDRESS table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n");
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ADDRESS (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("ADDRESS_ID,");
        sql.append("USE_TYPE,");
        sql.append("SORT_CODE,");
        sql.append("TMODEL_KEY) ");
        sql.append("VALUES (?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("SORT_CODE,");
        sql.append("TMODEL_KEY, ");
        sql.append("ADDRESS_ID ");
        sql.append("FROM ADDRESS ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY ADDRESS_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ADDRESS ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

