/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.AbstractRegistry;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.FunctionMaker;
import org.apache.juddi.function.IFunction;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public class RegistryEngine
extends AbstractRegistry {
    private static final String PROPFILE_NAME = "juddi.properties";
    public static final String PROPNAME_OPERATOR_NAME = "juddi.operatorName";
    public static final String PROPNAME_I18N_LANGUAGE_CODE = "juddi.i18n.languageCode";
    public static final String PROPNAME_I18N_COUNTRY_CODE = "juddi.i18n.countryCode";
    public static final String PROPNAME_DISCOVERY_URL = "juddi.discoveryURL";
    public static final String PROPNAME_ADMIN_EMAIL_ADDRESS = "juddi.adminEmailAddress";
    public static final String PROPNAME_DATASOURCE_NAME = "juddi.dataSource";
    public static final String PROPNAME_AUTH_CLASS_NAME = "juddi.auth";
    public static final String PROPNAME_DATASTORE_CLASS_NAME = "juddi.dataStore";
    public static final String PROPNAME_CRYPTOR_CLASS_NAME = "juddi.cryptor";
    public static final String PROPNAME_UUIDGEN_CLASS_NAME = "juddi.uuidgen";
    public static final String PROPNAME_VALIDATOR_CLASS_NAME = "juddi.validator";
    public static final String PROPNAME_MAX_NAME_ELEMENTS = "juddi.maxNameElementsAllowed";
    public static final String PROPNAME_MAX_NAME_LENGTH = "juddi.maxNameLengthAllowed";
    public static final String PROPNAME_MAX_MESSAGE_SIZE = "juddi.maxMessageSize";
    public static final String PROPNAME_MAX_BUSINESS_ENTITIES_PER_USER = "juddi.maxBusinessEntitiesPerUser";
    public static final String PROPNAME_MAX_BUSINESS_SERVICES_PER_BUSINESS = "juddi.maxBusinessServicesPerBusiness";
    public static final String PROPNAME_MAX_BINDING_TEMPLATES_PER_SERVICE = "juddi.maxBindingTemplatesPerService";
    public static final String PROPNAME_MAX_TMODELS_PER_USER = "juddi.maxTModelsPerUser";
    public static final String PROPNAME_MAX_ROWS_LIMIT = "juddi.maxRowsLimit";
    public static final String DEFAULT_OPERATOR_NAME = "Apache.org";
    public static final String DEFAULT_I18N_LANGUAGE_CODE = "en";
    public static final String DEFAULT_I18N_COUNTRY_CODE = "US";
    public static final String DEFAULT_DISCOVERY_URL = "http://localhost:8080/juddi/uddiget.jsp?";
    public static final String DEFAULT_ADMIN_EMAIL_ADDRESS = "nobody@apache.org";
    public static final String DEFAULT_DATASOURCE_NAME = "java:comp/env/jdbc/juddiDB";
    public static final String DEFAULT_AUTH_CLASS_NAME = "org.apache.juddi.auth.DefaultAuthenticator";
    public static final String DEFAULT_DATASTORE_CLASS_NAME = "org.apache.juddi.datastore.JDBCDataStore";
    public static final String DEFAULT_CRYPTOR_CLASS_NAME = "org.apache.juddi.cryptor.DefaultCryptor";
    public static final String DEFAULT_UUIDGEN_CLASS_NAME = "org.apache.juddi.uuidgen.DefaultUUIDGen";
    public static final String DEFAULT_VALIDATOR_CLASS_NAME = "org.apache.juddi.validator.DefaultValidator";
    public static final int DEFAULT_MAX_NAME_ELEMENTS = 5;
    public static final int DEFAULT_MAX_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    public static final int DEFAULT_MAX_BUSINESS_ENTITIES_PER_USER = 25;
    public static final int DEFAULT_MAX_BUSINESS_SERVICES_PER_BUSINESS = 20;
    public static final int DEFAULT_MAX_BINDING_TEMPLATES_PER_SERVICE = 10;
    public static final int DEFAULT_MAX_TMODELS_PER_USER = 100;
    public static final int DEFAULT_MAX_ROWS_LIMIT = 10;
    private static Log log = LogFactory.getLog(class$org$apache$juddi$registry$RegistryEngine == null ? (class$org$apache$juddi$registry$RegistryEngine = RegistryEngine.class$("org.apache.juddi.registry.RegistryEngine")) : class$org$apache$juddi$registry$RegistryEngine);
    private FunctionMaker maker = null;
    private boolean isAvailable = false;
    static /* synthetic */ Class class$org$apache$juddi$registry$RegistryEngine;

    public RegistryEngine() {
        try {
            InputStream stream = Loader.getResourceAsStream(PROPFILE_NAME);
            if (stream != null) {
                Properties props = new Properties();
                props.load(stream);
                Config.addProperties(props);
            }
        }
        catch (IOException ioex) {
            log.error("An error occured while loading properties from: juddi.properties", ioex);
        }
    }

    public RegistryEngine(Properties props) {
        if (props != null) {
            Config.addProperties(props);
        }
    }

    public void init() {
        this.isAvailable = false;
        this.maker = new FunctionMaker(this);
        this.isAvailable = true;
    }

    public void dispose() {
        this.isAvailable = false;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public RegistryObject execute(RegistryObject request) throws RegistryException {
        String className = request.getClass().getName();
        IFunction function = this.maker.lookup(className);
        if (function == null) {
            throw new UnsupportedException(className);
        }
        RegistryObject response = function.execute(request);
        return response;
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty(PROPNAME_OPERATOR_NAME, "jUDDI.org");
        props.setProperty(PROPNAME_MAX_NAME_ELEMENTS, "5");
        props.setProperty(PROPNAME_MAX_NAME_LENGTH, "255");
        props.setProperty(PROPNAME_DISCOVERY_URL, "http://localhost/juddi");
        props.setProperty(PROPNAME_ADMIN_EMAIL_ADDRESS, "admin@juddi.org");
        props.setProperty(PROPNAME_MAX_MESSAGE_SIZE, "2097152");
        props.setProperty(PROPNAME_AUTH_CLASS_NAME, DEFAULT_AUTH_CLASS_NAME);
        props.setProperty(PROPNAME_CRYPTOR_CLASS_NAME, DEFAULT_CRYPTOR_CLASS_NAME);
        props.setProperty(PROPNAME_UUIDGEN_CLASS_NAME, DEFAULT_UUIDGEN_CLASS_NAME);
        props.setProperty("juddi.useConnectionPool", "true");
        props.setProperty("juddi.jdbcDriver", "com.mysql.jdbc.Driver");
        props.setProperty("juddi.jdbcURL", "jdbc:mysql://localhost/juddi");
        props.setProperty("juddi.jdbcUser", "juddi");
        props.setProperty("juddi.jdbcPassword", "juddi");
        props.setProperty("juddi.jdbcMaxActive", "10");
        props.setProperty("juddi.jdbcMaxIdle", "10");
        RegistryEngine registry = new RegistryEngine(props);
        registry.init();
        System.out.println(Config.getProperties());
        AuthToken authToken = registry.getAuthToken("sviens", "password");
        AuthInfo authInfo = authToken.getAuthInfo();
        System.out.println("AuthToken: " + authInfo.getValue());
        registry.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

