/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.util.Config;

public class ConnectionManager {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$util$jdbc$ConnectionManager == null ? (class$org$apache$juddi$util$jdbc$ConnectionManager = ConnectionManager.class$("org.apache.juddi.util.jdbc.ConnectionManager")) : class$org$apache$juddi$util$jdbc$ConnectionManager);
    private static DataSource dataSource = null;
    static /* synthetic */ Class class$org$apache$juddi$util$jdbc$ConnectionManager;

    public static Connection aquireConnection() throws SQLException {
        if (dataSource == null) {
            dataSource = ConnectionManager.lookupDataSource();
        }
        Connection conn = null;
        if (dataSource != null) {
            conn = dataSource.getConnection();
        }
        return conn;
    }

    private static synchronized DataSource lookupDataSource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        try {
            String dataSourceName = Config.getStringProperty("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
            log.info("Using JNDI to aquire a JDBC DataSource with name: " + dataSourceName);
            InitialContext initCtx = new InitialContext();
            dataSource = (DataSource)initCtx.lookup(dataSourceName);
        }
        catch (NamingException nex) {
            log.error("Exception occurred while attempting to acquire a JDBC DataSource from JNDI: " + nex.getMessage());
        }
        return dataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

