/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.values.JavaStringHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaStringHolderEx
extends JavaStringHolder {
    private SchemaType _schemaType;

    public SchemaType schemaType() {
        return this._schemaType;
    }

    public JavaStringHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    protected int get_wscanon_rule() {
        return this.schemaType().getWhiteSpaceRule();
    }

    protected void set_text(String s) {
        if (this._validateOnSet()) {
            JavaStringHolderEx.validateLexical(s, this._schemaType, _voorVc);
        }
        super.set_text(s);
    }

    protected boolean is_defaultable_ws(String v) {
        try {
            JavaStringHolderEx.validateLexical(v, this._schemaType, _voorVc);
            return false;
        }
        catch (XmlValueOutOfRangeException e) {
            return true;
        }
    }

    public static void validateLexical(String v, SchemaType sType, ValidationContext context) {
        XmlAnySimpleType max;
        XmlAnySimpleType min;
        if (!sType.matchPatternFacet(v)) {
            context.invalid("String: '" + v + "' does not match pattern for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType len = sType.getFacet(0);
        if (len != null) {
            int m = ((XmlObjectBase)((Object)len)).bigIntegerValue().intValue();
            if (v.length() != m) {
                context.invalid("String length (" + v.length() + ") does not match " + "length facet (" + m + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((min = sType.getFacet(1)) != null) {
            int m = ((XmlObjectBase)((Object)min)).bigIntegerValue().intValue();
            if (v.length() < m) {
                context.invalid("String length (" + v.length() + ") is less than " + "min length facet (" + m + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((max = sType.getFacet(2)) != null) {
            int m = ((XmlObjectBase)((Object)max)).bigIntegerValue().intValue();
            if (v.length() > m) {
                context.invalid("String length (" + v.length() + ") is greater than " + "max length facet (" + m + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaStringHolderEx.validateLexical(this.stringValue(), this.schemaType(), ctx);
    }
}

