/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.Assigned;
import org.hibernate.id.Configurable;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.SequenceHiLoGenerator;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class IdentifierGeneratorFactory {
    private static final Log log = LogFactory.getLog(IdentifierGeneratorFactory.class);
    private static final HashMap GENERATORS = new HashMap();
    public static final Serializable SHORT_CIRCUIT_INDICATOR;
    public static final Serializable POST_INSERT_INDICATOR;

    public static Serializable getGeneratedIdentity(ResultSet rs, Type type) throws SQLException, HibernateException {
        if (!rs.next()) {
            throw new HibernateException("The database returned no natively generated identity value");
        }
        Serializable id = IdentifierGeneratorFactory.get(rs, type);
        if (log.isDebugEnabled()) {
            log.debug("Natively generated identity: " + id);
        }
        return id;
    }

    public static Serializable get(ResultSet rs, Type type) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        if (clazz == Long.class) {
            return new Long(rs.getLong(1));
        }
        if (clazz == Integer.class) {
            return new Integer(rs.getInt(1));
        }
        if (clazz == Short.class) {
            return new Short(rs.getShort(1));
        }
        if (clazz == String.class) {
            return rs.getString(1);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short or string");
    }

    public static IdentifierGenerator create(String strategy, Type type, Properties params, Dialect dialect) throws MappingException {
        try {
            Class clazz = IdentifierGeneratorFactory.getIdentifierGeneratorClass(strategy, dialect);
            IdentifierGenerator idgen = (IdentifierGenerator)clazz.newInstance();
            if (idgen instanceof Configurable) {
                ((Configurable)((Object)idgen)).configure(type, params, dialect);
            }
            return idgen;
        }
        catch (Exception e) {
            throw new MappingException("could not instantiate id generator [entity-name=" + params.get("entity_name") + "]", e);
        }
    }

    public static Class getIdentifierGeneratorClass(String strategy, Dialect dialect) {
        Class clazz = (Class)GENERATORS.get(strategy);
        if ("native".equals(strategy)) {
            clazz = dialect.getNativeIdentifierGeneratorClass();
        }
        try {
            if (clazz == null) {
                clazz = ReflectHelper.classForName(strategy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("could not interpret id generator strategy: " + strategy);
        }
        return clazz;
    }

    public static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return new Long(value);
        }
        if (clazz == Integer.class) {
            return new Integer((int)value);
        }
        if (clazz == Short.class) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorFactory() {
    }

    static {
        GENERATORS.put("uuid", UUIDHexGenerator.class);
        GENERATORS.put("hilo", TableHiLoGenerator.class);
        GENERATORS.put("assigned", Assigned.class);
        GENERATORS.put("identity", IdentityGenerator.class);
        GENERATORS.put("select", SelectGenerator.class);
        GENERATORS.put("sequence", SequenceGenerator.class);
        GENERATORS.put("seqhilo", SequenceHiLoGenerator.class);
        GENERATORS.put("increment", IncrementGenerator.class);
        GENERATORS.put("foreign", ForeignGenerator.class);
        GENERATORS.put("guid", GUIDGenerator.class);
        GENERATORS.put("uuid.hex", UUIDHexGenerator.class);
        GENERATORS.put("sequence-identity", SequenceIdentityGenerator.class);
        SHORT_CIRCUIT_INDICATOR = new Serializable(){

            public String toString() {
                return "SHORT_CIRCUIT_INDICATOR";
            }
        };
        POST_INSERT_INDICATOR = new Serializable(){

            public String toString() {
                return "POST_INSERT_INDICATOR";
            }
        };
    }
}

