/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.cglib;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.proxy.pojo.cglib.CGLIBLazyInitializer;
import org.hibernate.type.AbstractComponentType;

public final class SerializableProxy
implements Serializable {
    private String entityName;
    private Class persistentClass;
    private Class[] interfaces;
    private Serializable id;
    private Class getIdentifierMethodClass;
    private Class setIdentifierMethodClass;
    private String getIdentifierMethodName;
    private String setIdentifierMethodName;
    private Class[] setIdentifierMethodParams;
    private AbstractComponentType componentIdType;

    public SerializableProxy() {
    }

    public SerializableProxy(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType) {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = interfaces;
        this.id = id;
        if (getIdentifierMethod != null) {
            this.getIdentifierMethodClass = getIdentifierMethod.getDeclaringClass();
            this.getIdentifierMethodName = getIdentifierMethod.getName();
        }
        if (setIdentifierMethod != null) {
            this.setIdentifierMethodClass = setIdentifierMethod.getDeclaringClass();
            this.setIdentifierMethodName = setIdentifierMethod.getName();
            this.setIdentifierMethodParams = setIdentifierMethod.getParameterTypes();
        }
        this.componentIdType = componentIdType;
    }

    private Object readResolve() {
        try {
            return CGLIBLazyInitializer.getProxy(this.entityName, this.persistentClass, this.interfaces, this.getIdentifierMethodName == null ? null : this.getIdentifierMethodClass.getDeclaredMethod(this.getIdentifierMethodName, null), this.setIdentifierMethodName == null ? null : this.setIdentifierMethodClass.getDeclaredMethod(this.setIdentifierMethodName, this.setIdentifierMethodParams), this.componentIdType, this.id, null);
        }
        catch (NoSuchMethodException nsme) {
            throw new HibernateException("could not create proxy for entity: " + this.entityName, nsme);
        }
    }
}

