/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.SecurityException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundConnectionFactory;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.client.jms.ha.local.XAHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.XAHATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient PrintWriter out = null;
    transient JoramAdapter ra = null;
    boolean collocated;
    boolean isHa;
    String hostName;
    int serverPort;
    String userName = "anonymous";
    String password = "anonymous";
    public int connectingTimer = 0;
    public int txPendingTimer = 0;
    public int cnxPendingTimer = 0;
    public boolean asyncSend;
    public boolean multiThreadSync;
    public int multiThreadSyncDelay = -1;
    public String outLocalAddress = null;
    public int outLocalPort = 0;

    public int getConnectingTimer() {
        return this.connectingTimer;
    }

    public int getCnxPendingTimer() {
        return this.cnxPendingTimer;
    }

    public int getTxPendingTimer() {
        return this.txPendingTimer;
    }

    public boolean isAsyncSend() {
        return this.asyncSend;
    }

    public boolean isMultiThreadSync() {
        return this.multiThreadSync;
    }

    public int getMultiThreadSyncDelay() {
        return this.multiThreadSyncDelay;
    }

    protected void setParameters(Object factory) {
        FactoryParameters fp = null;
        if (factory instanceof ConnectionFactory) {
            ConnectionFactory f = (ConnectionFactory)factory;
            fp = f.getParameters();
        } else if (factory instanceof XAConnectionFactory) {
            XAConnectionFactory f = (XAConnectionFactory)factory;
            fp = f.getParameters();
        }
        if (fp != null) {
            fp.connectingTimer = this.connectingTimer;
            fp.cnxPendingTimer = this.cnxPendingTimer;
            fp.txPendingTimer = this.txPendingTimer;
            if (this.asyncSend) {
                fp.asyncSend = this.asyncSend;
            }
            if (this.multiThreadSync) {
                fp.multiThreadSync = this.multiThreadSync;
            }
            if (this.multiThreadSyncDelay > 0) {
                fp.multiThreadSyncDelay = this.multiThreadSyncDelay;
            }
            if (this.outLocalPort > 0) {
                fp.outLocalPort = this.outLocalPort;
            }
            if (this.outLocalAddress != null) {
                fp.outLocalAddress = this.outLocalAddress;
            }
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory(" + cxManager + ")"));
        }
        return new OutboundConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory()"));
        }
        OutboundConnectionFactory factory = new OutboundConnectionFactory(this, null);
        Reference ref = new Reference(factory.getClass().getName(), "org.objectweb.joram.client.connector.ObjectFactoryImpl", null);
        ref.add(new StringRefAddr("hostName", this.hostName));
        ref.add(new StringRefAddr("serverPort", "" + this.serverPort));
        ref.add(new StringRefAddr("userName", this.userName));
        ref.add(new StringRefAddr("password", this.password));
        factory.setReference(ref);
        return factory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        javax.jms.XAConnectionFactory factory;
        String password;
        String userName;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection(" + subject + ", " + cxRequest + ")"));
        }
        String hostName = this.hostName;
        int serverPort = this.serverPort;
        if (cxRequest == null) {
            userName = this.userName;
            password = this.password;
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                if (this.out != null) {
                    this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                }
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
            password = ((ConnectionRequest)cxRequest).getPassword();
        }
        XAConnection cnx = null;
        if (this.collocated) {
            hostName = "localhost";
            serverPort = -1;
        }
        if (this.isHa) {
            if (this.collocated) {
                factory = this.ra.haURL != null ? XAHATcpConnectionFactory.create(this.ra.haURL) : XAHALocalConnectionFactory.create();
            } else {
                String urlHa = "hajoram://" + hostName + ":" + serverPort;
                factory = XAHATcpConnectionFactory.create(urlHa);
            }
        } else {
            factory = this.collocated ? XALocalConnectionFactory.create() : XATcpConnectionFactory.create(hostName, serverPort);
        }
        this.setParameters(factory);
        try {
            cnx = factory.createXAConnection(userName, password);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection cnx = " + cnx));
            }
        }
        catch (IllegalStateException exc) {
            if (this.out != null) {
                this.out.print("Could not access the JORAM server: " + exc);
            }
            throw new CommException("Could not access the JORAM server: " + exc);
        }
        catch (JMSSecurityException exc) {
            if (this.out != null) {
                this.out.print("Invalid user identification: " + exc);
            }
            throw new SecurityException("Invalid user identification: " + exc);
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Failed connecting process: " + exc);
            }
            throw new ResourceException("Failed connecting process: " + exc);
        }
        ManagedConnectionImpl managedCx = new ManagedConnectionImpl(this.ra, cnx, hostName, serverPort, userName);
        managedCx.setLogWriter(this.out);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection managedCx = " + managedCx));
        }
        return managedCx;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        String userName;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequest + ")"));
        }
        String mode = "Unified";
        if (cxRequest == null) {
            userName = this.userName;
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            if (cxRequest instanceof QueueConnectionRequest) {
                mode = "PTP";
            } else if (cxRequest instanceof TopicConnectionRequest) {
                mode = "PubSub";
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
        }
        ManagedConnectionImpl managedCx = null;
        boolean matching = false;
        Iterator it = connectionSet.iterator();
        String hostName = this.hostName;
        int serverPort = this.serverPort;
        if (this.collocated) {
            hostName = "localhost";
            serverPort = -1;
        }
        while (!matching && it.hasNext()) {
            try {
                managedCx = (ManagedConnectionImpl)it.next();
                matching = managedCx.matches(hostName, serverPort, userName, mode);
            }
            catch (ClassCastException exc) {}
        }
        if (matching) {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections managedCx = " + managedCx));
            }
            managedCx.setLogWriter(this.out);
            return managedCx;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public int hashCode() {
        return ("Unified:" + this.hostName + ":" + this.serverPort + "-" + this.userName).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof ManagedConnectionFactoryImpl) || o instanceof ManagedQueueConnectionFactoryImpl || o instanceof ManagedTopicConnectionFactoryImpl) {
            return false;
        }
        ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)o;
        boolean bl = res = this.hostName.equals(other.hostName) && this.serverPort == other.serverPort && this.userName.equals(other.userName);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " equals " + res));
        }
        return res;
    }

    public ResourceAdapter getResourceAdapter() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getResourceAdapter() = " + this.ra));
        }
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter(" + ra + ")"));
        }
        if (this.ra != null) {
            this.out.print("ResourceAdapter instance already associated.");
            throw new javax.resource.spi.IllegalStateException("ResourceAdapter instance already associated.");
        }
        if (!(ra instanceof JoramAdapter)) {
            this.out.print("Provided ResourceAdapter is not a JORAM ResourceAdapter object: " + ra.getClass().getName());
            throw new ResourceException("Provided ResourceAdapter is not a JORAM ResourceAdapter object: " + ra.getClass().getName());
        }
        this.ra = (JoramAdapter)ra;
        this.collocated = ((JoramAdapter)ra).collocated;
        this.isHa = ((JoramAdapter)ra).isHa;
        this.hostName = ((JoramAdapter)ra).hostName;
        this.serverPort = ((JoramAdapter)ra).serverPort;
        this.connectingTimer = ((JoramAdapter)ra).connectingTimer;
        this.txPendingTimer = ((JoramAdapter)ra).txPendingTimer;
        this.cnxPendingTimer = ((JoramAdapter)ra).cnxPendingTimer;
        this.asyncSend = ((JoramAdapter)ra).asyncSend;
        this.multiThreadSync = ((JoramAdapter)ra).multiThreadSync;
        this.multiThreadSyncDelay = ((JoramAdapter)ra).multiThreadSyncDelay;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter collocated = " + this.collocated + ", isHa = " + this.isHa + ", hostName = " + this.hostName + ", serverPort = " + this.serverPort + ", connectingTimer = " + this.connectingTimer + ", txPendingTimer = " + this.txPendingTimer + ", cnxPendingTimer = " + this.cnxPendingTimer));
        }
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getInvalidConnections(" + connectionSet + ")"));
        }
        Iterator it = connectionSet.iterator();
        HashSet<ManagedConnectionImpl> invalidConnections = new HashSet<ManagedConnectionImpl>();
        while (it.hasNext()) {
            try {
                ManagedConnectionImpl managedCx = (ManagedConnectionImpl)it.next();
                if (managedCx.isValid()) continue;
                invalidConnections.add(managedCx);
            }
            catch (ClassCastException exc) {}
        }
        return invalidConnections;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setCollocated(Boolean collocated) {
        this.collocated = collocated;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getCollocated() {
        return new Boolean(this.collocated);
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOutLocalAddress() {
        return this.outLocalAddress;
    }

    public Integer getOutLocalPort() {
        return new Integer(this.outLocalPort);
    }

    public void setOutLocalAddress(String outLocalAddress) {
        this.outLocalAddress = null;
        if (outLocalAddress != null && outLocalAddress.length() > 0) {
            this.outLocalAddress = outLocalAddress;
        }
    }

    public void setOutLocalPort(Integer outLocalPort) {
        this.outLocalPort = outLocalPort;
    }
}

