/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;

public class RdbBlob
extends OutputStream
implements Blob {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    protected int bufferSize = 1024;
    protected ArrayList bufferList = new ArrayList();
    private byte[] currentBuffer;
    private int currentPos;
    protected int size;

    public RdbBlob(Serializable serobj) throws IOException {
        this(serobj, 1024);
    }

    public RdbBlob(Serializable serobj, int buffersize) throws IOException {
        this.bufferSize = buffersize;
        this.currentBuffer = new byte[this.bufferSize];
        this.bufferList.add(this.currentBuffer);
        this.currentPos = 0;
        this.size = 0;
        new ObjectOutputStream(this).writeObject(serobj);
    }

    public long length() throws SQLException {
        this.println("RdbBlob.length()=" + this.size);
        return this.size;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.println("RdbBlob.getBytes(pos=" + pos + ", length=" + length + ")");
        if (pos > (long)this.size) {
            return new byte[0];
        }
        long len = pos + (long)length > (long)this.size ? (long)this.size - pos : (long)length;
        this.println("RdbBlob.getBytes:len=" + len);
        byte[] res = new byte[(int)len];
        long fb = pos / (long)this.bufferSize;
        this.println("RdbBlob.getBytes:fb=" + fb);
        long lb = len / (long)this.bufferSize;
        this.println("RdbBlob.getBytes:lb=" + lb);
        int current = (int)((long)this.bufferSize - pos * (long)this.bufferSize + fb);
        current = (int)((long)current > len ? len : (long)current);
        this.println("RdbBlob.getBytes:current=" + current);
        System.arraycopy(this.bufferList.get((int)fb), (int)(pos - fb * (long)this.bufferSize), res, 0, current);
        for (long i = fb + 1L; i < lb; ++i) {
            System.arraycopy(this.bufferList.get((int)i), 0, res, current, this.bufferSize);
            this.println("RdbBlob.getBytes:current=" + (current += this.bufferSize));
        }
        if (fb != lb) {
            System.arraycopy(this.bufferList.get((int)lb), 0, res, current, res.length - current);
        }
        return res;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.println("RdbBlob.getBinaryStream()");
        return new RdbInputStream(this);
    }

    public long position(byte[] bytes, long l) throws SQLException {
        this.println("RdbBlob.position()");
        if (l > (long)this.size) {
            return -1L;
        }
        if ((long)bytes.length > (long)this.size - l) {
            return -1L;
        }
        int curBufId = (int)l / this.bufferSize;
        int curPos = (int)l % this.bufferSize;
        boolean found = false;
        while (!found || bytes.length - this.size + curPos + curBufId * this.bufferSize <= 0) {
            int i;
            int cp = curPos;
            int cb = curBufId;
            for (i = 0; i < bytes.length && bytes[i] == ((byte[])this.bufferList.get(cb))[cp]; ++i) {
                if (++cp != this.bufferSize) continue;
                cp = 0;
                ++cb;
            }
            if (i == bytes.length) {
                return curPos + curBufId * this.bufferSize;
            }
            if (found || ++curPos != this.bufferSize) continue;
            curPos = 0;
            ++curBufId;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    public void truncate(long len) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    public void close() {
        this.println("RdbBlob.close()");
    }

    public void flush() {
        this.println("RdbBlob.flush()");
    }

    public void write(byte[] b) throws IOException {
        this.println("RdbBlob.write([])");
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.println("RdbBlob.write([], " + off + ", " + len + ")");
        for (int i = off; i < len; ++i) {
            this.write(b[i]);
        }
    }

    public void write(int b) throws IOException {
        this.bprintln("RdbBlob.write(", (byte)b, ")");
        this.currentBuffer[this.currentPos] = (byte)b;
        ++this.size;
        ++this.currentPos;
        if (this.currentPos == this.bufferSize) {
            this.println("New buffer");
            this.currentBuffer = new byte[this.bufferSize];
            this.bufferList.add(this.currentBuffer);
            this.currentPos = 0;
        }
    }

    private void println(String msg) {
    }

    private void bprintln(String msg1, byte b, String msg2) {
    }

    class RdbInputStream
    extends InputStream {
        private RdbBlob blob = null;
        private int bufferId = 0;
        private int cursor = 0;

        RdbInputStream(RdbBlob _blob) {
            this.blob = _blob;
        }

        public int getSize() {
            this.blob.println("RdbInputStream:getSize=" + this.blob.size);
            return this.blob.size;
        }

        public int available() throws IOException {
            this.blob.println("RdbInputStream:available=" + (this.blob.size - (this.bufferId * this.blob.bufferSize + this.cursor)));
            return this.blob.size - (this.bufferId * this.blob.bufferSize + this.cursor);
        }

        public synchronized void mark(int readlimit) {
            this.blob.println("RdbInputStream:mark");
        }

        public synchronized void reset() throws IOException {
            this.blob.println("RdbInputStream:reset");
            throw new IOException("mark/reset not supported");
        }

        public boolean markSupported() {
            this.blob.println("RdbInputStream:markSupported");
            return false;
        }

        public long skip(long n) throws IOException {
            this.blob.println("RdbInputStream:skip");
            if (n <= 0L) {
                return 0L;
            }
            long oldPos = this.bufferId * this.blob.bufferSize + this.cursor;
            long newPos = oldPos + n;
            newPos = newPos >= (long)this.blob.size ? (long)this.blob.size : newPos;
            this.cursor = (int)newPos % this.blob.bufferSize;
            this.bufferId = (int)newPos / this.blob.bufferSize;
            return newPos - oldPos;
        }

        public int read() throws IOException {
            this.blob.println("RdbInputStream:read [bufferId=" + this.bufferId + ", cursor=" + this.cursor + "bufferSize=" + this.blob.bufferSize + "]");
            if (this.bufferId * this.blob.bufferSize + this.cursor == this.blob.size) {
                return -1;
            }
            byte res = ((byte[])this.blob.bufferList.get(this.bufferId))[this.cursor];
            if (++this.cursor == this.blob.bufferSize) {
                this.cursor = 0;
                ++this.bufferId;
            }
            this.blob.bprintln("RdbBlob.read->", res, "");
            return res & 0xFF;
        }
    }
}

