/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.RdbColumnInfo;
import org.objectweb.jorm.mapper.rdb.lib.RdbPPolymorphicClass;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.util.monolog.api.Logger;

public class RdbExtentMappingInfos {
    public static final String NULL_COLUMN = "NULL";
    public static Logger logger;
    public static boolean debug;
    Class clazz;
    private RdbColumnInfo[] columns;
    HashSet joins = new HashSet();
    RdbTable mainTable;
    HashSet filters = new HashSet();
    boolean addFilters = false;
    boolean hasUnmappedFields = false;
    private boolean emptyEMI = true;
    private String name;

    RdbExtentMappingInfos(Class clazz, String name, int nbColumns) {
        this.clazz = clazz;
        this.name = name;
        this.columns = new RdbColumnInfo[nbColumns];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public HashSet getFilters() {
        return this.filters;
    }

    public RdbTable getMainTable() {
        return this.mainTable;
    }

    public void setMainTable(RdbTable mainTable) {
        this.mainTable = mainTable;
    }

    public HashSet getJoins() {
        return this.joins;
    }

    public void addJoin(RdbJoin join) {
        this.joins.add(join);
    }

    public boolean isEmpty() {
        return this.emptyEMI;
    }

    public void addProjection(String tableName, String columnName, String aliasName, String className, int position) {
        if (this.columns[position] != null && this.columns[position].getName() != null && !this.columns[position].getName().equals(NULL_COLUMN)) {
            if (debug) {
                String newExpr = tableName + "." + columnName;
                if (!this.columns[position].getName().equals(newExpr)) {
                    throw new InternalError("expr in select definition (" + newExpr + ") not equal to old one (" + this.columns[position].getName() + ")");
                }
                if (!this.columns[position].getAlias().equals(aliasName)) {
                    throw new InternalError("alias in select definition (" + aliasName + ") not equal to old one (" + this.columns[position].getAlias() + ")");
                }
            }
        } else {
            this.emptyEMI = false;
            this.columns[position] = new RdbColumnInfo(columnName.equals(NULL_COLUMN) ? columnName : tableName + "." + columnName, aliasName, className);
        }
    }

    public String getSelectParameter(String adapterName) {
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < this.columns.length; ++pos) {
            sb.append("\"" + this.columns[pos].getName() + "\" + " + adapterName + ".getColumnAliasExpr(\"" + this.columns[pos].getAlias() + "\")");
            if (pos >= this.columns.length - 1) continue;
            sb.append(" + \",\" + ");
        }
        return sb.toString();
    }

    public String getSelectPrefetch(RdbAdapter adapter, Class cl) {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        if (cl.isPolymorphic()) {
            Arrays.sort(columnsClone);
        } else {
            Arrays.sort(columnsClone, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((RdbColumnInfo)o1).getName().compareTo(((RdbColumnInfo)o2).getName());
                }
            });
        }
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < columnsClone.length; ++pos) {
            sb.append(((RdbColumnInfo)columnsClone[pos]).getName() + " " + adapter.getColumnAliasExpr(((RdbColumnInfo)columnsClone[pos]).getAlias()));
            if (pos >= columnsClone.length - 1) continue;
            sb.append(" , ");
        }
        return sb.toString();
    }

    public String getSelectPKOnly(RdbAdapter adapter, String primaryKey) {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        Arrays.sort(columnsClone);
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < columnsClone.length; ++pos) {
            if (primaryKey.indexOf(((RdbColumnInfo)columnsClone[pos]).getName()) == -1) continue;
            sb.append(((RdbColumnInfo)columnsClone[pos]).getName() + " " + adapter.getColumnAliasExpr(((RdbColumnInfo)columnsClone[pos]).getAlias()));
            if (pos >= columnsClone.length - 1) continue;
            sb.append(" , ");
        }
        return sb.toString();
    }

    public String getSelectPKAndFields(RdbAdapter adapter, Class cl) {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        if (cl.isPolymorphic()) {
            Arrays.sort(columnsClone);
        } else {
            Arrays.sort(columnsClone, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((RdbColumnInfo)o1).getName().compareTo(((RdbColumnInfo)o2).getName());
                }
            });
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> superClasses = new ArrayList<String>();
        superClasses.add(cl.getFQName());
        Iterator it = cl.getAncestors().iterator();
        while (it.hasNext()) {
            Class c = (Class)it.next();
            superClasses.add(c.getFQName());
        }
        for (int pos = 0; pos < columnsClone.length; ++pos) {
            if (!superClasses.contains(((RdbColumnInfo)columnsClone[pos]).getClassName())) continue;
            sb.append(((RdbColumnInfo)columnsClone[pos]).getName() + " " + adapter.getColumnAliasExpr(((RdbColumnInfo)columnsClone[pos]).getAlias()));
            if (pos >= columnsClone.length - 1) continue;
            sb.append(" , ");
        }
        return sb.toString();
    }

    public String getWhereParameter(PClassMapping pcm) {
        if (pcm != null && pcm instanceof RdbPPolymorphicClass && this.addFilters) {
            StringBuffer sb = new StringBuffer();
            ((RdbPPolymorphicClass)((Object)pcm)).appendExtentFilters(this.name, sb);
            return sb.toString();
        }
        return null;
    }

    public String getAliasName(int position) {
        if (position >= 0 && position < this.columns.length && this.columns[position] != null) {
            return this.columns[position].getAlias();
        }
        return null;
    }

    public Collection getColumnAliases(boolean prefetch, String primaryKey, Class cl) {
        if (prefetch) {
            return this.getColumnAliasesPrefetch();
        }
        if (cl == null) {
            return this.getColumnAliasesPKOnly(primaryKey);
        }
        return this.getColumnAliasesPKAndFields(cl);
    }

    private Collection getColumnAliasesPrefetch() {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        Arrays.sort(columnsClone);
        ArrayList<String> c = new ArrayList<String>();
        for (int i = 0; i < columnsClone.length; ++i) {
            c.add(((RdbColumnInfo)columnsClone[i]).getAlias());
        }
        return c;
    }

    private Collection getColumnAliasesPKOnly(String primaryKey) {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        Arrays.sort(columnsClone);
        ArrayList<String> c = new ArrayList<String>();
        for (int i = 0; i < columnsClone.length; ++i) {
            if (primaryKey.indexOf(((RdbColumnInfo)columnsClone[i]).getName()) == -1) continue;
            c.add(((RdbColumnInfo)columnsClone[i]).getAlias());
        }
        return c;
    }

    public Collection getColumnAliasesPKAndFields(Class cl) {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        Arrays.sort(columnsClone);
        ArrayList<String> c = new ArrayList<String>();
        ArrayList<String> superClasses = new ArrayList<String>();
        superClasses.add(cl.getFQName());
        Iterator it = cl.getAncestors().iterator();
        while (it.hasNext()) {
            Class currentClass = (Class)it.next();
            superClasses.add(currentClass.getFQName());
        }
        for (int pos = 0; pos < columnsClone.length; ++pos) {
            if (!superClasses.contains(((RdbColumnInfo)columnsClone[pos]).getClassName())) continue;
            c.add(((RdbColumnInfo)columnsClone[pos]).getAlias());
        }
        return c;
    }

    public Collection getColumnClasses() {
        Object[] columnsClone = new RdbColumnInfo[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsClone[i] = this.columns[i];
        }
        Arrays.sort(columnsClone);
        ArrayList<String> columnClasses = new ArrayList<String>();
        for (int i = 0; i < columnsClone.length; ++i) {
            columnClasses.add(((RdbColumnInfo)columnsClone[i]).getClassName());
        }
        return columnClasses;
    }

    public boolean mappingDone(int pos) {
        return this.columns[pos] != null && this.columns[pos].getName() != null;
    }

    public boolean mappingNull(int pos) {
        return this.columns[pos] == null || this.columns[pos].getName().equals(NULL_COLUMN);
    }

    public boolean hasJoins() {
        return !this.joins.isEmpty();
    }

    static {
        debug = false;
    }
}

